/*
 * Decompiled with CFR 0.152.
 */
package yt4droid.http;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import yt4droid.conf.Configuration;
import yt4droid.http.HttpClient;

public class HttpClientFactory {
    private static final Constructor HTTP_CLIENT_CONSTRUCTOR;
    private static final String HTTP_CLIENT_IMPLEMENTATION = "yt4droid.http.httpClient";

    static {
        Class<?> clazz = null;
        String httpClientImpl = System.getProperty(HTTP_CLIENT_IMPLEMENTATION);
        if (httpClientImpl != null) {
            try {
                clazz = Class.forName(httpClientImpl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            try {
                clazz = Class.forName("yt4droid.http.HttpClientImpl");
            }
            catch (ClassNotFoundException cnfe) {
                throw new AssertionError((Object)cnfe);
            }
        }
        try {
            HTTP_CLIENT_CONSTRUCTOR = clazz.getConstructor(Configuration.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new AssertionError((Object)nsme);
        }
    }

    public static HttpClient getInstance(Configuration conf) {
        try {
            return (HttpClient)HTTP_CLIENT_CONSTRUCTOR.newInstance(conf);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }
}

