/*
 * Decompiled with CFR 0.152.
 */
package yt4droid.conf;

public class RatingsParameter {
    private int rating;
    protected final int MAXRATING = 5;
    protected final int MINRATING = 1;
    private String likeParameter;

    private RatingsParameter(int rating) {
        this.rating = rating;
    }

    private RatingsParameter(String likeParameter) {
        this.likeParameter = likeParameter;
    }

    public boolean isLikeRating() {
        return this.rating == 0;
    }

    public String getRating() {
        return String.valueOf(this.rating);
    }

    public String getMaxRating() {
        return String.valueOf(5);
    }

    public String getMinRating() {
        return String.valueOf(1);
    }

    public String getLikeParameter() {
        return this.likeParameter;
    }

    public static RatingsParameter createRating(int rating) {
        if (rating == 0) {
            throw new IllegalStateException("Rating is higher than 0.");
        }
        return new RatingsParameter(rating);
    }

    public static RatingsParameter createRating(LIKEPARAMETER param) {
        return new RatingsParameter(LIKEPARAMETER.asString(param));
    }

    public static enum LIKEPARAMETER {
        LIKE,
        DISLIKE;


        protected static String asString(LIKEPARAMETER param) {
            switch (param) {
                case LIKE: {
                    return "like";
                }
                case DISLIKE: {
                    return "dislike";
                }
            }
            return null;
        }
    }
}

