/*
 * Decompiled with CFR 0.152.
 */
package yt4droid.conf;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import yt4droid.conf.Configuration;
import yt4droid.http.UploadVideoListener;

public class ConfigurationBase
implements Configuration {
    private boolean isDalvik;
    private String oAuthAccessTokenURL;
    private Map<String, String> requestHeaders;
    private boolean useSSL;
    private String userAgent;
    private String clientId;
    private String developerKey;
    private String gdataVersion;
    private int httpRetryCount;
    private int httpRetryIntervalSeconds;
    private String httpProxyHost;
    private String httpProxyUser;
    private String httpProxyPassword;
    private int httpProxyPort;
    private int httpConnectionTimeout;
    private int httpReadTimeout;
    private boolean gZipEnabled;
    private static final String DEFAULT_OAUTH_ACCESS_TOKEN_URL = "https://www.google.com/youtube/accounts/ClientLogin";
    private static final String DEFAULT_UPLOAD_URL = "http://uploads.gdata.youtube.com/resumable/feeds/api/users/default/uploads";
    private static final String DEFAULT_FEEDS_URL = "http://gdata.youtube.com/feeds/api";
    private static final String DEFAULT_USERS_FEEDS_URL1 = "http://gdata.youtube.com/feeds/api/users/";
    private static final String DEFAULT_USERS_FEEDS_URL2 = "/uploads";
    private static final String DEFAULT_COMMENT_URL1 = "http://gdata.youtube.com/feeds/api/videos/";
    private static final String DEFAULT_COMMENT_URL2 = "/comments";
    private static final String DEFAULT_RATINGS_URL1 = "http://gdata.youtube.com/feeds/api/videos/";
    private static final String DEFAULT_RATINGS_URL2 = "/ratings";
    private static final String DEFAULT_VIDEO_UPDATE_URL1 = "http://gdata.youtube.com/feeds/api/users/";
    private static final String DEFAULT_VIDEO_UPDATE_URL2 = "/uploads/";
    private static final String DEFAULT_USERPROFILE_URL = "http://gdata.youtube.com/feeds/api/users/";
    private static final String DEFAULT_CONTACT_URL1 = "http://gdata.youtube.com/feeds/api/users/";
    private static final String DEFAULT_CONTACT_URL2 = "default/contacts";
    private static final String DEFAULT_CONTACT_URL3 = "/contacts";
    public static final String DALVIK = "yt.dalvik";
    private boolean IS_DALVIK;
    static String dalvikDetected;
    private String baseUploadURL;
    private int bufferSize;
    private int chunkBufferSize;
    private String baseFeedsURL;
    private UploadVideoListener uploadListener;
    private int totalBytesUpload;
    private static ConfigurationBase singleton;
    private static final List<ConfigurationBase> instances;

    static {
        try {
            Class.forName("dalvik.system.VMRuntime");
            dalvikDetected = "true";
        }
        catch (ClassNotFoundException cnfe) {
            dalvikDetected = "false";
        }
        singleton = new ConfigurationBase();
        instances = new ArrayList<ConfigurationBase>();
    }

    public static ConfigurationBase getInstance() {
        return singleton;
    }

    private ConfigurationBase() {
        String isDalvik;
        this.setGZIPEnabled(true);
        this.setOAuthAccessTokenURL(DEFAULT_OAUTH_ACCESS_TOKEN_URL);
        this.setBaseUploadURL(DEFAULT_UPLOAD_URL);
        this.setGdataVersion("2");
        this.setUserAgent("yt4droid http://yt4droid.org/ /1.0.0");
        this.setBufferSize(1024);
        this.setChunkBufferSize(0x300000);
        this.setBaseFeedsURL(DEFAULT_FEEDS_URL);
        try {
            isDalvik = System.getProperty(DALVIK, dalvikDetected);
        }
        catch (SecurityException ignore) {
            isDalvik = dalvikDetected;
        }
        this.IS_DALVIK = Boolean.valueOf(isDalvik);
    }

    @Override
    public boolean isDalvik() {
        return this.isDalvik;
    }

    @Override
    public String getOAuthAccessTokenURL() {
        return this.oAuthAccessTokenURL;
    }

    protected final void setOAuthAccessTokenURL(String oAuthAccessTokenURL) {
        this.oAuthAccessTokenURL = oAuthAccessTokenURL;
    }

    private void initRequestHeaders() {
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("GData-Version", this.getGdataVersion());
        this.requestHeaders.put("X-GData-Client", this.getClientId());
        this.requestHeaders.put("X-GData-Key", String.format("key=%s", this.getDeveloperKey()));
        this.requestHeaders.put("User-Agent", this.getUserAgent());
        if (this.gZipEnabled) {
            this.requestHeaders.put("Accept-Encoding", "gzip");
        }
        if (this.IS_DALVIK) {
            this.requestHeaders.put("Connection", "close");
        }
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    protected final void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
        this.fixRestBaseURL();
    }

    private void fixRestBaseURL() {
        if (DEFAULT_OAUTH_ACCESS_TOKEN_URL.equals(ConfigurationBase.fixURL(false, this.oAuthAccessTokenURL))) {
            this.oAuthAccessTokenURL = ConfigurationBase.fixURL(this.useSSL, this.oAuthAccessTokenURL);
        }
    }

    static String fixURL(boolean useSSL, String url) {
        if (url == null) {
            return null;
        }
        int index = url.indexOf("://");
        if (-1 == index) {
            throw new IllegalArgumentException("url should contain '://'");
        }
        String hostAndLater = url.substring(index + 3);
        if (useSSL) {
            return "https://" + hostAndLater;
        }
        return "http://" + hostAndLater;
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    protected void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        this.initRequestHeaders();
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    protected void setClientId(String clientId) {
        this.clientId = clientId;
        this.initRequestHeaders();
    }

    @Override
    public String getDeveloperKey() {
        return this.developerKey;
    }

    protected void setDeveloperKey(String developerKey) {
        this.developerKey = developerKey;
        this.initRequestHeaders();
    }

    protected final void setGZIPEnabled(boolean gZipEnabled) {
        this.gZipEnabled = gZipEnabled;
    }

    public boolean getGZIPEnabled() {
        return this.gZipEnabled;
    }

    @Override
    public int getHttpRetryCount() {
        return this.httpRetryCount;
    }

    protected void setHttpRetryCount(int httpRetryCount) {
        this.httpRetryCount = httpRetryCount;
    }

    @Override
    public int getHttpRetryIntervalSeconds() {
        return this.httpRetryIntervalSeconds;
    }

    protected void setHttpRetryIntervalSeconds(int httpRetryIntervalSeconds) {
        this.httpRetryIntervalSeconds = httpRetryIntervalSeconds;
    }

    @Override
    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    protected void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    @Override
    public int getHttpProxyPort() {
        return this.httpProxyPort;
    }

    protected void setHttpProxyPort(int httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    @Override
    public String getHttpProxyUser() {
        return this.httpProxyUser;
    }

    protected void setHttpProxyUser(String httpProxyUser) {
        this.httpProxyUser = httpProxyUser;
    }

    @Override
    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    protected void setHttpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
    }

    @Override
    public int getHttpConnectionTimeout() {
        return this.httpConnectionTimeout;
    }

    protected void setHttpConnectionTimeout(int httpConnectionTimeout) {
        this.httpConnectionTimeout = httpConnectionTimeout;
    }

    @Override
    public int getHttpReadTimeout() {
        return this.httpReadTimeout;
    }

    protected void setHttpReadTimeout(int httpReadTimeout) {
        this.httpReadTimeout = httpReadTimeout;
    }

    private static void cacheInstance(ConfigurationBase conf) {
        if (!instances.contains(conf)) {
            instances.add(conf);
        }
    }

    protected void cacheInstance() {
        ConfigurationBase.cacheInstance(this);
    }

    private static ConfigurationBase getInstance(ConfigurationBase configurationBase) {
        int index = instances.indexOf(configurationBase);
        if (index == -1) {
            instances.add(configurationBase);
            return configurationBase;
        }
        return instances.get(index);
    }

    protected Object readResolve() throws ObjectStreamException {
        return ConfigurationBase.getInstance(this);
    }

    @Override
    public String getBaseUploadURL() {
        return this.baseUploadURL;
    }

    protected void setBaseUploadURL(String baseUploadURL) {
        this.baseUploadURL = baseUploadURL;
    }

    @Override
    public void setGdataVersion(String version) {
        this.gdataVersion = version;
    }

    protected String getGdataVersion() {
        return this.gdataVersion;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    protected void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public UploadVideoListener getUploadListener() {
        return this.uploadListener;
    }

    protected void setUploadListener(UploadVideoListener uploadListener) {
        this.uploadListener = uploadListener;
    }

    @Override
    public int getChunkBufferSize() {
        return this.chunkBufferSize;
    }

    protected void setChunkBufferSize(int chunkBufferSize) {
        this.chunkBufferSize = chunkBufferSize;
    }

    @Override
    public String getBaseFeedsURL() {
        return this.baseFeedsURL;
    }

    protected void setBaseFeedsURL(String baseFeedsURL) {
        this.baseFeedsURL = baseFeedsURL;
    }

    @Override
    public String getBaseFeedsURL(String userName) {
        return "http://gdata.youtube.com/feeds/api/users/" + userName + DEFAULT_USERS_FEEDS_URL2;
    }

    @Override
    public String getBaseCommentsURL(String videoId) {
        return "http://gdata.youtube.com/feeds/api/videos/" + videoId + DEFAULT_COMMENT_URL2;
    }

    @Override
    public String getBaseRatingsURL(String videoId) {
        return "http://gdata.youtube.com/feeds/api/videos/" + videoId + DEFAULT_RATINGS_URL2;
    }

    @Override
    public String getBaseVideoUpdateURL(String videoId, String userId) {
        return "http://gdata.youtube.com/feeds/api/users/" + userId + DEFAULT_VIDEO_UPDATE_URL2 + videoId;
    }

    @Override
    public String getBaseUserProfileURL(String userId) {
        return "http://gdata.youtube.com/feeds/api/users/" + userId;
    }

    @Override
    public String getBaseContactURL() {
        return "http://gdata.youtube.com/feeds/api/users/default/contacts";
    }

    @Override
    public String getBaseContactURL(String userName) {
        return "http://gdata.youtube.com/feeds/api/users/" + userName + DEFAULT_CONTACT_URL3;
    }

    @Override
    public String getBaseContactURL(String userName, String contactId) {
        return "http://gdata.youtube.com/feeds/api/users/" + userName + DEFAULT_CONTACT_URL3 + "/" + contactId;
    }

    @Override
    public int getTotalBytesUpload() {
        return this.totalBytesUpload;
    }

    @Override
    public void setTotalBytesUpload(int totalBytesUpload) {
        this.totalBytesUpload = totalBytesUpload;
    }
}

