/*
 * Decompiled with CFR 0.152.
 */
package yt4droid;

import yt4droid.Youtube;
import yt4droid.YoutubeImpl;
import yt4droid.auth.AccessToken;
import yt4droid.auth.Authorization;
import yt4droid.auth.AuthorizationFactory;
import yt4droid.auth.OAuthAuthorization;
import yt4droid.conf.Configuration;
import yt4droid.conf.ConfigurationBase;

public class YoutubeFactory {
    static final Authorization DEFAULT_AUTHORIZATION = AuthorizationFactory.getInstance(ConfigurationBase.getInstance());
    private static final Youtube SINGLETON = new YoutubeImpl(ConfigurationBase.getInstance(), DEFAULT_AUTHORIZATION);
    private final Configuration conf;

    public YoutubeFactory() {
        this(ConfigurationBase.getInstance());
    }

    public YoutubeFactory(Configuration conf) {
        if (conf == null) {
            throw new NullPointerException("configuration cannot be null");
        }
        this.conf = conf;
    }

    public Youtube getInstance() {
        return this.getInstance(AuthorizationFactory.getInstance(this.conf));
    }

    public Youtube getInstance(AccessToken accessToken) {
        OAuthAuthorization oauth = new OAuthAuthorization(this.conf);
        oauth.setAuthAccessToken(accessToken);
        return this.getInstance(oauth);
    }

    private Youtube getInstance(Authorization auth) {
        return new YoutubeImpl(this.conf, auth);
    }

    public static Youtube getSingleton() {
        return SINGLETON;
    }
}

