/*
 * Decompiled with CFR 0.152.
 */
package yt4droid;

import java.util.List;
import yt4droid.http.HttpResponceCode;
import yt4droid.http.HttpResponse;

public class YoutubeException
extends Exception
implements HttpResponceCode {
    private static final long serialVersionUID = -2664036770132895143L;
    private int statusCode = -1;
    private HttpResponse response;
    private String errorMessage = null;

    public YoutubeException(String message, Throwable cause) {
        super(message, cause);
    }

    public YoutubeException(HttpResponse res) {
        this("statusCode:" + String.valueOf(res.getStatusCode()) + " responsed by Youtube.");
    }

    public YoutubeException(String message) {
        this(message, (Throwable)null);
    }

    public String getResponseHeader(String name) {
        List<String> header;
        String value = null;
        if (this.response != null && (header = this.response.getResponseHeaderFields().get(name)).size() > 0) {
            value = header.get(0);
        }
        return value;
    }

    public YoutubeException(String message, HttpResponse res) {
        this(message);
        this.response = res;
        if (res != null) {
            this.statusCode = res.getStatusCode();
        }
    }

    public YoutubeException(Exception cause, HttpResponse res) {
        this(cause.getMessage(), cause);
        if (res != null) {
            this.statusCode = res.getStatusCode();
        }
    }

    @Override
    public String getMessage() {
        StringBuffer value = new StringBuffer();
        if (this.errorMessage != null) {
            value.append("error - ").append(this.errorMessage).append("\n");
        } else {
            value.append(super.getMessage());
        }
        if (this.statusCode != -1) {
            return String.valueOf(YoutubeException.getCause(this.statusCode)) + "\n" + value.toString();
        }
        return value.toString();
    }

    private static String getCause(int statusCode) {
        String cause;
        switch (statusCode) {
            case 403: {
                cause = "There was no new data to return.";
                break;
            }
            default: {
                cause = "";
            }
        }
        return String.valueOf(statusCode) + ":" + cause;
    }
}

