/*
 * Decompiled with CFR 0.152.
 */
package yt4droid;

import java.io.File;
import yt4droid.YoutubeBase;
import yt4droid.YoutubeException;
import yt4droid.auth.AccessToken;
import yt4droid.auth.Auth;
import yt4droid.auth.Authorization;
import yt4droid.conf.Configuration;
import yt4droid.http.HttpClientWrapper;
import yt4droid.parser.ParserFactory;

public class YoutubeBaseImpl
implements YoutubeBase,
Auth {
    protected Authorization auth;
    protected Configuration conf;
    protected ParserFactory factory;
    protected HttpClientWrapper http;

    YoutubeBaseImpl(Configuration conf, Authorization auth) {
        this.conf = conf;
        this.auth = auth;
        this.init();
    }

    private void init() {
        this.setFactory();
        this.http = new HttpClientWrapper(this.conf);
    }

    protected void setFactory() {
        this.factory = new ParserFactory(this.conf);
    }

    @Override
    public AccessToken getAuthAccessToken(String email, String password) throws YoutubeException {
        return this.getOAuth().getAuthAccessToken(email, password);
    }

    @Override
    public void setAuthAccessToken(AccessToken accessToken) {
        this.getOAuth().setAuthAccessToken(accessToken);
    }

    private Auth getOAuth() {
        return (Auth)((Object)this.auth);
    }

    protected void isAuthEnabled() {
        if (!this.auth.isEnabled()) {
            throw new IllegalStateException("not Authentication.");
        }
    }

    @Override
    public Authorization getAuthorization() {
        return this.auth;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    public File getFile(String filePath) {
        if (filePath != null) {
            return new File(filePath);
        }
        return null;
    }
}

