/*
 * Decompiled with CFR 0.152.
 */
package yt4droid;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import yt4droid.ResponseList;
import yt4droid.YoutubeException;
import yt4droid.http.HttpResponse;
import yt4droid.internal.org.json.JSONException;
import yt4droid.internal.org.json.JSONObject;
import yt4droid.util.ParseUtil;

public class ResponseListImpl<T>
extends ArrayList<T>
implements ResponseList<T> {
    private static final long serialVersionUID = 2630046341364208610L;
    private Date parentUpdated;
    private int totalItems;
    private int startIndex;
    private int itemsPerPage;

    public ResponseListImpl(int size, HttpResponse res) throws YoutubeException {
        super(size);
        this.init(res);
    }

    public ResponseListImpl(int size, Map<String, String> feedMap) throws YoutubeException {
        super(size);
        this.initAsXML(feedMap);
    }

    private void initAsXML(Map<String, String> feedMap) throws YoutubeException {
        this.parentUpdated = ParseUtil.parseDate(feedMap.get("updated"));
        this.totalItems = ParseUtil.getInt(feedMap.get("openSearch:totalResults"));
        this.startIndex = ParseUtil.getInt(feedMap.get("openSearch:startIndex"));
        this.itemsPerPage = ParseUtil.getInt(feedMap.get("openSearch:itemsPerPage"));
    }

    private void init(HttpResponse res) throws YoutubeException {
        JSONObject json = res.asJSONObject();
        JSONObject dataObject = null;
        try {
            dataObject = json.getJSONObject("data");
        }
        catch (JSONException e) {
            throw new YoutubeException(e, res);
        }
        this.parentUpdated = ParseUtil.parseDate(ParseUtil.getRawString("updated", dataObject));
        this.totalItems = ParseUtil.getInt("totalItems", dataObject);
        this.startIndex = ParseUtil.getInt("startIndex", dataObject);
        this.itemsPerPage = ParseUtil.getInt("itemsPerPage", dataObject);
    }

    @Override
    public Date getUpdated() {
        return this.parentUpdated;
    }

    @Override
    public int getTotalItems() {
        return this.totalItems;
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public int getItemsPerPage() {
        return this.itemsPerPage;
    }
}

