/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.vo;

public class TestCaseVO {
    public static final int TEST_SUCCESS = 1;
    public static final int TEST_ERROR = 2;
    public static final int TEST_FAILURE = 3;
    private String className;
    private String name;
    private int testResult;
    private String trace;
    private long time;

    public TestCaseVO(String className, String methodName, int testResult, String trace, long time) {
        this.className = className;
        this.name = methodName;
        this.testResult = testResult;
        this.trace = trace;
        this.time = time;
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public long getTime() {
        return this.time;
    }

    public double getTimeInSecond() {
        return (double)this.time / 1000.0;
    }

    public boolean isSuccess() {
        return this.testResult == 1;
    }

    public boolean isError() {
        return this.testResult == 2;
    }

    public boolean isFailure() {
        return this.testResult == 3;
    }

    public String getMessage() {
        String line = this.traceFirstLine();
        int index = line.indexOf(58);
        if (index == -1) {
            return null;
        }
        return line.substring(index + 1).trim();
    }

    public String getType() {
        String line = this.traceFirstLine();
        int index = line.indexOf(58);
        if (index == -1) {
            return line;
        }
        return line.substring(0, index);
    }

    public String getTrace() {
        return this.trace;
    }

    private String traceFirstLine() {
        int index = this.trace.indexOf(10);
        if (index != -1) {
            return this.trace.substring(0, index);
        }
        return this.trace;
    }
}

