/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.utils;

import java.io.File;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class DomUtils {
    private DomUtils() {
    }

    public static Document newDocument() throws ParserConfigurationException {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
    }

    public static void outputXMLFile(Document doc, String fileName, String encoding) throws TransformerException {
        DOMSource source = new DOMSource(doc);
        File output = new File(fileName);
        File outputDir = output.getParentFile();
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        StreamResult result = new StreamResult(output);
        TransformerFactory tfFactory = TransformerFactory.newInstance();
        Transformer transformer = tfFactory.newTransformer();
        transformer.setOutputProperty("encoding", encoding);
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
    }

    public static Element createElement(Element element, String tag) {
        Document document = element.getOwnerDocument();
        Element child = document.createElement(tag);
        element.appendChild(child);
        return child;
    }

    public static Element createElement(Document document, String tag) {
        Element child = document.createElement(tag);
        document.appendChild(child);
        return child;
    }

    public static Text createTextNode(Element element, String str) {
        Document document = element.getOwnerDocument();
        Text text = document.createTextNode(str);
        element.appendChild(text);
        return text;
    }
}

