/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.preference;

import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.JUnitReporterActivator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class JUnitReporterPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button kindNoFrame;
    private Button kindFrame;
    private Button kindCustom;
    private Composite custom;
    private Text xsltPath;
    private Button typeFile;
    private Button typeDir;

    public JUnitReporterPreferencePage() {
    }

    public JUnitReporterPreferencePage(String title) {
        super(title);
    }

    public JUnitReporterPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        this.create(parent);
        this.initValue();
        return null;
    }

    private void initValue() {
        IPreferenceStore store = JUnitReporterActivator.getDefault().getPreferenceStore();
        int kind = store.getInt("xslt.kind");
        if (kind == 1) {
            this.kindNoFrame.setSelection(true);
            this.changeCustomEnable(false);
        } else if (kind == 2) {
            this.kindFrame.setSelection(true);
            this.changeCustomEnable(false);
        } else if (kind == 3) {
            this.kindCustom.setSelection(true);
            this.xsltPath.setText(store.getString("xslt.custompath"));
            int type = store.getInt("xslt.customtype");
            if (type == 1) {
                this.typeFile.setSelection(true);
            } else if (type == 2) {
                this.typeDir.setSelection(true);
            }
            this.changeCustomEnable(true);
        }
    }

    private void create(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)new GridData(1808));
        Group group = new Group(composite, 0);
        group.setText("select report style");
        group.setLayout((Layout)new GridLayout(1, true));
        group.setLayoutData((Object)new GridData(768));
        this.kindNoFrame = new Button((Composite)group, 16);
        this.kindNoFrame.setText("Ant no-frame");
        this.kindFrame = new Button((Composite)group, 16);
        this.kindFrame.setText("Ant frames");
        this.kindCustom = new Button((Composite)group, 16);
        this.kindCustom.setText("custom");
        this.kindCustom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JUnitReporterPreferencePage.this.changeCustomEnable(JUnitReporterPreferencePage.this.kindCustom.getSelection());
            }
        });
        this.custom = new Composite((Composite)group, 0);
        this.custom.setLayout((Layout)new GridLayout(5, true));
        GridData customCompData = new GridData(1808);
        customCompData.horizontalIndent = 10;
        this.custom.setLayoutData((Object)customCompData);
        this.xsltPath = new Text(this.custom, 2052);
        GridData pathData = new GridData(768);
        pathData.horizontalSpan = 4;
        this.xsltPath.setLayoutData((Object)pathData);
        Button dialogButton = new Button(this.custom, 8);
        dialogButton.setText("file...");
        dialogButton.setLayoutData((Object)new GridData(768));
        dialogButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(JUnitReporterActivator.getShell(), 4096);
                String path = dialog.open();
                if (path == null) {
                    return;
                }
                JUnitReporterPreferencePage.this.xsltPath.setText(path);
            }
        });
        this.typeFile = new Button(this.custom, 16);
        this.typeFile.setText("file type");
        this.typeDir = new Button(this.custom, 16);
        this.typeDir.setText("dir type");
    }

    private void changeCustomEnable(boolean enable) {
        this.custom.setEnabled(enable);
    }

    public boolean performOk() {
        IPreferenceStore store = JUnitReporterActivator.getDefault().getPreferenceStore();
        int xsltKind = 0;
        if (this.kindNoFrame.getSelection()) {
            xsltKind = 1;
        } else if (this.kindFrame.getSelection()) {
            xsltKind = 2;
        } else if (this.kindCustom.getSelection()) {
            xsltKind = 3;
        }
        store.setValue("xslt.kind", xsltKind);
        if (this.kindCustom.getSelection()) {
            store.setValue("xslt.custompath", this.xsltPath.getText());
            int type = 0;
            type = this.typeFile.getSelection() ? 1 : 2;
            store.setValue("xslt.customtype", type);
        }
        JUnitReporterActivator.getDefault().savePluginPreferences();
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
    }
}

