/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.vo.TestCaseVO;
import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.vo.TestSuiteVO;
import org.eclipse.jdt.internal.junit.model.ITestRunSessionListener;
import org.eclipse.jdt.internal.junit.model.ITestSessionListener;
import org.eclipse.jdt.internal.junit.model.TestCaseElement;
import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.jdt.internal.junit.model.TestRunSession;
import org.eclipse.jdt.internal.junit.model.TestSuiteElement;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.ui.IStartup;

public class TestListener
implements IStartup {
    private static TestListener instance;
    private Hashtable testResults = new Hashtable();
    private boolean testRunning = false;

    private void cacheTestResult(TestCaseElement test, long time) {
        TestSuiteElement parent = test.getParent();
        TestSuiteVO suite = (TestSuiteVO)this.testResults.get(parent.getId());
        if (suite == null) {
            suite = new TestSuiteVO(parent.getId(), parent.getTestName());
            this.testResults.put(parent.getId(), suite);
        }
        int testResult = 0;
        TestElement.Status status = test.getStatus();
        if (status.isOK()) {
            testResult = 1;
        } else if (status.isError()) {
            testResult = 2;
        } else if (status.isFailure()) {
            testResult = 3;
        }
        TestCaseVO testCase = new TestCaseVO(test.getClassName(), test.getTestMethodName(), testResult, test.getTrace(), time);
        suite.addTestCase(testCase);
    }

    public Map getTestResults() {
        return (Map)this.testResults.clone();
    }

    private void clearTestResult() {
        this.testResults.clear();
    }

    public boolean isTestRunning() {
        return this.testRunning;
    }

    private void setTestRunning(boolean testRunning) {
        this.testRunning = testRunning;
    }

    public void earlyStartup() {
        instance = this;
        JUnitPlugin.getModel().addTestRunSessionListener((ITestRunSessionListener)new TestRunSessionListener());
    }

    public static TestListener getInstance() {
        return instance;
    }

    private class TestRunSessionListener
    implements ITestRunSessionListener {
        private ITestSessionListener testSession;

        private TestRunSessionListener() {
            this.testSession = new TestSessionListener();
        }

        public void sessionAdded(TestRunSession testRunSession) {
            if (testRunSession == null) {
                return;
            }
            testRunSession.addTestSessionListener(this.testSession);
        }

        public void sessionRemoved(TestRunSession testRunSession) {
            if (testRunSession == null) {
                return;
            }
            testRunSession.removeTestSessionListener(this.testSession);
        }
    }

    private class TestSessionListener
    implements ITestSessionListener {
        private Map testTimes = new HashMap();

        private TestSessionListener() {
        }

        public void sessionEnded(long elapsedTime) {
            TestListener.this.setTestRunning(false);
        }

        public void sessionStarted() {
            TestListener.this.clearTestResult();
            TestListener.this.setTestRunning(true);
        }

        public void sessionStopped(long elapsedTime) {
            TestListener.this.setTestRunning(false);
        }

        public void sessionTerminated() {
        }

        public void testAdded(TestElement testElement) {
        }

        public void testEnded(TestCaseElement testCaseElement) {
            Long startTime = (Long)this.testTimes.get(testCaseElement.getId());
            long start = 0L;
            if (startTime != null) {
                start = startTime;
                this.testTimes.remove(testCaseElement.getId());
            } else {
                start = System.currentTimeMillis();
            }
            long end = System.currentTimeMillis();
            long testTime = end - start;
            TestListener.this.cacheTestResult(testCaseElement, testTime);
        }

        public void testStarted(TestCaseElement testCaseElement) {
            this.testTimes.put(testCaseElement.getId(), new Long(System.currentTimeMillis()));
        }

        public void testFailed(TestElement testElement, TestElement.Status status, String trace, String expected, String actual) {
        }

        public void testReran(TestCaseElement testCaseElement, TestElement.Status status, String trace, String expectedResult, String actualResult) {
        }
    }
}

