/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter;

import java.io.File;
import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.JUnitReporterActivator;
import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.ReportProperty;
import org.eclipse.jface.preference.IPreferenceStore;

public class ReportPropertyHelper {
    public static final String KEY_XSLT_KIND = "xslt.kind";
    public static final int XSLT_KIND_NOFRAME = 1;
    public static final int XSLT_KIND_FRAME = 2;
    public static final int XSLT_KIND_CUSTOM = 3;
    public static final String KEY_CUSTOM_PATH = "xslt.custompath";
    public static final String KEY_CUSTOM_TYPE = "xslt.customtype";
    public static final int TYPE_FILE = 1;
    public static final int TYPE_DIR = 2;
    private static final String FRAMES_XSLT = "junit-frames.xsl";
    private static final String NOFRAMES_XSLT = "junit-noframes.xsl";

    public static ReportProperty createReportProperty() {
        IPreferenceStore store = JUnitReporterActivator.getDefault().getPreferenceStore();
        int kind = store.getInt(KEY_XSLT_KIND);
        if (kind == 1) {
            return new AntNoFrameProperty();
        }
        if (kind == 2) {
            return new AntFrameProperty();
        }
        if (kind == 3) {
            String xslt = store.getString(KEY_CUSTOM_PATH);
            int type = store.getInt(KEY_CUSTOM_TYPE);
            return new ReportProperty(type, new File(xslt));
        }
        return new AntFrameProperty();
    }

    private static class AntFrameProperty
    extends ReportProperty {
        public AntFrameProperty() {
            super(2, JUnitReporterActivator.getAntStyle(ReportPropertyHelper.FRAMES_XSLT));
        }
    }

    private static class AntNoFrameProperty
    extends ReportProperty {
        public AntNoFrameProperty() {
            super(1, JUnitReporterActivator.getAntStyle(ReportPropertyHelper.NOFRAMES_XSLT));
        }
    }
}

