<?php
// $Id: Init.class.php,v 1.5 2011/03/28 10:04:31 ohwada Exp $

//=========================================================
// Twitter Netcommons
// K.OHWADA 2010-08-01
//=========================================================

//---------------------------------------------------------
// change log
// 2011-03-01 K.OHWADA
// get_init_userid_or_exauthentry()
//---------------------------------------------------------

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons View
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

include_once BASE_DIR."/webapp/modules/twitter/components/Service.class.php";

class Twitter_View_Main_Init extends Action
{
	// コンポーネントを使用するため
	var $twitterView  = null;

	// 値をセットするため
	var $user    = null;

	var $message = null;
	var $error   = null;
	var $items   = null;
	var $items_error = null;
	var $show_items  = false;
	var $base_url           = null;
	var	$show_login_nc      = true;
	var	$show_login_twitter = true;
	var	$show_goto_control  = false;

    /**
     * Twitter モジュール
     *
     * @access  public
     */
//---------------------------------------------------------
// OpneID サーバーの入力画面を表示する
//---------------------------------------------------------
    function execute()
    {

// ユーザID を取得する
// 取得できなければ、exauthentry を表示する
		$user_id = $this->twitterView->get_init_userid_or_exauthentry();

// ログインしてなければ、ログイン要求を表示する
       	if ( empty($user_id) ) {
			$this->base_url = $this->twitterView->get_base_url_ssl();

// オプションがあれば、上書きする
			$show = $this->twitterView->get_show_login_nc();
			if ( $show !== false ) {
				$this->show_login_nc = $show;
			}

       		return 'success_login';	
		}

		$twitterService =& new Twitter_Components_Service();
		$ret = $twitterService->init();

// Consumer Key が設定されてなければ
		if ( !$ret ) {
			$this->show_goto_control = true;
			$this->error = $twitterService->get_error_msg();
       		return 'success_error';	
		}

		$ret = $twitterService->set_user_param( $user_id );

// ユーザー・パラメータが設定できなければ
		if ( !$ret ) {
       		return 'success_twitter';	
		}

		$user = $twitterService->get_home_user();

// ユーザ情報が取得できなければ
		if ( !$user ) {
			$this->error  = TWITTER_ERR_USER;
			$this->error .= '<br />';
			$this->error .= $twitterService->get_error_msg();
       		return 'success_error';	
		}

		$this->user = $user;

		$items = $twitterService->get_home_timeline();

// タイムラインが取得できれば
		if ( is_array($items) ) {
			$this->show_items = true;
			$this->items      = $items;

// 取得できなければ
		} else {
			$this->items_error  = TWITTER_ERR_TIMELINE;
			$this->items_error .= '<br />';
			$this->items_error .= $twitterService->get_error_msg();
		}

		$this->chech_return_code();

		return 'success';
	}

    function chech_return_code()
	{
		$code    = $this->twitterView->get_get_by_key('code');
		$msg     = $this->twitterView->get_session_post();
		$message = '';
		$error   = '';

		switch ($code)
		{
			case 1:
				$message = TWITTER_TWEET_SUCCESS;
				break;

			case 11:
				$error = $msg;
				break;

			case 12:
				$this->error = $msg;
				$this->show_goto_control = true;
       			return 'success_error';	

			case 13:
      			return 'success_twitter';
				break;

		}

		$this->message = $message;
		$this->error   = $error;
	}

// === class end ===
}
?>