<?php
// $Id: Callback.class.php,v 1.3 2011/03/19 16:18:32 ohwada Exp $

//=========================================================
// Twitter Netcommons
// K.OHWADA 2010-08-01
//=========================================================

//---------------------------------------------------------
// change log
// 2011-03-01 K.OHWADA
// execute_callback()
//---------------------------------------------------------

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons View
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

include_once BASE_DIR."/webapp/modules/twitter/components/Service.class.php";

class Twitter_View_Main_Callback extends Action
{
	// コンポーネントを使用するため
	var $twitterView   = null;
	var $twitterAction = null;

    /**
     * @access  public
     */
//---------------------------------------------------------
// Twitter サーバ―からの callback を受け付ける
//---------------------------------------------------------
    function execute()
    {

// サービスの初期化
		$twitterService =& new Twitter_Components_Service();
		$ret = $twitterService->init();
		if ( !$ret ) {
			$this->twitterView->redirect_error_msg(
				$twitterService->get_error_msg() );
			exit();
		}

// コールバック
		$param = $twitterService->callback();

// Twitter ID が取得できないときは、エラー表示
		if ( !is_array($param) ) {
			$msg = $this->get_error(
				$twitterService->get_error_code(), 
				$twitterService->get_error_msg() );
			$this->twitterView->redirect_error_msg( $msg );
			exit();
		}

// コールバック処理
		$this->twitterAction->execute_callback( $param );
		exit();
	}

//---------------------------------------------------------
// エラーを表示する
//---------------------------------------------------------
    function get_error( $code, $msg )
    {
		$str = '';
		switch ( $code )
		{
		case 21:
		case 22:
		case 23:
			$str  = EXAUTH_ERR_AUTH_FAILED ;
			$str .= '<br />';
			$str .= $msg;
			break;

		default:
			$str = EXAUTH_ERR_UNKNOWN;
			break;
		}
		return $str;
	}

// === class end ===
}
?>