<?php
// $Id: Init.class.php,v 1.1.1.1 2009/04/27 21:19:17 ohwada Exp $

//=========================================================
// Headerchanger Netcommons
// 2009-03-01 K.OHWADA
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Headerchangerメイン画面表示
 *
 * @package     NetCommons
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Headerchanger_View_Main_Init extends Action
{
	// 使用コンポーネントを受け取るため
	var $headerchangerView = null;
	var $session = null;

	//リクエストパラメータを受け取るため
	var $block_id = null;

	//出力パラメータ
	var $block_data = null;
	var $show_msg_daughter = false;
	var $show_msg_mother   = false;

    /**
     * Headerchangerメイン画面表示
     *
     * @access  public
     */
    function execute()
    {
		$layoutmode = $this->session->getParameter("_layoutmode");

// リクエストパラメータ ( $this->page_id ) から受取ると、
// アクセス中のページではなく、ブロックのあるページになる
		$page_id = isset($_GET["page_id"]) ? intval($_GET["page_id"]) : 0 ;

// セッティングモードならば、メッセージを表示する
		if ( $layoutmode == "on" ) {
			$this->block_data = $this->headerchangerView->getBlockMain( $this->block_id );

// 子ページを表示中
			if ( $page_id == $this->block_data['daughter_page_id'] ) {
				$this->show_msg_daughter = true;

// たぶん母体ページを表示中
			} else {
				$this->show_msg_mother = true;
			}
		}

		return "success";
    }
}
?>
