<?php
// $Id: Assigns.class.php,v 1.1.1.1 2009/04/27 21:19:17 ohwada Exp $

//=========================================================
// Headerchanger Netcommons
// 2009-03-01 K.OHWADA
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Headerchanger編集画面表示
 *
 * @package     NetCommons
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

class Headerchanger_View_Edit_Assigns extends Action
{
	// 使用コンポーネントを受け取るため
	var $headerchangerView = null;
	var $headerchangerMenu = null;
	var $pagesView  = null;
	var $blocksView = null;

	//リクエストパラメータを受け取るため
	var $block_id = null;

	// 出力値
	var $block_data   = null;
	var $assign_datas = null;

	// 内部変数
	var $_block_names = array();

    /**
     * Headerchanger編集画面表示
     *
     * @access  public
     */
	function execute()
	{
// 出力値
		$page_datas = array();

// ルームの：変り目を調べるための変数
		$prev_room_id = -1;

		$block_data = $this->headerchangerView->getBlockById( $this->block_id );
		if ( ! is_array($block_data) ) {
			return false;
		}

		$block_mother_position  = $block_data['mother_position'];
		$block_daughter_page_id = $block_data['daughter_page_id'];

// ルームごとに並べる
		$order_params = array(
			'room_id'          => 'ASC',
			'parent_id'        => 'ASC',
			'thread_num'       => 'ASC',
			'display_sequence' => 'ASC',
		);
		$page_rows = $this->pagesView->getShowPagesList( null, $order_params );

		foreach( $page_rows as $page_row )
		{
			$mother_page_id   = $page_row['page_id'];
			$mother_page_name = $page_row['page_name'];
			$display_position = $page_row['display_position'];
			$room_id          = $page_row['room_id'];

// center position でなければ、表示しない
			if ( $display_position != 0 ) {
				continue;
			}

			$column_datas   = array();
			$column_datas[] = $this->build_column( $mother_page_id, _DISPLAY_POSITION_HEADER, $block_daughter_page_id, $block_mother_position );
			$column_datas[] = $this->build_column( $mother_page_id, _DISPLAY_POSITION_LEFT,   $block_daughter_page_id, $block_mother_position );
			$column_datas[] = $this->build_column( $mother_page_id, _DISPLAY_POSITION_RIGHT,  $block_daughter_page_id, $block_mother_position );

// ルームが変わるときに印をつける
			$room_mark = false;
			if ( $prev_room_id != $room_id ) {
				$room_mark = true;
			}
			$prev_room_id = $room_id;

			$page_datas[] = array(
				'mother_page_id'   => $mother_page_id ,
				'mother_page_name' => $mother_page_name ,
				'room_mark'        => $room_mark,
				'column_datas'     => $column_datas,
			);
		}

		$this->block_data = $block_data;
		$this->page_datas = $page_datas;

		return "success";
	}

	function build_column( $mother_page_id, $mother_position, $block_daughter_page_id, $block_mother_position )
	{
		if ( $mother_position == $block_mother_position ) {
			return $this->build_column_own(   $mother_page_id, $mother_position, $block_daughter_page_id );
		} else {
			return $this->build_column_other( $mother_page_id, $mother_position );
		}
	}

	function build_column_own( $mother_page_id, $mother_position, $block_daughter_page_id )
	{
		$act = 0;	// チェック無しのチェックボックス
		$daughter_page_id = 0;
		$block_name       = null;

		$assign_row = $this->headerchangerView->getAssignByMother( $mother_page_id, $mother_position );

		if ( isset($assign_row['daughter_page_id']) ) {
			$daughter_page_id = $assign_row['daughter_page_id'];
			$block_id         = $assign_row['block_id'];

// 子番号が一致すれば、チェック済みのチェックボックスを表示する
			if ( $daughter_page_id == $block_daughter_page_id ) {
				$act = 1;

// 子番号がゼロ(未割当て)ならば、チェック無しのチェックボックスを表示する
			} elseif ( $daughter_page_id == 0 ) {
				$act = 0;

// 他のページが割当られているときは、リンクを表示する
			} else {
				$act = 2;
				$block_name = $this->get_cached_block_name( $block_id );
			}
		}

// 自分自身のページであれば、チェックボックスを表示しない
		if ( $mother_page_id == $block_daughter_page_id ) {
			$act = -1;
		}

		return array(
			'act'              => $act ,
			'daughter_page_id' => $daughter_page_id,
			'block_name'       => $block_name,
		);
	}

	function build_column_other( $mother_page_id, $mother_position )
	{
		$act = -1;	// "---"
		$daughter_page_id = 0;
		$block_name       = null;

		$assign_row = $this->headerchangerView->getAssignByMother( $mother_page_id, $mother_position );

		if ( isset($assign_row['daughter_page_id']) ) {
			$daughter_page_id = $assign_row['daughter_page_id'];
			$block_id         = $assign_row['block_id'];

// 子番号があれば、リンクを表示する
			if ( $daughter_page_id > 0 ) {
				$act = 2;
				$block_name = $this->get_cached_block_name( $block_id );
			}
		}

		return array(
			'act'              => $act ,
			'daughter_page_id' => $daughter_page_id,
			'block_name'       => $block_name,
		);
	}
	
	function get_cached_block_name( $id )
	{
		if ( isset( $this->_block_names[$id] ) ) {
			return  $this->_block_names[$id];
		}
		$row = $this->headerchangerView->getBlockById( $id );
		if ( isset($row['block_name'] ) ) {
			$block_name = $row['block_name'];
			$this->_block_names[$id] = $block_name;
			return $block_name;
		}
		return null;
	}	
}
?>