<?php
// $Id: View.class.php,v 1.1.1.1 2009/04/27 21:19:26 ohwada Exp $

//=========================================================
// Headerchanger Netcommons
// 2009-03-01 K.OHWADA
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Headerchanger取得コンポーネント
 *
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Headerchanger_Components_View
{
	/**
	 * オブジェクトを保持
	 *
	 * @access	private
	 */
	var $db = null;
	var $request    = null;
	var $configView = null;
	var $pagesView  = null;

	/**
	 * コンストラクター
	 *
	 * @access	public
	 */
	function Headerchanger_Components_View()
	{
		$container =& DIContainerFactory::getContainer();
		$this->db  =& $container->getComponent("DbObject");
		$this->request    =& $container->getComponent("Request");
		$this->configView =& $container->getComponent("configView");
		$this->pagesView  =& $container->getComponent("pagesView");
	}

	/**
	 * Headerchangerのblockレコード件数を取得する
	 *
     * @return string	block件数
	 * @access	public
	 */
	function getBlockCount() 
	{
		return $this->db->countExecute("headerchanger_block");
	}

	/**
	 * Headerchangerのblockレコード一覧を取得する
	 *
     * @return array	block一覧データ配列
	 * @access	public
	 */
	function getBlockList() 
	{
		$sortColumn = $this->request->getParameter("sort_col");
		if (empty($sortColumn)) {
			$sortColumn = "block_id";
		}
		$sortDirection = $this->request->getParameter("sort_dir");
		if (empty($sortDirection)) {
			$sortDirection = "DESC";
		}
		$orderParams[$sortColumn] = $sortDirection;

// 一覧を取得する
		$sql = "SELECT * ".
				"FROM {headerchanger_block} ".
				$this->db->getOrderSQL($orderParams);
		$rows = $this->db->execute($sql);
		if ($rows === false) {
			$this->db->addError();
			return false;
		}

		return $rows;
	}

	/**
	 * Headerchangerのblockのカレントレコードを取得する
	 *
     * @return string	partsデータ配列
	 * @access	public
	 */
	function getBlockEdit( $block_id, $page_id )
	{
		$row = $this->getBlockMain( $block_id );

// 新規作成のときは デフォルト値
		if ( ! is_array($row) ) {
			$page_name = $this->get_page_name( $page_id );
			$row = array(
				'page_name'       => $page_name,
				'block_name'      => $page_name,
				'mother_position' => _DISPLAY_POSITION_HEADER,
			);
		}
		return $row;
	}
	function getBlockMain( $block_id )
	{
		$row = $this->getBlockById( $block_id );
		if ( is_array($row) ) {
			$row['page_name'] = $this->get_page_name( $row['daughter_page_id'] );
		}
		return $row;
	}
	function getBlockById( $id )
	{
		$arr = $this->getBlockArrayById( $id );
		if ( isset($arr[0]) ){
			return $arr[0];
		}
		return false;
	}
	function getBlockArrayById( $id )
	{
		$sql = "SELECT * ".
				"FROM {headerchanger_block} ".
				"WHERE block_id = ? ";
		$params = array( $id );
		$result = $this->db->execute($sql, $params);
		if ($result === false) {
			$this->db->addError();
			return false;
		}
		return $result;
	}

	/**
	 * Headerchangerのassignレコードを取得する
	 *
     * @return array	assignデータ配列
	 * @access	public
	 */
	function getAssignById( $id )
	{
		$arr = $this->getAssignArrayById( $id );
		if ( isset($arr[0]) ){
			return $arr[0];
		}
		return false;
	}
	function getAssignArrayById( $id )
	{
		$sql = "SELECT * ".
				"FROM {headerchanger_assign} ".
				"WHERE assign_id= ? ";
		$params = array( $id );
		$result = $this->db->execute($sql, $params);
		if ($result === false) {
			$this->db->addError();
			return false;
		}
		return $result;
	}
	function getAssignByMother( $mother_page_id, $mother_position )
	{
		$arr = $this->getAssignArrayByMother( $mother_page_id, $mother_position );
		if( isset($arr[0]) ){
			return $arr[0];
		}
		return false;
	}
	function getAssignArrayByMother( $mother_page_id, $mother_position )
	{
		$sql = "SELECT * ".
				"FROM {headerchanger_assign} ".
				"WHERE mother_page_id= ? ".
				"AND mother_position= ? ";
		$params = array( $mother_page_id, $mother_position );
		$result = $this->db->execute($sql, $params);
		if ($result === false) {
			$this->db->addError();
			return false;
		}
		return $result;
	}
	function getAssignArrayByDaughter( $daughter_page_id )
	{
		$sql = "SELECT * ".
				"FROM {headerchanger_assign} ".
				"WHERE daughter_page_id= ? ";
		$params = array( $daughter_page_id );
		$result = $this->db->execute($sql, $params);
		if ($result === false) {
			$this->db->addError();
			return false;
		}
		return $result;
	}

	// ページ名を取得する
	function get_page_name( $page_id )
	{
		$row = $this->pagesView->getPageById( $page_id );
		if ( isset($row['page_name']) ) {
			return $row['page_name'];
		}
		return false;
	}

	/**
	 * Config テーブルのデータを取得する
	 *
     * @return array	データ配列
	 * @access	public
	 */
	function getConfig( $module_id ) 
	{
		$config = $this->configView->getConfig( $module_id, false );
		if ($config === false) {
			return false;
		}
		$arr = array(
			'list_row_count' => $config['list_row_count']['conf_value'],
		);
		return $arr;
	}
}
?>