<?php
// $Id: Action.class.php,v 1.1.1.1 2009/04/27 21:19:26 ohwada Exp $

//=========================================================
// Headerchanger Netcommons
// 2009-03-01 K.OHWADA
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Headerchanger登録コンポーネント
 *
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Headerchanger_Components_Action
{
	/**
	 * オブジェクトを保持
	 */
	var $db = null;
	var $request = null;
	var $session = null;
	var $headerchangerView = null;

	/** param **/
	var $_params_footer;
	var $_params_update_footer;

	/**
	 * コンストラクター
	 *
	 * @access	public
	 */
	function Headerchanger_Components_Action()
	{
		$container     =& DIContainerFactory::getContainer();
		$this->db      =& $container->getComponent("DbObject");
		$this->request =& $container->getComponent("Request");
		$this->session =& $container->getComponent("Session");
		$this->headerchangerView =& $container->getComponent("headerchangerView");

		$site_id   = $this->session->getParameter("_site_id");
		$user_id   = $this->session->getParameter("_user_id");
		$user_name = $this->session->getParameter("_handle");
		$time      = timezone_date();

		$this->_params_footer = array(
			"insert_time"      => $time,
			"insert_site_id"   => $site_id,
			"insert_user_id"   => $user_id,
			"insert_user_name" => $user_name
		);

		$this->_params_update_footer = array(
			"update_time"      => $time,
			"update_site_id"   => $site_id,
			"update_user_id"   => $user_id,
			"update_user_name" => $user_name
		);
	}

	/**
	 * Headerchangerのblockレコードを登録する
	 *
     * @return boolean	true or false
	 * @access	public
	 */
	function setBlock() 
	{
		$page_id  = $this->request->getParameter("page_id");
		$block_id = $this->request->getParameter("block_id");

// blockレコード読み出し
		$params = array($block_id);
		$sql = "SELECT block_id ".
				"FROM {headerchanger_block} ".
				"WHERE block_id = ?";
		$block_ids = $this->db->execute($sql, $params);
		if ($block_ids === false) {
			$this->db->addError();
			return false;
		}

// blockレコード追加・更新
		$params = array(
			"block_id"        => $block_id,
			"block_name"      => $this->request->getParameter("block_name"),
			"mother_position" => $this->request->getParameter("mother_position")
		);
		if (!empty($block_ids)) {
			$result = $this->db->updateExecute("headerchanger_block", $params, "block_id", true);
        	if (!$result) {
				return false;
			}

		} else {
// 新規作成のときは、daughter_page_id を設定する
			$params["daughter_page_id"] = $page_id;
			$result = $this->db->insertExecute("headerchanger_block", $params, true);
        	if (!$result) {
				return false;
			}
			return "create";
		}
		return true;
	}

	function deleteBlockById( $id ) 
	{
		$param = array("block_id" => $id );
		return $this->db->deleteExecute("headerchanger_block", $param);
	}

	/**
	 * Headerchangerのassignレコードを登録する
	 *
     * @return boolean	true or false
	 * @access	public
	 */
	function setAssigns()
	{
		$block_id         = $this->request->getParameter("block_id");
		$mother_position  = $this->request->getParameter("mother_position");
		$daughter_page_id = $this->request->getParameter("daughter_page_id");
		$page_ids         = $this->request->getParameter("page_ids");
		$acts             = $this->request->getParameter("acts");

		if ( ! is_array($page_ids) ) {
			return false;
		}

		foreach ( $page_ids as $id => $v ) 
		{
// チェックされていれば、act を設定する
			$act = 0;
			if ( isset($acts[$id]) ) {
				$act = $acts[$id];
			}
			$this->setAssignSingle( $block_id, $id, $mother_position, $daughter_page_id, $act );
		}

		return "create";
	}

	function setAssignSingle( $block_id, $mother_page_id, $mother_position, $daughter_page_id, $act )
	{
		$params = array(
			"mother_page_id"   => $mother_page_id,
			"mother_position"  => $mother_position,
			"block_id"         => 0,
			"daughter_page_id" => 0,
		);

// チェックされていれば、子番号 を設定する
		if ( $act == 1 ) {
			$params["block_id"]         = $block_id;
			$params["daughter_page_id"] = $daughter_page_id;
		}

// assign レコード更新： 子番号 が一致するか ゼロ(未割当て) ならば
		$row = $this->headerchangerView->getAssignByMother( $mother_page_id, $mother_position );
		if ( is_array($row) ) {
			$current_page_id = $row['daughter_page_id'];
			if (( $current_page_id == $daughter_page_id )||
			    ( $current_page_id == 0 )) {
				$params = array_merge($row, $params, $this->_params_update_footer);
				$result = $this->db->updateExecute("headerchanger_assign", $params, "assign_id", false);
				if (!$result) {
					return false;
				}
			}

// assign レコード追加： チェックされていれば
		} elseif ( $act == 1 ) {
			$params = array_merge($params, $this->_params_footer, $this->_params_update_footer);
			$result = $this->db->insertExecute("headerchanger_assign",$params, false, "assign_id");
			if (!$result) {
				return false;
			}
		}

		return "create";
	}
}
?>