<?php
// $Id: Delblock.class.php,v 1.1.1.1 2009/04/27 21:19:26 ohwada Exp $

//=========================================================
// Headerchanger Netcommons
// 2009-03-01 K.OHWADA
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Headerchanger 削除アクション
 *
 * @package     NetCommons
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

// この中では自分の components が使用できない
// DB を直接 操作する
class Headerchanger_Action_Edit_Delblock extends Action
{
    // 使用コンポーネント
    var $db = null;

	// リクエストパラメータを受け取るため
	var $block_id = null;

	/**
	 * コンストラクター
	 *
	 * @access	public
	 */
	function execute()
	{
		$block_data = $this->getBlock();
    	if ( ! is_array($block_data) ) {
    		return "error";
    	}

		$result = $this->clearAssigns( $block_data['daughter_page_id'] );
    	if ($result === false) {
    		return "error";
    	}

		$result = $this->deleteBlock();
    	if ($result === false) {
    		return "error";
    	}

		return "success";
	}

// block レコードを取得
	function getBlock()
	{
		$res = $this->db->selectExecute( "headerchanger_block", array( "block_id" => $this->block_id ) );
		if ( false === $res ) {
			return false;
		}
		if ( isset($res[0]) ) {
			return $res[0];
		}
		return false;
 	}

// block レコードを削除	
 	function deleteBlock()
 	{
 		return $this->db->deleteExecute( "headerchanger_block", array( "block_id" => $this->block_id ) );
	}

// assign レコードのページ割当てを解除する
	function clearAssigns( $daughter_page_id ) 
	{
		$params = array(
			"block_id"         => 0,
			"daughter_page_id" => 0,
		);
		$where_params = array(
			"daughter_page_id" => $daughter_page_id,
		);
		return $this->db->updateExecute("headerchanger_assign", $params, $where_params, false);
	}
}
?>