<?php
// $Id: test_form_class.php,v 1.5 2007/05/19 03:57:04 ohwada Exp $

// 2007-05-18 K.OHWADA
// XC 2.1

// 2007-02-20 K.OHWADA
// admin_add_cat_add_cat()
// performance mode

// 2006-12-10 K.OHWADA
// use build_link_record

//=========================================================
// WebLinks Module
// 2006-09-20 K.OHWADA
//=========================================================

//=========================================================
// class weblinks_test_form
//=========================================================
class weblinks_test_form extends weblinks_gen_record
{
	var $_UNAME_ADMIN  = 'admin';
	var $_PASS_ADMIN   = 'admin';
	var $_UNAME_USER   = 'tester';
	var $_PASS_USER    = 'tester';
	var $_UNAME_OTHER  = 'tester2';
	var $_PASS_OTHER   = 'tester2';

	var $_snoopy;

	var $_admin_cat_url;
	var $_user_submit_url;
	var $_user_modify_url;
	var $_admin_link_url;

	var $_flag_print_body = true;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_test_form()
{
	$this->weblinks_gen_record();

	$this->_snoopy   =& new Snoopy();

	$this->_admin_cat_url   = WEBLINKS_URL.'/admin/category_manage.php';
	$this->_user_submit_url = WEBLINKS_URL.'/submit.php';
	$this->_user_modify_url = WEBLINKS_URL.'/modlink.php';
	$this->_admin_link_url  = WEBLINKS_URL.'/admin/link_manage.php';

	$this->set_flag_debug( false );
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_test_form();
	}
	return $instance;
}

//---------------------------------------------------------
// login
//---------------------------------------------------------
function login_admin()
{
	$ret = $this->login($this->_UNAME_ADMIN, $this->_PASS_ADMIN);
	return $ret;
}

function login_user()
{
	$ret = $this->login($this->_UNAME_USER, $this->_PASS_USER);
	return $ret;
}

function login_other()
{
	$ret = $this->login($this->_UNAME_OTHER, $this->_PASS_OTHER);
	return $ret;
}

function login($uname, $pass)
{
	$url = XOOPS_URL.'/user.php';

	$form = array(
		'uname' => $uname,
		'pass'  => $pass,
		'op'    => 'login',
	);

	$ret = $this->_snoopy->submit($url, $form);
	if ( !$ret )
	{
		echo "Error: cannnot connect login form: $url <br />\n";
		$this->print_body();
		return false;
	}

	$ret = $this->match_result( _US_INCORRECTLOGIN );
	if ( $ret )
	{
		echo "Error: user name is worng: <b>$uname</b> <br />\n";
		$this->print_body();
		return false;
	}

	$ret = $this->get_cookies();
	return $ret;
}

function logout( $flag=true )
{
	$url = XOOPS_URL.'/user.php?op=logout';
	$this->fetch($url);

	if ( $flag )
	{
		$ret = $this->match_result( _US_LOGGEDOUT );
		if ( !$ret )
		{
			echo "Error: cannot logout <br />\n";
			$this->print_body();
			return false;
		}
	}

	$ret = $this->get_cookies();
	return $ret;
}

function get_cookies()
{
	$this->_snoopy->setcookies();
	$cookies = $this->_snoopy->cookies;
	if ( !is_array($cookies) || (count($cookies) == 0) )
	{
		echo "Error: login failed: cannot get cookie <br />\n";
		$this->print_body();
		return false;
	}
	return $cookies;
}

//---------------------------------------------------------
// fetch_form
//---------------------------------------------------------
function fetch($url)
{
	$ret = $this->_snoopy->fetch($url);
	if ( !$ret )
	{
		echo "Error: cannnot fetch : $url <br />\n";
		$this->print_body();
		return false;
	}
	return true;
}

function fetch_form($url)
{
	$this->print_debug( "fetch_form($url)" );

	$ret = $this->_snoopy->fetchform($url);
	if ( !$ret )
	{
		echo "Error: cannnot fetch form: $url <br />\n";
		$this->print_body();
		return false;
	}
	return true;
}

//---------------------------------------------------------
// get ticket
// < input type="hidden" name="XOOPS_G_TICKET" value="e1c3d9c1ece8114441b7ac68e90e429b" />
//---------------------------------------------------------
function get_ticket( $result=null )
{
	$val = $this->get_hidden_value( 'XOOPS_G_TICKET', $result );
	if ( !$val )
	{
		echo "Error: cannot get ticket <br />\n";
		$this->print_body();
		return false;
	}
	return $val;
}

//---------------------------------------------------------
// get_hidden_value
// < input type="hidden" name="lid" id="lid" value="155" />
//---------------------------------------------------------
function get_hidden_value( $name, $result=null )
{
	if (empty($result))
	{
		$result = $this->_snoopy->results;
	}

	$pattern = '<\/?input[\s+]type="hidden"[\s+]name="'.$name.'".*value="(\w+)"[\s+]/>';
	$pattern = "'$pattern'Usi";

	preg_match($pattern, $result, $match);

	if ( isset($match[1]) && $match[1] )
	{
		$val = $match[1];
		return $val;
	}

	return false;
}

//---------------------------------------------------------
// submit_form
//---------------------------------------------------------
function submit_form($url, $form)
{
	$this->print_debug( "submit_form($url)" );

	$this->_snoopy->referer = $url;

	$ret = $this->_snoopy->submit($url, $form);
	if ( !$ret )
	{
		echo "Error: cannnot submit form: $url <br />\n";
		$this->print_body();
		return false;
	}
	return true;
}

//---------------------------------------------------------
// get_results
//---------------------------------------------------------
function get_results()
{
	return $this->_snoopy->results;
}

function get_body( $result=null )
{
	if (empty($result))
	{
		$result = $this->_snoopy->results;
	}

	$str = eregi_replace("^.*<body[^>]*>", "", $result);
	$str = eregi_replace("</body>.*$",     "", $str);
	return $str;
}

function print_body( $flag_print=false, $result=null )
{
	if ( $flag_print || $this->_flag_print_body )
	{
		echo "<hr />\n";
		echo $this->get_body( $result );
		echo "<hr />\n";
	}
}

function match_result($str, $result=null)
{
	if (empty($result))
	{
		$result = $this->_snoopy->results;
	}

	if ( preg_match( "/".$str."/", $result ) )
	{
		return true;
	}
	return false;
}

function match_return_msg($str, $result=null)
{
	if (empty($result))
	{
		$result = $this->_snoopy->results;
	}

	preg_match( "/<!-- weblinks : (.*?) -->/", $result, $match );

	if ( isset($match[1]) && ( $match[1] == $str ) )
	{
		return true;
	}
	return false;
}

//---------------------------------------------------------
// set param
//---------------------------------------------------------
function set_admin_uname_pass( $uname, $pass )
{
	$this->_UNAME_ADMIN = $uname;
	$this->_PASS_ADMIN  = $pass;
}

function set_user_uname_pass( $uname, $pass )
{
	$this->_UNAME_USER = $uanme;
	$this->_PASS_USER  = $pass;
}

function get_admin_uname()
{
	return $this->_UNAME_ADMIN;
}

function get_user_uname()
{
	return $this->_UNAME_USER;
}

function get_other_uname()
{
	return $this->_UNAME_OTHER;
}

//---------------------------------------------------------
// user submit
//---------------------------------------------------------
function user_submit_link( $title, $banner, $rss_flag, $rss_url, $passwd='' )
{
	$ret = $this->fetch_form($this->_user_submit_url);
	if ( !$ret )
	{
		return false;
	}

	$lid = 0;
	$form = $this->build_link_form($this->_UNAME_USER, $title, $banner, $rss_flag, $rss_url, $lid, $passwd);

	$ret = $this->submit_form($this->_user_submit_url, $form);
	if ( !$ret )
	{
		return false;
	}

	return true;
}

//---------------------------------------------------------
// user modify
//---------------------------------------------------------
function user_modify_link( $lid, $title, $banner, $rss_flag, $rss_url )
{
	$link_form_url = $this->_user_modify_url.'?lid='.$lid;
	$ret = $this->fetch_form($link_form_url);
	if ( !$ret )
	{
		echo "Error: modify link: fetch form <br />\n";
		return false;
	}

	$form = $this->build_link_form($this->_UNAME_USER, $title, $banner, $rss_flag, $rss_url, $lid);
	$this->print_debug($form);

	$ret = $this->submit_form($this->_user_modify_url, $form);
	if ( !$ret )
	{
		echo "Error: modify link: submit form <br />\n";
		return false;
	}

	return true;
}

function is_link_owner_other($lid, $uname=null)
{
	if ( empty($uname) )
	{
		$uname = $this->_UNAME_OTHER;
	}
	$ret = $this->is_link_owner($lid, $uname);
	return $ret;
}

function is_link_owner($lid, $uname=null)
{
	$link_uid = 0;
	$row =& $this->get_link($lid);
	if ( is_array($row) && isset($row['uid']) )
	{
		$link_uid = $row['uid'];
	}

	if ( empty($uname) )
	{
		$uname = $this->_UNAME_USER;
	}

	$user =& $this->_system->get_user_by_uname( $uname );
	$uname_uid = $user['uid'];

	if ( $link_uid && ( $link_uid == $uname_uid ) )
	{
		return true;
	}
	return false;
}

//---------------------------------------------------------
// admin add link
//---------------------------------------------------------
function admin_add_link_add_link($title, $banner, $rss_flag, $rss_url, $perf)
{
	$this->update_config_by_name( 'cat_path',  0 );
	$this->update_config_by_name( 'cat_count', $perf );

	$lid = 0;

	$ret = $this->fetch_form($this->_admin_link_url);
	if ( !$ret )
	{
		return false;
	}

	$form =& $this->build_link_form($this->_UNAME_ADMIN, $title, $banner, $rss_flag, $rss_url, $lid);

	$ret = $this->submit_form($this->_admin_link_url, $form);
	if ( !$ret )
	{
		return false;
	}

	return true;
}

function &build_link_form($name, $title, $banner, $rss_flag, $rss_url, $lid=0, $passwd='')
{
	$flag_uid      = 0;	// system param
	$mode_dhtml    = 1;	// all 1
	$flag_rssc_lid = 0;	// not update

	$arr =& $this->build_link_record( $title, $flag_uid, $mode_dhtml, $flag_rssc_lid );

    $arr['submit']         = 'submit';
    $arr['op']             = 'add_table';
	$arr['request']        = 1;
    $arr['XOOPS_G_TICKET'] = $this->get_ticket();


    $arr['lid']        = $lid;
    $arr['banner']     = $banner;
    $arr['rss_url']    = $rss_url;
    $arr['rss_flag']   = $rss_flag;

	if ( $passwd )
	{
    	$arr['passwd_new'] = $passwd;
    	$arr['passwd_2']   = $passwd;
	}
	else
	{
    	$arr['passwd_new'] = $arr['passwd'];
    	$arr['passwd_2']   = $arr['passwd'];
	}

	return $arr;
}

function admin_add_link_add_banner($title, $banner='', $rss_flag=0, $rss_url='')
{
	$url    = "http://$title/";
	$width  = $this->_WIDTH;
	$height = $this->_HEIGHT;

	$ticket = $this->get_ticket();
	$lid    = $this->get_hidden_value( 'lid' );
	if ( !$lid )
	{
		echo "Error: cannot get lid <br />\n";
		echo $this->get_body() ."<br /><br />\n";
		return false;
	}

	$link_form = array(
   		'XOOPS_G_TICKET' => $ticket,
    	'op'       => 'add_banner',
    	'op_mode'  => 'add_banner',
    	'lid'      => $lid,
    	'title'    => $title,
    	'url'      => $url,
     	'banner'   => $banner,
    	'rss_url'  => $rss_url,
    	'rss_flag' => $rss_flag,
    	'width'    => $width,
		'height'   => $height,
	);

	$ret = $this->submit_form($this->_admin_link_url, $link_form);
	if ( !$ret )
	{
		return false;
	}

	return true;
}

function admin_add_link_add_rssc($title, $rss_flag=0, $rss_url='', $rssc_lid=0)
{
	if ( !$this->is_exist_rssc_module() )
	{
		echo "Skip this test: RSSC module is not installed <br />\n";
		return true;
	}

	$this->update_config_by_name( 'rss_use', 1 );

	$url      = "http://$title/";
	$rdf_url  = '';
	$atom_url = '';

	$ticket   = $this->get_ticket();
	$link_lid = $this->get_hidden_value( 'link_lid' );
	if ( !$link_lid )
	{
		echo "Error: cannot get lid <br />\n";
		echo $this->get_body() ."<br /><br />\n";
		return false;
	}

	$link_form_rssc = array(
		'XOOPS_G_TICKET' => $ticket,
		'op'           => 'add_rssc',
		'op_mode'      => 'add_link',
		'link_lid'     => $link_lid,
		'rssc_lid'     => $rssc_lid,
		'title'        => $title,
		'url'          => $url,
		'rdf_url'      => $rdf_url,
		'atom_url'     => $atom_url,
		'rss_url'      => $rss_url,
		'show_rss_url' => $rss_url,
		'rss_flag'     => $rss_flag,
	);

	$ret = $this->submit_form($this->_admin_link_url, $link_form_rssc);
	if ( !$ret )
	{
		return false;
	}

	$ticket   = $this->get_ticket();
	$rssc_lid = $this->get_hidden_value( 'rssc_lid' );
	if ( !$rssc_lid )
	{
		echo "Error: cannot get rssc_lid <br />\n";
		echo $this->get_body() ."<br /><br />\n";
		return false;
	}

	$link_form_refresh = array(
		'XOOPS_G_TICKET' => $ticket,
		'op'           => 'refresh_link',
		'op_mode'      => 'add_link',
		'rssc_lid'     => $rssc_lid,
	);

	$ret = $this->submit_form($this->_admin_link_url, $link_form_refresh);
	if ( !$ret )
	{
		return false;
	}

	return true;
}

function admin_add_link_update_cat($title, $rss_flag=0, $rss_url='')
{
// build_form
	$ticket = $this->get_ticket();
	$url    = "http://$title/";
	$lid    = $this->get_hidden_value( 'lid' );

	if ( !$lid )
	{
		echo "Error: cannot get lid <br />\n";
		echo $this->get_body() ."<br /><br />\n";
		return false;
	}

	$link_form = array(
   		'XOOPS_G_TICKET' => $ticket,
    	'op'       => 'update_cat',
    	'op_mode'  => 'add_banner',
    	'lid'      => $lid,
    	'title'    => $title,
    	'url'      => $url,
    	'rss_url'  => $rss_url,
    	'rss_flag' => $rss_flag,
	);

	$ret = $this->submit_form($this->_admin_link_url, $link_form);
	if ( !$ret )
	{
		return false;
	}

	return true;
}



//---------------------------------------------------------
// admin add category
//---------------------------------------------------------
function admin_add_cat_add_cat($title, $mode)
{
	$this->update_config_by_name( 'cat_path',  $mode );
	$this->update_config_by_name( 'cat_count', $mode );

// fetch_form
	$ret = $this->fetch_form($this->_admin_cat_url);
	if ( !$ret )
	{
		return false;
	}

// build_form
	$ticket = $this->get_ticket();
	$imgurl = $this->get_randum_category_image();

	$cat_form = array(
    	'XOOPS_G_TICKET' => $ticket,
    	'op'     => 'add_table',
    	'title'  => $title,
    	'lflag'  => 1,
    	'orders' => 0,
    	'pid'    => 0,
    	'imgurl' => $imgurl,
	);

// submit_form
	$ret = $this->submit_form($this->_admin_cat_url, $cat_form);
	if ( !$ret )
	{
		return false;
	}
	
	return true;
}

function admin_add_cat_update_path()
{
// build_form
	$ticket = $this->get_ticket();

	$cat_form = array(
    	'XOOPS_G_TICKET' => $ticket,
    	'op'     => 'update_path',
	);

	$ret = $this->submit_form($this->_admin_cat_url, $cat_form);
	if ( !$ret )
	{
		return false;
	}

	return true;
}

//---------------------------------------------------------
// permission
//---------------------------------------------------------
function has_guest_perm()
{
	global $xoopsModule;
	$mid = $xoopsModule->getVar('mid');

	$groups_guest = array( XOOPS_GROUP_ANONYMOUS );

	$groupperm_handler =& xoops_gethandler( 'groupperm' );
	if ( $groupperm_handler->checkRight( 'module_read', $mid, $groups_guest ) )
	{
		return true;
	}
	return false;
}

//---------------------------------------------------------
// RSSC module
//---------------------------------------------------------
function is_exist_rssc_module()
{
	return $this->is_exist_module( $this->get_config_by_name( 'rss_dirname' ) );
}

// --- class end ---
}

?>