<?php
// $Id: link_manage.php,v 1.16 2007/05/18 14:36:38 ohwada Exp $

// 2007-05-18 K.OHWADA
// get_error_msg_addlink() -> get_errors_addlink()
// get_error_msg_modlink() -> get_errors_modlink()

// 2007-03-01 K.OHWADA
// weblinks_link_view.php
// weblinks_link_edit.php
// hack for multi site
// add forum_id comment_use field
// update_cat()

// 2006-12-03 K.OHWADA
// Fatal error: Call to undefined method admin_link_manage::_print_mod_table_error()

// 2006-10-14 K.OHWADA
// use _AM_WEBLINKS_ADD_BANNER
// show _WLS_NEWLINKADDED in blue

// 2006-10-05 K.OHWADA
// use happy_linux
// use rssc WEBLINKS_RSSC_USE
// move delVote to votadata_manage

// 2006-05-15 K.OHWADA
// new handler
// add class admin_link_manage
// use token ticket

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//=========================================================
// WebLinks Module
// admin link manage
// divid this file from index.php
// 2004/01/14 K.OHWADA
//=========================================================

include 'admin_header.php';
include_once XOOPS_ROOT_PATH.'/include/xoopscodes.php';
include_once XOOPS_ROOT_PATH.'/class/xoopsformloader.php';

include_once WEBLINKS_ROOT_PATH.'/class/weblinks_link_view.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_link_view_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_link_edit.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_link_edit_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_votedata_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_sendmail.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_rssc_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_link_form_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_link_form_admin_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_link_form_check_handler.php';

include_once WEBLINKS_ROOT_PATH.'/admin/modify_manage_class.php';
include_once WEBLINKS_ROOT_PATH.'/admin/rssc_manage_class.php';
include_once WEBLINKS_ROOT_PATH.'/admin/votedata_list_class.php';


//=========================================================
// class admin_link_manage
//=========================================================
class admin_link_manage extends happy_linux_manage
{
	var $_config_handler;
	var $_check_handler;
	var $_votedata_handler;
	var $_broken_handler;
	var $_form;
	var $_rssc_edit_handler;
	var $_link_edit_handler;

	var $_time_class;

	var $_rssc_modid;

	var $_lid;
	var $_rssc_obj;

	var $_parse_result = null;
	var $_error_title  = null;

	var $_check_param = false;
	var $_check_exist = false;

	var $_ret_add_rssc = 0;
	var $_ret_mod_rssc = 0;
	var $_ret_code_add_rssc_check = false;

	var $_conf;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_link_manage()
{
	$this->happy_linux_manage( WEBLINKS_DIRNAME );
	$this->set_handler( 'link_edit', WEBLINKS_DIRNAME, 'weblinks' );
	$this->set_id_name( 'lid' );
	$this->set_script(   'link_manage.php' );
	$this->set_redirect( 'link_list.php', 'link_list.php?sortid=1' );
	$this->set_title( _WEBLINKS_ADMIN_ADD_LINK, _WLS_MODLINK, _AM_WEBLINKS_DEL_LINK );
	$this->set_err_no_record( _WLS_ERRORNOLINK );
	$this->set_module_dirname( 'weblinks' );

	$this->_config_handler    =& weblinks_get_handler('config2_basic',   WEBLINKS_DIRNAME );
	$this->_votedata_handler  =& weblinks_get_handler('votedata',        WEBLINKS_DIRNAME);
	$this->_broken_handler    =& weblinks_get_handler('broken',          WEBLINKS_DIRNAME);
	$this->_check_handler     =& weblinks_get_handler('link_form_check', WEBLINKS_DIRNAME);
	$this->_form              =& weblinks_get_handler('link_form_admin', WEBLINKS_DIRNAME );
	$this->_link_edit_handler =& weblinks_get_handler('link_edit',       WEBLINKS_DIRNAME );

	$this->_rssc_manage =& admin_rssc_manage::getInstance();
	$this->_time_class  =& happy_linux_time::getInstance();

	$this->_conf = $this->_config_handler->get_conf();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_link_manage();
	}
	return $instance;
}

//---------------------------------------------------------
// POST param
//---------------------------------------------------------
function get_post_op()
{
	$op = 'main';
	if     ( isset($_POST['del_link']) )     $op = 'del_link';
	elseif ( isset($_POST['delete_link']) )  $op = 'del_link';
	elseif ( isset($_POST['delete_new']) )   $op = 'delete_new';
	elseif ( isset($_POST['ignore']) )       $op = 'ignore';
	elseif ( isset($_POST['cancel']) )       $op = 'cancel';
	elseif ( isset($_POST['op']) )           $op = $_POST['op'];
	elseif ( isset($_GET['op']) )            $op = $_GET['op'];
	return $op;
}

function get_post_lid()
{
	$lid = 0;
	if     ( isset($_POST['link_lid']) )  $lid = $_POST['link_lid'];
	elseif ( isset($_POST['lid']) )       $lid = $_POST['lid'];
	elseif ( isset($_GET['lid']) )        $lid = $_GET['lid'];
	$this->_lid = intval($lid);
	return $this->_lid;
}

function get_post_mid()
{
	return $this->_post->get_post_get_int('mid');
}

function get_post_rssc_lid()
{
	return $this->_post->get_post_get_int('rssc_lid');
}

function get_post_rss_flag()
{
	return $this->_post->get_post_get_int('rss_flag');
}

function get_post_op_mode()
{
	return $this->_post->get_post_get_text('op_mode');
}

function get_post_skip()
{
	return $this->_post->get_post_text('skip');
}

function get_post_banner()
{
	return $this->_post->get_post_url('banner');
}

//---------------------------------------------------------
// init
//---------------------------------------------------------
function init()
{
	$this->_handler->init();
}

//---------------------------------------------------------
// add_form
//---------------------------------------------------------
function add_form()
{
	$this->_main_add_form();
}

function _print_add_form()
{
	$this->_form->show_admin_form('submit');
	return true;
}

//---------------------------------------------------------
// add_link
//---------------------------------------------------------
function add_link()
{
	$rss_flag = $this->get_post_rss_flag();

	if ( !$this->_check_token() || !$this->_check_add_link() )
	{
		$this->_print_add_preview();
		exit();
	}

	if ( $this->_exec_add_link() )
	{
// when set banner
		if ( $this->get_post_banner() )
		{
			$this->_print_add_banner_form( $this->_newid, 'add_banner' );
			exit();
		}
// wehn conf_cat_path
		elseif ( $this->_conf['cat_count'] )
		{
			$this->_print_update_cat_form(  $this->_newid, 'add_link' );
			exit();
		}
// when set rss flag
		elseif ( WEBLINKS_RSSC_USE && $rss_flag )
		{
			$this->_rssc_manage->add_link( $this->_newid, 'add_link' );
			exit();
		}

// finish
		$msg  = _WLS_NEWLINKADDED;
		$msg .= $this->_build_comment('add link');	// for test form
		redirect_header($this->_redirect_desc, 1, $msg);
		exit();
	}
	else
	{
		$this->_print_add_db_error();
		exit();
	}
}

function _exec_add_link()
{
// add link & catlink
	$newid = $this->_handler->add_link_by_post();
	if (!$newid)
	{
		$this->_set_errors( $this->_handler->getErrors() );
		return false;
	}

// notification
	list($tags, $cid) = $this->_handler->build_tags_addlink($newid);

	$notification_handler =& xoops_gethandler('notification');
	$notification_handler->triggerEvent('global', 0, 'new_link', $tags);
	$notification_handler->triggerEvent('category', $cid, 'new_link', $tags);

	$this->_newid = $newid;
	return $newid;
}

function _check_add_link()
{
	$ret = $this->_check_handler->check_form_addlink_by_post();
	if (!$ret)
	{
		$this->_set_errors( $this->_check_handler->get_errors_addlink() );
		return false;
	}
	return true;
}

function _print_add_preview_form()
{
	$this->_form->show_admin_form('submit_preview');
}

function _print_add_preview()
{
	$this->_print_cp_header();
	$this->_print_bread_op( $this->_LANG_TITLE_ADD, 'add_form' );
	$this->_print_title(    $this->_LANG_TITLE_ADD );
	$this->_print_token_error(1);

	if ( $this->_error_title )
	{
		xoops_error( $this->_error_title );
		echo "<br />\n";
	}

	$err  = $this->getErrors(1);
	$err .= $this->_check_handler->get_formated_error_addlink();
	echo $this->_form->build_html_error_with_style( $err );
	echo "<br />\n";

	$this->_print_add_preview_form();
	$this->_print_cp_footer();
}

//---------------------------------------------------------
// mod_form
//---------------------------------------------------------
function mod_form()
{
	if ( !$this->_get_obj() )
	{
		redirect_header( 'link_list.php', 2, _WLS_ERRORNOLINK );
		exit();
	}

	$this->_print_cp_header();
	$this->_print_bread_op( _WLS_MODLINK, 'mod_form');
	$this->_print_title(    _WLS_MODLINK );

	if ( WEBLINKS_RSSC_USE )
	{
		$this->_rssc_manage->check_mod_form( $this->_obj );
	}

	$this->_print_mod_form();
	$this->_print_cp_footer();
}

function _print_mod_form()
{
	$MAX_RECORD = 5;

	$lid = $this->get_post_lid();

	$this->_form->show_admin_form('modify', $lid);
	echo "<hr />\n";

	$list =& admin_votedata_list::getInstance();
	$list->set_perpage( $MAX_RECORD );
	$list->set_flag_get_sortid( false );
	$list->set_flag_print_top(  false );
	$list->set_flag_print_navi( false );

	$totalvotes = $this->_votedata_handler->get_count_by_lid($lid);
	echo "<h4>". sprintf(_WLS_TOTALVOTES, $totalvotes). "</h4>\n";

// Show Registered Users Votes
	$votes1 = $this->_votedata_handler->get_count_user_by_lid($lid);
	echo "<h4>". sprintf(_WLS_USERTOTALVOTES, $votes1). "</h4>\n";

	if ($votes1)
	{
		$list->set_form_name('votedata_user');
		$list->_show_by_sortid(2);
	}
	else
	{
		echo "<b>" ._WLS_NOREGVOTES."</b><br />\n";
	}
	
	if ($votes1 > $MAX_RECORD)
	{
		$url = 'votedata_list.php?sortid=2&amp;lid='.$lid;
		echo '<a href="'.$url.'">'. 'more ...' ."</a><br />\n";
	}

// Show Unregistered Users Votes
	$votes2 = $this->_votedata_handler->get_count_by_lid_uid($lid, 0);
	echo "<h4>". sprintf(_WLS_ANONTOTALVOTES, $votes2). "</h4>\n";

    if ( $votes2 )
    { 
		$list->set_form_name('votedata_anoymous');
		$list->_show_by_sortid(3);
    }
    else 
    {
		echo "<b>" ._WLS_NOUNREGVOTES."</b><br />\n";
    }
    
    if ($votes2 > $MAX_RECORD)
	{
		$url = 'votedata_list.php?sortid=3&amp;lid='.$lid;
		echo '<a href="'.$url.'">'. 'more ...' ."</a><br />\n";
	}
}

//---------------------------------------------------------
// mod_link
//---------------------------------------------------------
function mod_link()
{
	$lid = $this->get_post_lid();

	if ( !$this->_get_obj() )
	{
		redirect_header("link_list.php", 3, _WLS_ERRORNOLINK);
		exit();
	}

	if ( !$this->_check_token() || !$this->_check_mod_link() )
	{
		$this->_print_mod_preview();
		exit();
	}

	if ( $this->_exec_mod_link() )
	{
// when set banner
		if ( $this->get_post_banner() )
		{
			$this->_print_mod_banner_form( 'mod_banner' );
			exit();
		}
// wehn conf_cat_path
		elseif ( $this->_conf['cat_count'] )
		{
			$this->_print_update_cat_form( $lid, 'mod_link' );
			exit();
		}
// when rssc use
		elseif ( WEBLINKS_RSSC_USE )
		{
			$this->_rssc_manage->mod_link( 'mod_link' );
			exit();
		}

// finish
		$msg  = _WLS_DBUPDATED;
		$msg .= $this->_build_comment('mod link');	// for test form
		redirect_header('link_list.php', 1, $msg);
		exit();
	}
	else
	{
// Fatal error: Call to undefined method admin_link_manage::_print_mod_table_error()
		$this->_print_mod_db_error();
		exit();
	}
}

function _exec_mod_link()
{
	$this->_clear_errors();
	$lid = $this->get_post_lid();

// update link & catlink
	$ret = $this->_handler->mod_link_by_post( $lid );
	if (!$ret)
	{
		$this->_set_errors( $this->_handler->getErrors() );
	}

// delete broken
	$broken_count = $this->_broken_handler->get_count_by_lid($lid);
	if ( $broken_count > 0 )
	{
		$ret = $this->_broken_handler->delete_by_lid($lid);
		if (!$ret)
		{
			$this->_set_errors( $this->_broken_handler->getErrors() );
		}
	}

	return $this->returnExistError();
}

function _check_mod_link()
{
	$ret = $this->_check_handler->check_form_modlink_for_owner_by_post();
	if (!$ret)
	{
		$this->_set_errors( $this->_check_handler->get_errors_modlink() );
		return false;
	}
	return true;
}

function _print_mod_preview_form()
{
	$this->_form->show_admin_form('modify_preview');
}

//---------------------------------------------------------
// add_banner
//---------------------------------------------------------
function _print_add_banner_form( $lid, $op_mode )
{
	$this->_print_cp_header();
	$this->_print_bread_op( $this->_LANG_TITLE_MOD, 'add_form', _AM_WEBLINKS_ADD_BANNER );

	if ( $op_mode == 'add_banner' )
	{
		echo '<h4 style="color: #0000ff;">'._WLS_NEWLINKADDED."</h4>\n";
		echo "<hr />\n";
	}

	$this->_print_title( _AM_WEBLINKS_ADD_BANNER );

	if ( $op_mode == 'add_banner_preview' )
	{
			$this->_print_token_error(1);
			$this->_print_error(1);
	}

	$this->_print_banner_form( $lid, $op_mode );

	$this->_print_cp_footer();
}

function _print_banner_form( $lid, $op_mode )
{
	switch ($op_mode)
	{
		case 'add_banner_preview':
		case 'mod_banner_preview':
			$this->_print_token_error(1);
			$this->_print_error(1);
			break;
	}

	$banner = $this->get_post_banner();
	$width  = 0;
	$height = 0;

	$size =& $this->_handler->get_remote_banner_size($banner);
	if ( is_array($size) && isset($size[0]) && isset($size[1]) )
	{
		$width  = $size[0];
		$height = $size[1];
	}
	elseif ( !$size )
	{
		$this->_set_error_title( _WEBLINKS_WARN_BANNER_NOT_GET_SIZE );
		$this->_set_errors( $this->_handler->get_banner_errors() );
		$this->_print_error(1);
	}

	$this->_form->show_admin_banner_form( $lid, $width, $height, $op_mode );

}

function add_banner()
{
	$lid      = $this->get_post_lid();
	$rss_flag = $this->get_post_rss_flag();
	$skip     = $this->get_post_skip();

	if ( !$this->_check_token() )
	{
		$this->_print_add_banner_form( $this->_lid, 'add_banner_preview' );
		exit();
	}

	if ( $skip || $this->_exec_add_mod_banner() )
	{
// wehn conf_cat_path
		if ( $this->_conf['cat_count'] )
		{
			$this->_print_update_cat_form( $lid, 'add_banner' );
			exit();
		}
// when set rss flag
		elseif ( WEBLINKS_RSSC_USE && $rss_flag )
		{
			$this->_rssc_manage->add_link($lid, 'add_link');
			exit();
		}

// finish
		$msg  = _WLS_NEWLINKADDED;
		$msg .= $this->_build_comment('add banner');	// for test form
		redirect_header($this->_redirect_desc, 1, $msg);
		exit();
	}
	else
	{
		$this->_print_add_db_error();
		exit();
	}
}

function _exec_add_mod_banner()
{
	$ret = $this->_handler->update_banner_and_size_by_post();
	if (!$ret)
	{
		$this->_set_errors( $this->_handler->getErrors() );
		return false;
	}
	return true;
}

//---------------------------------------------------------
// mod_banner
//---------------------------------------------------------
function _print_mod_banner_form( $op_mode )
{
	$this->_print_cp_header();
	$this->_print_bread_op( $this->_LANG_TITLE_MOD, 'mod_form', _AM_WEBLINKS_MOD_BANNER );

	if ( $op_mode == 'mod_banner' )
	{
		echo '<h4 style="color: #0000ff;">'._WLS_DBUPDATED."</h4>\n";
		echo "<hr />\n";
	}

	$this->_print_title( _AM_WEBLINKS_MOD_BANNER );
	$this->_print_banner_form( $this->_lid, $op_mode );
	$this->_print_cp_footer();
}

function mod_banner()
{
	$lid      = $this->get_post_lid();
	$rss_flag = $this->get_post_rss_flag();
	$skip     = $this->get_post_skip();

	if ( !$this->_check_token() )
	{
		$this->_print_mod_banner_form( 'mod_banner_preview' );
		exit();
	}

	if ( $skip || $this->_exec_add_mod_banner() )
	{
// wehn conf_cat_path
		if ( $this->_conf['cat_count'] )
		{
			$this->_print_update_cat_form( $lid, 'mod_banner' );
			exit();
		}
// when rssc use
		elseif ( WEBLINKS_RSSC_USE )
		{
			$this->_rssc_manage->mod_link( 'mod_link' );
			exit();
		}

// finish
		$msg  = _WLS_DBUPDATED;
		$msg .= $this->_build_comment('mod banner');	// for test form
		redirect_header('link_list.php', 1, $msg);
		exit();
	}
	else
	{
		$this->_print_add_db_error();
		exit();
	}
}

//---------------------------------------------------------
// delLink
//---------------------------------------------------------
function del_link()
{
	$this->_main_del_table();
}

function _main_del_table( $check_flag=false )
{
	$lid = $this->get_post_lid();

	if ( !$this->_get_obj() )
	{
		redirect_header( $this->_redirect_asc, 3, $this->_LANG_ERR_NO_RECORD );
		exit();
	}

	if( !$this->_check_token() ) 
	{
		redirect_header( $this->_build_script_mod_form(), 3, "Token Error");
		exit();
	}

	if ( !$this->_check_del_table() )
	{
		redirect_header( $this->_build_script_mod_form(), 3, $this->_get_del_error() );
		exit();
	}

	if ( $this->_exec_del_table() )
	{
// wehn conf_cat_path
		if ( $this->_conf['cat_count'] )
		{
			$this->_print_update_cat_form( $lid, 'del_link' );
			exit();
		}

		$msg  = _AM_WEBLINKS_DEL_LINK;
		$msg .= $this->_build_comment('del record');	// for test form
		redirect_header($this->_redirect_asc, 1, $msg);
		exit();
	}
	else
	{
		$this->_print_del_db_error();
		exit();
	}
}

function _exec_del_table()
{
	$lid = $this->get_post_lid();

// BUG 3095: the number of links does not change, if delete link
	$ret = $this->_handler->del_link_vote_comm_catlink_by_lid($lid);
	if (!$ret)
	{
		$this->_set_errors( $this->_handler->getErrors() );
		return false;
	}

	return true;
}

function _print_del_error()
{
	xoops_error("DB Error");
	echo $this->getErrors(1);
}

function _check_del_table()
{
	return true;
}

//---------------------------------------------------------
// update_category_link_count
//---------------------------------------------------------
function update_cat_form()
{
	$this->_print_update_cat_form( 0, 'update_cat' );
}

function _print_update_cat_form( $link, $op_mode )
{
	$name = _AM_WEBLINKS_UPDATE_CAT_COUNT;

	switch ($op_mode)
	{
		case 'add_link':
			$title = _WEBLINKS_ADMIN_ADD_LINK;
			$op    = 'add_form';
			break;

		case 'mod_link':
			$title = _WLS_MODLINK;
			$op    = 'mod_form';
			break;

		case 'del_link':
			$title = _AM_WEBLINKS_DEL_LINK;
			$op    = 'del_form';
			break;

		case 'add_banner':
			$title = _WEBLINKS_ADMIN_ADD_LINK;
			$op    = 'add_banner_form';
			break;

		case 'mod_banner':
			$title = _WLS_MODLINK;
			$op    = 'mod_banner_form';
			break;

		default:
		case 'update_cat':
			$title = _AM_WEBLINKS_UPDATE_CAT_COUNT;
			$op    = 'update_cat_form';
			$name  = '';
			break;
	}

	$this->_print_cp_header();
	$this->_print_bread_op( $title, $op, $name );
	$this->_print_title( _AM_WEBLINKS_UPDATE_CAT_COUNT );
	$this->_form->show_admin_update_cat_form( $link, $op_mode );
	$this->_print_cp_footer();
}

function update_cat()
{
	$lid      = $this->get_post_lid();
	$rss_flag = $this->get_post_rss_flag();
	$op_mode  = $this->get_post_op_mode();
	$skip     = $this->get_post_skip();

	$url_end = 'link_list.php';
	$url_err = 'link_manage.php?op=update_cat_form';

	$flag_add_rssc = false;
	$flag_mod_rssc = false;

	switch ($op_mode)
	{
		case 'add_link':
		case 'add_banner':
			$msg     = _WLS_NEWLINKADDED."<br />\n";
			$url_end = $this->_redirect_desc;
			if ( WEBLINKS_RSSC_USE && $rss_flag )
			{
				$flag_add_rssc = true;
			}
			break;

		case 'mod_link':
		case 'mod_banner':
			$msg     = _WLS_DBUPDATED."<br />\n";
			$url_end = $this->_redirect_asc;
			if ( WEBLINKS_RSSC_USE )
			{
				$flag_mod_rssc = true;
			}
			break;

		case 'del_link':
			$msg     = _AM_WEBLINKS_DEL_LINK."<br />\n";
			$url_end = $this->_redirect_asc;
			break;

		default:
		case 'update_cat':
			$msg = '';
			$url_end = $this->_redirect_asc;
			break;
	}

	if( !( $this->_check_token() ) ) 
	{
		redirect_header( $url_err, 3, "Token Error");
		exit();
	}

	if ( $skip || $this->_exec_update_cat() )
	{
		if ( $flag_add_rssc )
		{
			$this->_rssc_manage->add_link($lid, 'add_link');
			exit();
		}
		elseif ( $flag_mod_rssc )
		{
			$this->_rssc_manage->mod_link('mod_link');
			exit();
		}

		$time  = $this->_time_class->get_elapse_time();
		$msg  .= _AM_WEBLINKS_CAT_COUNT_UPDATED." : $time sec \n";
		$msg  .= $this->_build_comment('update cat');	// for test form
		redirect_header( $url_end, 3, $msg );
		exit();
	}

	xoops_cp_header();
	$this->_print_bread_op( _AM_WEBLINKS_UPDATE_CAT_COUNT );
	$this->_print_title(    _AM_WEBLINKS_UPDATE_CAT_COUNT );
	xoops_error("DB Error");
	echo $this->getErrors(1);
	xoops_cp_footer();
}

function _exec_update_cat()
{
	$ret = $this->_link_edit_handler->update_category_link_count();
	return $ret;
}

//---------------------------------------------------------
// handler
//---------------------------------------------------------
function _get_obj()
{
	$lid = $this->get_post_lid();
	$obj = $this->_handler->get($lid);
	if ( is_object($obj) ) 
	{
		$this->_obj =& $obj;
	}
	return $obj;
}

//---------------------------------------------------------
// private print
//---------------------------------------------------------
function _print_menu()
{
	weblinks_admin_print_header();
	weblinks_admin_print_menu();
}

// --- class end ---
}


//=========================================================
// main
//=========================================================
// hack for multi site
weblinks_admin_multi_redirect_jp_site();

$link_manage    =& admin_link_manage::getInstance();
$modify_manage  =& admin_modify_manage::getInstance();
$rssc_manage    =& admin_rssc_manage::getInstance();

$op  = $link_manage->get_post_op();
$mid = $link_manage->get_post_mid();

// start
$link_manage->init();

switch ($op) 
{
case 'addLinkS':
case 'add_link':
case 'add_table':
	$link_manage->add_link();
	break;

case 'modLink':
case 'mod_form':
	$link_manage->mod_form();
	break;

case 'modLinkS':
case 'mod_link':
case 'mod_table':
	$link_manage->mod_link();
	break;

case 'add_banner':
	$link_manage->add_banner();
	break;

case 'mod_banner':
	$link_manage->mod_banner();
	break;
	
case 'delLink':
case 'delete_link';
case 'del_link';
case 'del_table';
	$link_manage->del_link();
	break;

case 'add_rssc':
	$rssc_manage->add_rssc();
	break;

case 'mod_rssc':
	$rssc_manage->mod_rssc();
	break;

case 'refresh_link':
	$rssc_manage->refresh_link();
	break;

case 'listNewLinks':
case 'list_new':
	$modify_manage->list_new();
	break;

case 'approve':
case 'approve_new':
	$modify_manage->approve_new();
	break;

case 'delNewLink':
case 'delete_new';
case 'del_new';
	$modify_manage->del_new();
	break;

case 'listModReq':
case 'list_mod':
	$modify_manage->list_mod();
	break;

case 'approveModReq':
case 'approve_mod':
	$modify_manage->approve_mod();
	break;

case 'ignore';
case 'ignoreModReq':
case 'del_mod':
	$modify_manage->del_mod();
	break;

case 'update_cat_form':
	$link_manage->update_cat_form();
	break;

case 'update_cat':
	$link_manage->update_cat();
	break;

case 'main':
case 'add_form':
default:
	$link_manage->add_form();
	break;

}

exit();
// --- end of main ---

?>