<?php
// $Id: weblinks_plugin.php,v 1.4 2007/04/10 01:16:44 ohwada Exp $

// 2007-04-08 K.OHWADA
// get_album_photos() get_selecter_by_id()

// 2007-03-25 K.OHWADA
// get_config_options() etc

//=========================================================
// WebLinks Module
// 2007-02-20 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_plugin') ) 
{

define('WEBLINKS_PLUGIN_ALL',  '-1');
define('WEBLINKS_PLUGIN_NONE', '-2');

//=========================================================
// class weblinks_plugin
//=========================================================
class weblinks_plugin
{
	var $_DIRNAME;
	var $_conf;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_plugin($dirname)
{
	$this->_DIRNAME = $dirname;

	$config_handler =& weblinks_get_handler( 'config2_basic',  $dirname );
	$this->_conf    =& $config_handler->get_conf();
}

function &getInstance($dirname)
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_plugin($dirname);
	}

	return $instance;
}

//---------------------------------------------------------
// selecter 
//---------------------------------------------------------
// config_define
function &get_config_options( $sel_kind )
{
	$arr2    = array();
	$arr2[0] = '---';

	$arr1 =& $this->_exec_selecter( $sel_kind );

	if ( is_array($arr1) && count($arr1) )
	{
		foreach ($arr1 as $k => $v)
		{
			$arr2[$k] = $v['description'];
		}
	}

	$arr3 = array_flip($arr2);
	return $arr3;
}

// admin_config
function get_dirname_by_conf( $sel_kind, $conf_name )
{
	$dirname = $this->_get_value_by_conf_key( $sel_kind, $conf_name, 'dirname' );
	return $dirname;
}

function get_filename_by_conf( $sel_kind, $conf_name )
{
	$name = $this->_get_value_by_conf_key( $sel_kind, $conf_name, 'name' );
	return $name;
}

function _get_value_by_conf_key( $sel_kind, $conf_name, $key )
{
	$val =  false;
	$arr =& $this->get_selecter_by_id( $sel_kind, $this->_conf[$conf_name] );
	if ( isset($arr[$key]) )
	{
		$val = $arr[$key];
	}
	return $val;
}

function &get_selecter_by_id( $sel_kind, $sel_id )
{
	$val =  false;
	$arr =& $this->_exec_selecter( $sel_kind );
	if ( isset($arr[$sel_id]) )
	{
		$val =& $arr[$sel_id];
	}
	return $val;
}

function &_exec_selecter( $sel_kind )
{
	$func_sel = 'weblinks_plugin_' . $sel_kind . '_sel';
	$val =& $func_sel();
	return $val;
}

//---------------------------------------------------------
// each plugin 
//---------------------------------------------------------
// category_manage
function &get_sel_options_by_conf( $sel_kind, $plugin_kind, $conf_name )
{
	$arr1 =& $this->get_categories_by_conf( $sel_kind, $plugin_kind, $conf_name );
	$arr2 =  array_flip($arr1);
	return $arr2;
}

function &get_categories_by_conf( $sel_kind, $plugin_kind, $conf_name )
{
	$arr2    = array();
	$arr2[0] = '---';

	$filename = $this->get_filename_by_conf( $sel_kind, $conf_name );
	$func     = $this->build_plugin_func( $plugin_kind, $filename );

	$arr1 =& $this->exec_plugin( $filename, $func );
	if ( is_array($arr1) && count($arr1) )
	{
		$arr2[ WEBLINKS_PLUGIN_ALL ] = 'ALL';
		foreach ($arr1 as $k => $v)
		{
			$arr2[$k] = $v;
		}
	};

	return $arr2;
}

// link_view_handler
function &exec_plugin_by_conf( $sel_kind, $plugin_kind, $conf_name, $options=null )
{
	$filename = $this->get_filename_by_conf( $sel_kind, $conf_name );
	$func     = $this->build_plugin_func( $plugin_kind, $filename );
	$arr =& $this->exec_plugin( $filename, $func, $options );
	return $arr;
}

function build_plugin_func( $plugin_kind, $filename )
{
	$func = 'weblinks_plugin_' . $plugin_kind . '_' . $filename;
	return $func;
}

function &exec_plugin( $filename, $func, $options=null )
{
	$file = '/modules/'.$this->_DIRNAME.'/plugins/'.$filename.'.php';
	$arr = array();

	if ( file_exists( XOOPS_ROOT_PATH.'/'.$file ) )
	{
		include_once XOOPS_ROOT_PATH.'/'.$file;
	}
	else
	{
		return $arr;
	}

	if ( function_exists($func) )
	{
		$arr =& $func( $options );
	}

	return $arr;
}

//---------------------------------------------------------
// album_photos 
//---------------------------------------------------------
function &get_album_photos( $opts )
{
	$SEL_KIND    = 'album';
	$PLUGIN_KIND = 'photos';

	$sel_id      = isset( $opts['sel_id'] )       ? intval( $opts['sel_id'] )       : 0;
	$width       = isset( $opts['width'] )        ? intval( $opts['width'] )        : 140;
	$album_limit = isset( $opts['album_limit'] )  ? intval( $opts['album_limit'] )  : 1;
	$album_id    = isset( $opts['album_id'] )     ? intval( $opts['album_id'] )     : 0;
	$mode_sub    = isset( $opts['mode_sub'] )     ? intval( $opts['mode_sub'] )     : 1;
	$cycle       = isset( $opts['cycle'] )        ? intval( $opts['cycle'] )        : 60;
	$cols        = isset( $opts['cols'] )         ? intval( $opts['cols'] )         : 3;

	$sel =& $this->get_selecter_by_id( $SEL_KIND, $sel_id );
	if (!$sel)
	{
		$false = false;
		return $false;
	}

	$filename       = $sel['name'];
	$plugin_dirname = $sel['dirname'];

	$plugin_opts = array(
		'plugin_dirname' => $plugin_dirname,
		'width'          => $width,
		'album_limit'    => $album_limit,
		'album_id'       => $album_id,
		'mode_sub'       => $mode_sub,
		'cycle'          => $cycle,
		'cols'           => $cols,
	);

	$func   =  $this->build_plugin_func( $PLUGIN_KIND, $filename );
	$photos =& $this->exec_plugin( $filename, $func, $plugin_opts );

	return $photos;
}

// --- class end ---
}

// === class end ===
}

?>