<?php
// $Id: weblinks_link_catlink_handler.php,v 1.4 2006/12/22 15:17:05 ohwada Exp $

// 2006-12-10 K.OHWADA
// use time_publish
// add get_count_by_cid_array()

// 2006-10-14 K.OHWADA
// add get_lid_array_by_cid_array_orderby_where()

// 2006-09-20 K.OHWADA
// use happy_linux
// add get_lid_array_by_cid_array_orderby() : remove get_lid_array_by_cid_array_criteria()

// 2006-05-15 K.OHWADA
// this is new file
// use new handler

//=========================================================
// WebLinks Module
// 2006-05-15 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_link_catlink_handler') ) 
{

//=========================================================
// class weblinks_link_catlink_handler
// handling for table_link & table_catlink
//=========================================================
class weblinks_link_catlink_handler extends happy_linux_object_handler
{
	var $_table_link;
	var $_table_catlink;

// config
	var $_conf_broken;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link_catlink_handler( $dirname )
{
	$this->happy_linux_object_handler($dirname, 'link_catlink', 'lid', 'weblinks' );

	$this->set_debug_db_sql(   WEBLINKS_DEBUG_LINK_CATLINK_SQL );
	$this->set_debug_db_error( WEBLINKS_DEBUG_ERROR );

	$this->_table_link     = $this->prefix( 'link',    $dirname );
	$this->_table_catlink  = $this->prefix( 'catlink', $dirname );

	$config_basic_handler =& weblinks_get_handler( 'config2_basic', $dirname );

	$conf = $config_basic_handler->get_conf();
	$this->_conf_broken  = $conf['broken_threshold'];

}

//---------------------------------------------------------
// count
//---------------------------------------------------------
function get_count_by_cid_array($cid_arr)
{
	if ( !is_array($cid_arr) || count($cid_arr) == 0 )
	{
		$false = false;
		return $false;
	}

	$sql  = 'SELECT COUNT(DISTINCT l.lid) FROM ';
	$sql .= $this->_table_link.' l, ';
	$sql .= $this->_table_catlink.' c ';
	$sql .= ' WHERE '. $this->build_sql_where_strict( $cid_arr );

	$count = $this->get_count_by_sql($sql);
	return $count;
}

function build_sql_where_strict( $cid_arr )
{
	$where  = $this->build_sql_where_exclude();
	$where .= ' AND '. $this->build_sql_where_cid_arr( $cid_arr );
	$where .= ' AND l.lid=c.lid';
	return $where;
}

function build_sql_where_exclude()
{
	$time   = time();
	$where  = ' l.broken < '. intval($this->_conf_broken) .' ';
	$where .= 'AND ( l.time_publish = 0 OR l.time_publish <= '. $time .' ) ';
	$where .= 'AND ( l.time_expire = 0 OR l.time_expire > '. $time .' ) ';
	return $where;
}

function build_sql_where_cid_arr( $cid_arr )
{
	$count = count($cid_arr);

	$where = ' ( c.cid='.$cid_arr[0].' ';
	for ($i=1; $i<$count; $i++)
	{
		$where .= ' OR c.cid='.$cid_arr[$i].' ';
	}
	$where .= ' ) ';
	return $where;
}

//---------------------------------------------------------
// lid list
//---------------------------------------------------------
function &get_lid_array_by_cid_orderby($cid, $orderby=null, $limit=0, $start=0)
{
	$ret =& $this->get_lid_array_by_cid_array_orderby(array($cid), $orderby, $limit, $start);
	return $ret;
}

// for topten
function &get_lid_array_by_cid_array_orderby($cid_arr, $orderby=null, $limit=0, $start=0)
{
	$ret =& $this->get_lid_array_by_cid_array_orderby_where($cid_arr, $orderby, null, $limit, $start);
	return $ret;
}

function &get_lid_array_by_cid_array_orderby_where($cid_arr, $orderby=null, $where=null, $limit=0, $start=0)
{
	if ( !is_array($cid_arr) || count($cid_arr) == 0 )
	{
		$false = false;
		return $false;
	}

// where
	$where_sql = $this->build_sql_where_strict( $cid_arr );

	if ( $where )
	{
		$where_sql .= ' AND '.$where;
	}

// orderby
	if ( $orderby )
	{
		$orderby = 'l.'.$orderby;
	}
	else
	{
		$orderby = 'l.lid ASC';
	}

	$sql  = 'SELECT DISTINCT l.lid FROM ';
	$sql .= $this->_table_link.' l, ';
	$sql .= $this->_table_catlink.' c ';
	$sql .= ' WHERE '. $where_sql .' ';
	$sql .= ' ORDER BY '.$orderby;

	$ret =& $this->get_first_rows_by_sql($sql, $limit, $start);
	return $ret;
}

// --- class end ---
}

// === class end ===
}

?>