<?php
// $Id: happy_search_modules.php,v 1.2 2007/02/18 07:14:08 ohwada Exp $ 

// 2007-02-18 K.OHWADA
// xoops_modules_handler
// $_strict_dirname_flag
// Warning: array_merge() [function.array-merge]: Argument #1 is not an array on line 518
// Warning: usort() [function.usort]: The argument should be an array on line 535

//=========================================================
// Happy Search
// 2006-11-11 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('happy_search_modules') ) 
{

define('HAPPY_SEARCH_CODE_NORMAL',        0);
define('HAPPY_SEARCH_CODE_SEARCH',      301);
define('HAPPY_SEARCH_CODE_ENTER',       302);
define('HAPPY_SEARCH_CODE_NOPERM',      303);
define('HAPPY_SEARCH_CODE_KEYTOOSHORT', 304);

//=========================================================
// class happy_search_modules
// porting from suin's search index.php
//=========================================================
class happy_search_modules extends happy_linux_search
{

// constant
	var $_DIRNAME;
	var $_MAX_SHOWALL = 10;

// class
	var $_highlight;
	var $_xoops_module_handler;

// action results
	var $_search_results = null;
	var $_modules        = null;

// action showall
	var $_showall_results  = null;
	var $_module_name_show = null;
	var $_navi             = null;

// set parameter
	var $_flag_highlight       = false;
	var $_strict_dirname_flag  = false;
	var $_exclude_dirname_flag = false;
	var $_strict_dirname_arr   = array();
	var $_exclude_dirname_arr  = array();

// local
	var $_mid_list_config_notshow;
	var $_mid_list_groupperm;
	var $_search_display_text;
	var $_module_objs_cached = null;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function happy_search_modules( $dirname='happy_search' )
{
	$this->happy_linux_search();
	$this->set_lang_zenkaku( _HAPPY_LINUX_ZENKAKU );
	$this->set_lang_hankaku( _HAPPY_LINUX_HANKAKU );

	$this->_DIRNAME = $dirname;

	$happy_module_handler  =& happy_linux_get_handler('module', $dirname, 'happy_search' );
	$this->_highlight      =& happy_linux_highlight::getInstance();
	$this->_xoops_module_handler =& happy_search_xoops_module_handler::getInstance();

	$this->_mid_list_config_notshow =& $happy_module_handler->get_list_notshow();
	$this->_mid_list_groupperm      =& $this->_system->get_groupperm_mid_list();

	$this->_highlight->set_replace_callback( 'happy_linux_highlighter_by_class' );
	$this->_highlight->set_class( 'happy_search_highlight' );
}

//---------------------------------------------------------
// check_param
//---------------------------------------------------------
function check_post_get_param_default()
{
	$param = array(
		'action' => $this->_post_action,
		'query'  => $this->_post_query,
		'mid'    => $this->_post_mid,
		'uid'    => $this->_post_uid,
	);

	$ret = $this->check_post_get_param( $param );
	return $ret;
}

function check_post_get_param( &$param )
{
	$action = $param['action'];
	$query  = $param['query'];
	$mid    = $param['mid'];
	$uid    = $param['uid'];

	switch ($action) 
	{
		case 'search':
			return HAPPY_SEARCH_CODE_SEARCH;	// show search form
			break;

		case 'results':
			if ( $query == '' ) 
			{
				return HAPPY_SEARCH_CODE_ENTER;	// goto this module
			}
			return HAPPY_SEARCH_CODE_NORMAL;	// OK
			break;

		case 'showall':
			if ( $query == '' || empty($mid) )
			{
				return HAPPY_SEARCH_CODE_ENTER;	// goto this module
			}
			if ( !$this->_check_show_mid($mid) )
			{
				return HAPPY_SEARCH_CODE_NOPERM;	// no permission
			}
			return HAPPY_SEARCH_CODE_NORMAL;	// OK
			break;

		case 'showallbyuser':
			if ( empty($mid) || empty($uid) )
			{
				return HAPPY_SEARCH_CODE_ENTER;	// goto this module
			}
			if ( !$this->_check_show_mid($mid) )
			{
				return HAPPY_SEARCH_CODE_NOPERM;	// no permission
			}
			return HAPPY_SEARCH_CODE_NORMAL;	// OK
			break;

		default:
			break;
	}

	return HAPPY_SEARCH_CODE_NORMAL;	// dummy
}

function _check_show_mid($mid)
{
	$mid_list =& $this->_get_module_id_list();
	if( in_array($mid, $mid_list) )
	{
		return true;
	}
	return false;
}

//---------------------------------------------------------
// action_results
//---------------------------------------------------------
function action_results_default( $limit )
{
	$param = array(
		'mid'                  => '',
		'uid'                  => '',
		'start'                => 0,
		'action'               => $this->_post_action,
		'mids'                 => $this->_post_mids,
		'showcontext'          => $this->_post_showcontext,
		'search_display_text'  => $this->_search_display_text,
		'andor'                => $this->_mode_andor,
		'query_array'          => $this->_query_array,
		'candidate_array'      => $this->_candidate_array,
		'merged_query_array'   => $this->get_merged_query_array(),
		'limit'                => $limit,
	);

	$ret = $this->action_results( $param );
	return $ret;
}

function action_results( &$param )
{
// clear result
	$this->_search_results = null;
	$this->_modules        = null;

	$mids        =  $param['mids'];
	$limit       =  $param['limit']; 
	$query_array =& $param['query_array'];

	if ( ($limit == 0) || !is_array($query_array) || (count($query_array) == 0) )
	{
		return true;	// no action
	}

	$module_objs =& $this->_get_module_objs_search();

	if ( !is_array($module_objs) || ( count($module_objs) == 0 ) )
	{
		return false;
	}

	if ( empty($mids) || !is_array($mids) ) 
	{
		unset($mids);
		$mids = array_keys($module_objs);
	}

	$results = array();
	foreach ($mids as $mid) 
	{
		$param['mid']        =  $mid;
		$param['module_obj'] =& $module_objs[$mid];
		$results[] =& $this->_build_single_module( $param );
	}

// set result
	$this->_search_results =& $results;
	$this->_modules        =& $module_objs;
	return true;	// OK
}

function &_build_single_module( &$param )
{
	$limit       =  $param['limit']; 
	$showcontext =  $param['showcontext'];
	$module_obj  =& $param['module_obj'];

	if ( !is_object($module_obj) )
	{
		$false = false;
		return $false;
	}

	$this_dirname = $module_obj->getVar('dirname');
	$this_mid     = $module_obj->getVar('mid');
	$this_name    = $module_obj->getVar('name');

	$results =& $this->_search_single_module( $param );
	$count   =  count($results);

	if ( $count > $limit ) 
	{
		$results = array_slice($results, 0, $limit);
		$count   = $limit;
	}

 	if (!is_array($results) || $count == 0) 
 	{
		$no_match     = _SR_NOMATCH;
		$showall_link = '';
	}
	else 
	{
		$no_match = "";

		$results =& $this->_format_result( $results, $param );

		if ( $count == $limit ) 
		{
			$search_url   = $this->_build_search_url( 'showall', $param );
			$showall_link = '<a href="'. $search_url .'">'. _SR_SHOWALLR .'</a>';
		}
		else 
		{
			$showall_link = '';
		}
	}

	$module_results = array(
		'mid'          => $this_mid,
		'dirname'      => $this_dirname,
		'name'         => $this_name,
		'results'      => $results,
		'showall_link' => $showall_link,
		'no_match'     => $no_match,
	);

	unset($results1);
	unset($results2);
	unset($results);
	unset($module_obj);

	return $module_results;
}

function &get_search_results()
{
	return $this->_search_results;
}

//---------------------------------------------------------
// action_showall
//---------------------------------------------------------
function action_showall_default()
{
	$param = array(
		'action'               => $this->_post_action,
		'uid'                  => $this->_post_uid,
		'mid'                  => $this->_post_mid,
		'mids'                 => $this->_post_mids,
		'start'                => $this->_post_start,
		'showcontext'          => $this->_post_showcontext,
		'search_display_text'  => $this->_search_display_text,
		'andor'                => $this->_mode_andor,
		'query_array'          => $this->_query_array,
		'candidate_array'      => $this->_candidate_array,
		'merged_query_array'   => $this->get_merged_query_array(),
		'limit'                => $this->_MAX_SHOWALL,
	);

	$ret = $this->action_showall( $param );
	return $ret;
}

function action_showall( &$param )
{
	$action      =  $param['action'];
	$mid         =  $param['mid']; 
	$uid         =  $param['uid']; 
	$start       =  $param['start']; 
	$limit       =  $param['limit']; 
	$andor       =  $param['andor'];
	$showcontext =  $param['showcontext'];
	$query_array =& $param['query_array'];

	$module_obj =& $this->_xoops_module_handler->get($mid);
	if ( !is_object($module_obj) )
	{	return false;	}

	$this_dirname =  $module_obj->getVar('dirname');
	$this_name    =  $module_obj->getVar('name');

	$param['module_obj'] = $module_obj;
	$results =& $this->_search_single_module( $param );

	if ( is_array($results) && count($results) ) 
	{
		$count = count($results);

		$next_results =& $module_obj->search( $query_array, $andor, 1, $start + $limit, $uid );
		$next_count = count($next_results);
		$has_next = false;

		if ( is_array($next_results) && ($next_count == 1) )
		{
			$has_next = true;
		}

		$results =& $this->_format_result($results, $param );
		$search_url = $this->_build_search_url( $action, $param );

		$navi = '<table><tr>';

		if ( $start > 0 ) 
		{
			$prev     = $start - $limit;
			$url_prev = $search_url .'&start='. $prev;
			$navi .= "\n".'<td align="left">';
			$navi .= "\n".'<a href="'. htmlspecialchars($url_prev) .'">'. _SR_PREVIOUS .'</a></td>';
		}

		$navi .= "\n".'<td>&nbsp;&nbsp;</td>';

		if ( false != $has_next ) 
		{
			$next     = $start + $limit;
			$url_next = $search_url .'&start='. $next;
			$navi .= "\n".'<td align="right"><a href="'. htmlspecialchars($url_next) .'">'. _SR_NEXT .'</a></td>';
		}

		$navi .= "\n".'</tr></table>'."\n";
	}

	$this->_showall_results  =& $results;
	$this->_module_name_show =  $this->_strings->sanitize_text($this_name);
	$this->_navi             =  $navi;

	return true;
}

//---------------------------------------------------------
// search_form
//---------------------------------------------------------
function get_search_form_default()
{
	$param = array(
		'action'              => $this->_post_action,
		'uid'                 => $this->_post_uid,
		'mid'                 => $this->_post_mid,
		'mids'                => $this->_post_mids,
		'start'               => $this->_post_start,
		'showcontext'         => $this->_post_showcontext,
		'search_display_text' => $this->_search_display_text,
		'min_keyword'         => $this->_min_keyword,
		'andor'               => $this->_mode_andor,
		'query_array'         => $this->_query_array,
		'candidate_array'     => $this->_candidate_array,
		'limit'               => 0,
	);

	$form = $this->_build_search_form( $param );
	return $form;
}

function _build_search_form( &$param )
{
	$mid                 =  $param['mid'];
	$mids                =  $param['mids'];
	$andor               =  $param['andor'];
	$showcontext         =  $param['showcontext'];
	$min_keyword         =  $param['min_keyword'];
	$search_display_text =  $param['search_display_text'];
	$mids                =& $param['mids'];
	$query_array         =& $param['query_array'];

	$module_name_list    =& $this->_get_module_name_list(); 

// --- create form ---
	$search_form = new XoopsThemeForm(_SR_SEARCH, "search", "index.php", 'get');

	$query_s = $this->implode_query_array( $query_array, ' ', 's' );
	$search_form->addElement(new XoopsFormText(_SR_KEYWORDS, "query", 40, 255, $query_s), true);

	$type_select = new XoopsFormSelect(_SR_TYPE, "andor", $andor);
	$type_select->addOptionArray(array("AND"=>_SR_ALL, "OR"=>_SR_ANY, "exact"=>_SR_EXACT));
	$search_form->addElement($type_select);

	if ( is_array($mids) && count($mids) )  
	{
		$mods_checkbox = new XoopsFormCheckBox(_SR_SEARCHIN, "mids[]", $mids);
	}
	else 
	{
		$mods_checkbox = new XoopsFormCheckBox(_SR_SEARCHIN, "mids[]", $mid);
	}

	if ( is_array($module_name_list) && count($module_name_list) )  
	{
		$mods_checkbox->addOptionArray($module_name_list);
	}
	else
	{
		$mod_arr = $this->_get_module_id_list();
		$mods_checkbox->addOptionArray( $mod_arr );

		if( count($mod_arr) == 0)
		{
			$mods_checkbox = new XoopsFormLabel(_SR_SEARCHIN, _HAPPY_SEARCH_UNABLE_TO_SEARCH);
		}
	}

	$search_form->addElement($mods_checkbox);

	if( $search_display_text == 1 )
	{
		$search_form->addElement(new XoopsFormRadioYN(_HAPPY_SEARCH_SHOW_CONTEXT, "showcontext", $showcontext));
	}

	$lessthan = ($min_keyword > 1) ? sprintf(_SR_KEYIGNORE, $min_keyword, ceil($min_keyword/2)).'<br />' : "" ;
	$search_form->addElement(new XoopsFormLabel(_SR_SEARCHRULE, $lessthan._HAPPY_SEARCH_KEY_SPACE));
	$search_form->addElement(new XoopsFormHidden("action", "results"));
	$search_form->addElement(new XoopsFormButton("", "submit", _SR_SEARCH, "submit"));

	$form = $search_form->render();
// --- create form end ---

	return $form;
}

function &get_showall_results()
{
	return $this->_showall_results;
}

//---------------------------------------------------------
// private common
//---------------------------------------------------------
function &_search_single_module( &$param )
{
	$uid                 =  $param['uid']; 
	$start               =  $param['start']; 
	$limit               =  $param['limit'];
	$andor               =  $param['andor'];
	$search_display_text =  $param['search_display_text'];
	$query_array         =& $param['query_array'];
	$candidate_array     =& $param['candidate_array'];
	$module_obj          =& $param['module_obj']; 

	$this_dirname = $module_obj->getVar('dirname');
	$use_context  = false;

	$results1 = array();
	$results2 = array();
	$results  = array();

	if( file_exists( XOOPS_ROOT_PATH.'/modules/'.$this->_DIRNAME.'/plugin/'.$this_dirname.'/'.$this_dirname.'.php' ) && $search_display_text==1 )
	{
		include_once XOOPS_ROOT_PATH.'/modules/'.$this->_DIRNAME.'/plugin/'.$this_dirname.'/'.$this_dirname.'.php';
		$func = 'b_search_'.$this_dirname;
		$results1 =& $this->_context_search( $func, $query_array, $andor, $limit, $start, $uid );
		$use_context = true;
	}
	else
	{
		$results1 =& $module_obj->search( $query_array, $andor, $limit, $start, $uid );
	}

	if( is_array($candidate_array) && count($candidate_array) )
	{
		$arr = array();
		foreach ( $candidate_array as $candidate )
		{
			$arr[] = $candidate['keyword'];
		}

		if ($use_context)
		{
			$results2 =& $this->_context_search($func, $arr, $andor, $limit, $start, $uid);
		}
		else
		{
			$results2 =& $module_obj->search($arr, $andor, $limit, $start, $uid);
		}
	}

// Warning: array_merge() Argument #1 is not an array
	if( is_array($results1) && count($results1) && is_array($results2) && count($results2) )
	{
		$results = array_merge($results1, $results2);
	}
	elseif( is_array($results1) && count($results1) )
	{
		$results =& $results1;
	}
	elseif( is_array($results2) && count($results2) )
	{
		$results =& $results2;
	}

// Warning: usort() The argument should be an array
	if( is_array($results) && count($results) )
	{
		usort($results, 'happy_search_sort_by_date');
	}

	return $results;
}

function &_context_search( $funcname, &$query_array, $andor='AND', $limit=0, $offset=0, $userid=0 )
{
	$ret = false;
	if( $funcname )
	{
		$ret = $funcname( $query_array, $andor, $limit, $offset, $userid );
	}
	return $ret;
}

function &_format_result( &$results, &$param )
{
	$showcontext        =  $param['showcontext'];
	$module_obj         =& $param['module_obj'];
	$merged_query_array =& $param['merged_query_array'];

	$this_dirname = $module_obj->getVar('dirname');
	$count = count($results);

	for ($i=0; $i<$count; $i++) 
	{
		$res = $results[$i];

		$title     = '';
		$link      = '';
		$uid       = '';
		$uname     = '';
		$time      = 0;
		$time_l    = '';
		$time_s    = '';
		$context   = '';
		$full_link = '';

		if ( isset($res['title']) && $res['title'] )
		{
			$title = $this->_strings->sanitize_text( $res['title'] );
		}

		if ( isset($res['link']) && $res['link'] )
		{
			$link = $this->_strings->sanitize_url( $res['link'] );
			$link = '/modules/'. $this_dirname .'/'. $link;
		}

		if ( isset($res['image']) && $res['image'] )
		{
			$image = $this->_strings->sanitize_url( $res['image'] );
			$image = '/modules/'. $this_dirname .'/'. $image;
		}
		else 
		{
			$image = '/modules/'. $this->_DIRNAME .'/images/posticon.gif';
		}

		if ( isset($res['uid']) && $res['uid'] )
		{
			$uid   = intval( $res['uid'] );
			$uname = XoopsUser::getUnameFromId( $uid );
		}

		if ( $res['time'] && $res['time']  )
		{
			$time   = intval( $res['time'] );
			$time_l = formatTimestamp( $time, 'l' );
			$time_m = formatTimestamp( $time, 'm' );
			$time_s = formatTimestamp( $time, 's' );
		}

		if ( isset($res['context']) && $res['context'] )
		{
			$context = $this->_strings->sanitize_textarea( $res['context'] );

			if ( $this->_flag_highlight )
			{
				$context = $this->_highlight->build_highlight_keyword_array($context, $merged_query_array);
			}

			if ( $showcontext != 1 )
			{
				$context = '';
			}
		}

		if ( isset($res['full_link']) && $res['full_link'] )
		{
			$full_link = $this->_strings->sanitize_url( $res['full_link'] );
		}

		$results[$i] = array(
			'title'     => $title,
			'link'      => $link,
			'image'     => $image,
			'uid'       => $uid,
			'uname'     => $uname,
			'time'      => $time,
			'time_l'    => $time_l,
			'time_s'    => $time_s,
			'context'   => $context,
			'full_link' => $full_link,
		);

	}

	return $results;
}

function _build_search_url( $action, &$param )
{
	$mid          =  $param['mid'];
	$uid          =  $param['uid'];
	$andor        =  $param['andor'];
	$showcontext  =  $param['showcontext'];
	$query_array  =& $param['query_array'];

	$search_url  = XOOPS_URL .'/modules/'. $this->_DIRNAME .'/index.php?';
	$search_url .= 'query='. $this->urlencode_implode_array( $query_array );
	$search_url .= '&mid='. $mid;
	$search_url .= '&action='. $action;
	$search_url .= '&andor='. $andor;
	$search_url .= '&showcontext='. $showcontext;

	if ($action == 'showallbyuser') 
	{
		$search_url .= '&uid='. $uid;
	}

	return $search_url;
}

//---------------------------------------------------------
// xoops module handler
//---------------------------------------------------------
function &_get_module_objs_config()
{
// return cache if already
	if ( $this->_module_objs_cached )
	{
		return $this->_module_objs_cached;
	}

	$objs =& $this->_xoops_module_handler->get_objects_in_group( $this->_mid_list_groupperm, $this->_mid_list_config_notshow );
	$this->_module_objs_cached =& $objs;
	return $objs;
}

function &_get_module_id_list()
{
	$module_objs =& $this->_get_module_objs_config();
	$arr = array();
	if ( is_array($module_objs) && count($module_objs) )
	{
		foreach ($module_objs as $mid => $obj) 
		{
			$arr[] = $mid;
		}
	}
	return $arr;
}

function &_get_module_name_list()
{
	$module_objs =& $this->_get_module_objs_config();
	$arr = array();
	if ( is_array($module_objs) && count($module_objs) )
	{
		foreach ($module_objs as $obj) 
		{
			$arr[ $obj->getVar('mid') ] = $obj->getVar('name');
		}
	}
	return $arr;
}

function &_get_module_objs_search()
{
	$objs =& $this->_xoops_module_handler->get_objects_in_group( $this->_get_mid_list_group(), $this->_get_mid_list_except() );
	return $objs;
}

//---------------------------------------------------------
// exclude_dirname & strict_dirname
//---------------------------------------------------------
function &_get_mid_list_group()
{
	$mid_list = array();
	if ( is_array($this->_mid_list_groupperm) && count($this->_mid_list_groupperm) )
	{
		if ( $this->_strict_dirname_flag )
		{
			$mid_list_strict  =& $this->_get_mid_list_from_strict_dirname();
			if ( is_array($mid_list_strict) && count($mid_list_strict) ) 
			{
				foreach( $mid_list_strict as $mid )
				{
					if ( in_array($mid, $this->_mid_list_groupperm) )
					{
						$mid_list[] = $mid;
					}
				}
			}
		}
		else
		{
			$mid_list =& $this->_mid_list_groupperm;
		}
	}

	return $mid_list;
}

function &_get_mid_list_except()
{
	$mid_list_exclude =& $this->_get_mid_list_from_exclude_dirname();

	$mid_list = array();
	if ( is_array($this->_mid_list_config_notshow) && count($this->_mid_list_config_notshow) 
	     && is_array($mid_list_exclude) && count($mid_list_exclude) ) 
	{
		$mid_list = array_merge($this->_mid_list_config_notshow, $mid_list_exclude);
	}
	elseif ( is_array($this->_mid_list_config_notshow) && count($this->_mid_list_config_notshow) ) 
	{
		$mid_list =& $this->_mid_list_config_notshow;
	}
	elseif ( is_array($mid_list_exclude) && count($mid_list_exclude) ) 
	{
		$mid_list =& $mid_list_exclude;
	}

	return $mid_list;
}

function &_get_mid_list_from_exclude_dirname()
{
	$mid_list = array();
	if ( is_array($this->_exclude_dirname_arr) && count($this->_exclude_dirname_arr) )
	{
		foreach ($this->_exclude_dirname_arr as $dirname )
		{
			$mid = $this->_system->get_mid_by_dirname( $dirname );
			if ( $mid )
			{
				$mid_list[] = $mid;
			}
		}
	}
	return  $mid_list;
}

function &_get_mid_list_from_strict_dirname()
{
	$mid_list = array();
	if ( is_array($this->_strict_dirname_arr) && count($this->_strict_dirname_arr) )
	{
		foreach ($this->_strict_dirname_arr as $dirname )
		{
			$mid = $this->_system->get_mid_by_dirname( $dirname );
			if ( $mid )
			{
				$mid_list[] = $mid;
			}
		}
	}
	return  $mid_list;
}

//---------------------------------------------------------
// xoops config table
//---------------------------------------------------------
function get_search_display_text()
{
	$mid    =  $this->_system->get_mid_by_dirname( $this->_DIRNAME );
	$config =& $this->_system->get_module_config_by_mid( $mid );
	$this->_search_display_text = $config['search_display_text'];
	return $this->_search_display_text;
}

//---------------------------------------------------------
// get parameter
//---------------------------------------------------------
function get_module_name_show()
{
	 return $this->_module_name_show;
}

function get_navi()
{
	 return $this->_navi;
}

function &get_modules()
{
	 return $this->_get_module_objs_search();
}

//---------------------------------------------------------
// set parameter
//---------------------------------------------------------
function set_flag_highlight($val)
{
	$this->_flag_highlight = (bool)$val;
}

function clear_dirname_array()
{
	$this->_strict_dirname_flag  = false;
	$this->_exclude_dirname_flag = false;
	$this->_strict_dirname_arr   = null;
	$this->_exclude_dirname_arr  = null;
}

function set_strict_dirname_array($arr)
{
	if ( is_array($arr) && count($arr) )
	{
		$this->_strict_dirname_flag = true;
		$this->_strict_dirname_arr  = $arr;
	}
}

function set_exclude_dirname_array($arr)
{
	if ( is_array($arr) && count($arr) )
	{
		$this->_exclude_dirname_flag = true;
		$this->_exclude_dirname_arr  = $arr;
	}
}

// --- class end ---
}

//=========================================================
// function
//=========================================================
function happy_search_sort_by_date($p1, $p2) 
{
    return ($p2['time'] - $p1['time']);
}

// === class end ===
}

?>