<?php
// $Id: modlink.php,v 1.8 2006/05/24 01:13:25 ohwada Exp $

// 2006-05-15 K.OHWADA
// add class weblinks_modlink()
// new handler
// use token ticket
// dont use global

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//================================================================
// WebLinks Module
// 2004/01/23 K.OHWADA
//================================================================

include "header.php";

include_once XOOPS_ROOT_PATH."/include/xoopscodes.php";
include_once XOOPS_ROOT_PATH."/class/xoopsformloader.php";

include_once WEBLINKS_ROOT_PATH."/class/weblinks_form.php";
include_once WEBLINKS_ROOT_PATH."/class/weblinks_linkitem_handler.php";
include_once WEBLINKS_ROOT_PATH."/class/weblinks_linkitem_define_handler.php";
include_once WEBLINKS_ROOT_PATH."/class/weblinks_linkitem_store_handler.php";


//=========================================================
// class weblinks_modlink
//=========================================================
class weblinks_modlink extends weblinks_error
{
	var $_config_handler;
	var $_link_edit_handler;
	var $_link_view_handler;
	var $_link_form_handler;
	var $_template;
	var $_system;
	var $_post;

// config
	var $_conf_use_passwd;

// system
	var $_system_is_module_admin;
	var $_system_uid;
	var $_system_module_name;

	var $_is_permit = false;
	var $_is_auto   = false;
	var $_is_owner  = false;
	var $_flag_usercomment_show = 0;
	var $_flag_passwd_match     = false;
	var $_flag_passwd_incorrect = false;

// link record
	var $_lid;
	var $_link_title_s;


//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_modlink()
{
	$this->weblinks_error();
	$this->set_debug_print_error( WEBLINKS_DEBUG_ERROR );

	$this->_config_handler    =& weblinks_get_handler( 'config2_basic', WEBLINKS_DIRNAME );
	$this->_link_edit_handler =& weblinks_get_handler( 'link_edit',     WEBLINKS_DIRNAME );
	$this->_link_view_handler =& weblinks_get_handler( 'link_view',     WEBLINKS_DIRNAME );
	$this->_link_form_handler =& weblinks_get_handler( 'link_form',     WEBLINKS_DIRNAME );
	$this->_template =& weblinks_template::getInstance( WEBLINKS_DIRNAME );
	$this->_system   =& weblinks_system::getInstance();
	$this->_post     =& weblinks_post::getInstance();

	$conf = $this->_config_handler->get_cached();
	$this->_conf_use_passwd = $conf['use_passwd'];

	$this->_system_is_module_admin = $this->_system->is_module_admin();
	$this->_system_uid             = $this->_system->get_uid();
	$this->_system_module_name     = $this->_system->get_module_name();

}

//---------------------------------------------------------
// init & get obj
//---------------------------------------------------------
function get_post_op()
{
	$op = '';
	if     (isset($_POST['post']))     $op = 'post';
	elseif (isset($_POST['preview']))  $op = 'preview';

	return $op;
}

function get_post_get_lid()
{
	$this->_lid = $this->_post->get_post_get_int('lid');
	return $this->_lid;
}

//---------------------------------------------------------
// check_access
//---------------------------------------------------------
function check_access()
{

// admin
	if ( $this->_system_is_module_admin )
	{
		return 1;	// admin
	}

	$obj =& $this->_link_edit_handler->get($this->_lid);

	if ( !is_object($obj) )
	{
		return -3;	// no record
	}

	$this->_link_title_s = $obj->getVar('title', 's');
	$rec_uid             = $obj->get('uid');
	$rec_passwd          = $obj->get('passwd');

	$passwd_match = $this->check_passwd_match( $rec_passwd );

	list($is_permit, $is_owner, $show_passwd) = 
		$this->_link_edit_handler->has_auth_modify( $rec_uid, $passwd_match );

	$is_auto = $this->_link_edit_handler->has_auth_modify_auto( $rec_uid, $passwd_match );

// not permit
	if ( !$is_permit ) 
	{
		if ( $this->_system_uid > 0 ) 
		{
			return -1;	// not permit
		}
		elseif ( !$show_passwd )
		{
			return -2;	// anonymous
		}
	}

	$this->_is_permit = $is_permit;
	$this->_is_auto   = $is_auto;
	$this->_is_owner  = $is_owner;

	if ( $show_passwd && ( $this->_flag_passwd_incorrect || !$this->_flag_passwd_match ))
	{
		return 2;	// password form
	}

	$this->_link_edit_handler->init();

	$this->_flag_usercomment_show = 0;
	if ( $is_owner )
	{
		$this->_flag_usercomment_show = 1;
	}

	return 0;	// OK
}

function check_passwd_match( $rec_passwd )
{
	$this->_flag_passwd_match     = false;
	$this->_flag_passwd_incorrect = false;

	$request = $this->_post->get_post_int('request');

	list($passwd, $flag_passwd, $flag_code)
		= $this->_post->get_post_get_passwd_old();

	if ( $flag_passwd || $flag_code )
	{
		if( $rec_passwd == md5( $passwd ))
		{
			if( $flag_code || $request )
			{
				$this->_flag_passwd_match = true;
			}
			return true;
		}

		$this->_flag_passwd_incorrect = true;
	}

	return false;
}

function get_title()
{
	return $this->_link_title_s;
}

//---------------------------------------------------------
// modify_form
//---------------------------------------------------------
function print_modify_form()
{
	$this->print_modify_header();
	$this->print_modify_comment();

	$this->show_user_form('modify', $this->_lid);
}

function show_user_form($form_mode, $lid)
{
	$this->_link_form_handler->set_flag_owner( $this->_is_owner );
	$this->_link_form_handler->show_user_form($form_mode, $lid);
}

//---------------------------------------------------------
// preview
//---------------------------------------------------------
function print_preview()
{
	$this->print_modify_header();
	echo "<hr />\n";

// check form
	if ( !( $this->check_form_modlink() ) ) 
	{
		echo $this->_link_edit_handler->get_error_msg_modlink();
    }
	else
	{
		echo "<h4>"._PREVIEW."</h4>\n";
		$arr_preview = $this->_link_view_handler->build_preview( $_POST );
		echo $this->_template->fetch_link_single( $arr_preview );
	}

	echo "<hr />\n";
	$this->print_modify_comment();

	$this->show_user_form('modify_preview', $this->_lid);

}

//---------------------------------------------------------
// post
//---------------------------------------------------------
function check_form_modlink()
{
	$ret = $this->_link_edit_handler->check_form_modlink( $_POST, $this->_is_owner );
	return $ret;
}

function print_post_error()
{
	$this->print_modify_header();

	echo $this->_link_edit_handler->get_error_msg_modlink();
	echo "<hr />\n";

	$this->print_modify_comment();

	$this->show_user_form('modify_preview', $this->_lid);

}

function post_auto_approve()
{
	$ret = $this->_link_edit_handler->mod_link( $this->_lid, $_POST );
	if ( !$ret )
	{
		$this->_set_errors( $this->_link_edit_handler->getErrors() );
		return false;
	}

	return true;
}

function post_approve()
{
	$mode  = 1;	// request
	$newid = $this->_link_edit_handler->add_link_to_modify( $_POST, $mode );
	if ( !$newid )
	{
		$this->_set_errors( $this->_link_edit_handler->getErrors() );
		return false;
	}

	return $newid;
}

//---------------------------------------------------------
// print
//---------------------------------------------------------
function print_modify_header()
{
	echo '<link rel="stylesheet" type="text/css" media="all" href="'.WEBLINKS_URL.'/weblinks.css" />'."\n";
	echo '&nbsp;';
	echo '<a href="'.XOOPS_URL.'/">'._HOME.'</a> &gt;&gt;';
	echo '<a href="'.WEBLINKS_URL.'/">'.$this->_system_module_name.'</a> &gt;&gt;';
	echo '<a href="'.WEBLINKS_URL.'/singlelink.php?lid='.$this->_lid.'">'.$this->_link_title_s.'</a> &gt;&gt;';
	echo '<span class="weblinks_bold">'._WLS_MODIFY.'</span><br /><br />'."\n";
}

function print_modify_comment()
{
	echo '<div style="width: 100%; margin: 5px; padding: 5px;">'."\n";
	echo "<ul>\n";

	if ( !$this->_is_auto )
	{
		if ( !$this->_is_owner )
		{
			echo "<li>"._WLS_MODIFY_NOT_OWNER."</li>\n";
		}

		echo "<li>"._WLS_MODIFY_PENDING."</li>\n";
	}

	echo "</ul></div><br />\n";
}

//---------------------------------------------------------
// get parameter
//---------------------------------------------------------
function get_permit_param()
{
	return array($this->_is_permit, $this->_is_auto, $this->_is_owner);
}

function get_passwd_incorrect()
{
	return $this->_flag_passwd_incorrect;
}

//---------------------------------------------------------
// token ticket
//---------------------------------------------------------
function make_token()
{
	$ret = $this->_link_edit_handler->make_token();
	return $ret;
}

function check_token()
{
	$ret = $this->_link_edit_handler->check_token();
	return $ret;
}

// --- class end ---
}


//=========================================================
// main
//=========================================================

$weblinks_modlink  =& new weblinks_modlink();

// start
$op  = $weblinks_modlink->get_post_op();
$lid = $weblinks_modlink->get_post_get_lid();

// check permit
$check = $weblinks_modlink->check_access();

if ( $check == -1 ) 
{
	redirect_header("index.php", 3, _NOPERM);
	exit();
}

if ( $check == -2 ) 
{
	redirect_header(XOOPS_URL."/user.php", 3, _WLS_MUSTREGFIRST);
	exit();
}

if ( $check == -3 ) 
{
	redirect_header("index.php", 3, _WLS_ERRORNOLINK);
	exit();
}

if ( $check == 1 )
{
	$url = "./admin/link_manage.php?op=modLink&lid=".$lid;
	redirect_header($url, 1, _WLS_GOTOADMIN);	
	exit();
}

list($is_permit, $is_auto_approve, $is_owner) = $weblinks_modlink->get_permit_param();

if ( $check == 2 )
{
	$xoopsOption['template_main'] = WEBLINKS_DIRNAME."_passwd.html";

	include XOOPS_ROOT_PATH."/header.php";
	$link_title       = $weblinks_modlink->get_title();
	$passwd_incorrect = $weblinks_modlink->get_passwd_incorrect();
	list($token_name, $token_value) = $weblinks_modlink->make_token();
	weblinks_print_form_password($lid, $link_title, $token_name, $token_value, $passwd_incorrect, $is_permit);
	include XOOPS_ROOT_PATH.'/footer.php';
	exit();
}

$url_singlelink = "singlelink.php?lid=".$lid;

// save to DB
if ($op == 'post') 
{
// add URL-less mode
// check form

	if( !( $weblinks_modlink->check_token() ) ) 
	{
		redirect_header($url_singlelink, 5, "Token Error");
		exit();
	}

	if ( !( $weblinks_modlink->check_form_modlink() ) ) 
	{
		include XOOPS_ROOT_PATH."/header.php";
		$weblinks_modlink->print_post_error();
		include XOOPS_ROOT_PATH.'/footer.php';
		exit();
    }

// auto modify approve
	if ( $is_auto_approve )
	{
		$ret = $weblinks_modlink->post_auto_approve();
		if (!$ret)
		{
			redirect_header($url_singlelink, 5, "DB Error");
			exit();
		}

// redirect to single link
		redirect_header($url_singlelink, 1, _WLS_MODIFYAPPROVED);
	}

// modify approve
	else
	{
		$ret = $weblinks_modlink->post_approve();
		if (!$ret)
		{
			redirect_header($url_singlelink, 5, "DB Error");
			exit();
		}

		$tags = array();
		$tags['MODIFYREPORTS_URL'] = WEBLINKS_URL."/admin/index.php?op=listModReq";

		$notification_handler =& xoops_gethandler('notification');
		$notification_handler->triggerEvent('global', 0, 'link_modify', $tags);

		redirect_header($url_singlelink, 1, _WLS_THANKSFORINFO);
	}
}

// preview mode
elseif ($op == 'preview')
{
	include XOOPS_ROOT_PATH."/header.php";
	$weblinks_modlink->print_preview();
	include XOOPS_ROOT_PATH.'/footer.php';
}

// modify form
else 
{
	include XOOPS_ROOT_PATH."/header.php";
	$weblinks_modlink->print_modify_form($lid);
	include XOOPS_ROOT_PATH.'/footer.php';
}

exit();
// --- end of main ---


function weblinks_print_form_password($lid, $link_title, $token_name, $token_value, $incorrect, $request)
{
	global $xoopsTpl, $xoopsConfig;

	$template =& weblinks_template::getInstance( WEBLINKS_DIRNAME );
	$template->assignIndex();

	$xoopsTpl->assign('lang_requestmod',      _WLS_REQUESTMOD);
	$xoopsTpl->assign('lang_password',        _US_PASSWORD);
	$xoopsTpl->assign('lang_submitter',       _WLS_LINKSUBMITTER);
	$xoopsTpl->assign('lang_pleasepassword',  _WLS_PLEASEPASSWORD);
	$xoopsTpl->assign('lang_registered_dsc',  _WLS_REGSTERED_DSC);
	$xoopsTpl->assign('lang_lostpassword',    _US_LOSTPASSWORD);
	$xoopsTpl->assign('lang_noproblem',       _US_NOPROBLEM);
	$xoopsTpl->assign('lang_youremail',       _US_YOUREMAIL);
	$xoopsTpl->assign('lang_sendpassword',    _US_SENDPASSWORD);
	$xoopsTpl->assign('lang_modify',          _WLS_MODIFY);
	$xoopsTpl->assign('lang_cancel',          _CANCEL);
	$xoopsTpl->assign('lang_password_incorrect',  _WEBLINKS_PASSWORD_INCORRECT);
	$xoopsTpl->assign('lang_anonymous',       $xoopsConfig['anonymous'] );
	$xoopsTpl->assign('lid',         $lid);
	$xoopsTpl->assign('link_title',  $link_title);
	$xoopsTpl->assign('token_name',  $token_name);
	$xoopsTpl->assign('token_value', $token_value);
	$xoopsTpl->assign('incorrect_show', $incorrect);
	$xoopsTpl->assign('request_show',   $request);
}

?>