<?php
// $Id: weblinks_singlelink.php,v 1.1 2006/05/24 01:23:56 ohwada Exp $

// 2006-05-15 K.OHWADA
// this is new file
// use new handler

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//================================================================
// WebLinks Module
// move from singlelink.php
// 2006-05-15 K.OHWADA
//================================================================

// === class begin ===
if( !class_exists('weblinks_singlelink') ) 
{

//=========================================================
// class weblinks_singlelink
//=========================================================
class weblinks_singlelink
{
	var $_collect;
	var $_link_view_handler;
	var $_system;

	var $_conf_rss_mode_auto;
	var $_conf_rss_mode_data;
	var $_conf_rss_cache_time;
	var $_conf_rss_perpage;
	var $_conf_rss_num_content;
	var $_conf_rss_mode_title;
	var $_conf_rss_mode_content;
	var $_conf_rss_max_content;
	var $_conf_rss_max_summary;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_singlelink( $dirname )
{
	$config_basic_handler     =& weblinks_get_handler( 'config2_basic',    $dirname );
	$this->_collect           =& weblinks_get_handler( 'rss_atom_collect', $dirname );
	$this->_link_view_handler =& weblinks_get_handler( 'link_view',        $dirname );

	$this->_system =& weblinks_system::getInstance();

	$conf = $config_basic_handler->get_cached();
	$this->_conf_rss_use          = $conf['rss_use'];
	$this->_conf_rss_mode_auto    = $conf['rss_mode_auto'];
	$this->_conf_rss_mode_data    = $conf['rss_mode_data'];
	$this->_conf_rss_cache_time   = $conf['rss_cache_time'];
	$this->_conf_rss_perpage      = $conf['rss_perpage'];
	$this->_conf_rss_num_content  = $conf['rss_num_content'];
	$this->_conf_rss_mode_title   = $conf['rss_mode_title'];
	$this->_conf_rss_mode_content = $conf['rss_mode_content'];
	$this->_conf_rss_max_content  = $conf['rss_max_content'];
	$this->_conf_rss_max_summary  = $conf['rss_max_summary'];

	$this->_link_view_handler->init();
}

function &getInstance( $dirname )
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_singlelink( $dirname );
	}

	return $instance;
}

//---------------------------------------------------------
// wrapper
//---------------------------------------------------------
function get_get_lid()
{
	$lid = $this->_link_view_handler->get_get_lid();
	return $lid;
}

function &get_link($lid)
{
	$link =& $this->_link_view_handler->build_link_show_by_lid($lid);
	return $link;
}

function &get_catpath_arr($lid)
{
	$catpath =& $this->_link_view_handler->get_catpath_array_by_lid($lid);
	return $catpath;
}

//---------------------------------------------------------
// get ATOM feed
// RSS/ATOM auto discovery
//---------------------------------------------------------
function get_atomfeed($lid)
{
	if ( $this->_conf_rss_use )
	{
		$arr = $this->get_atomfeed_auto($lid);
	}
	else
	{
		$arr = array(
			'rss_flag'   => 0,
			'rss_url'    => '',
			'rss_update' => 0,
			'feeds'      => array(),
		);
	}

	return $arr;
}

function get_atomfeed_auto($lid)
{
//	global $xoopsTpl;
//	$xoopsTpl->assign('rss_num_content', $this->_conf_rss_num_content );

	$this->_collect->set_mode_auto(    $this->_conf_rss_mode_auto );
	$this->_collect->set_mode_data(    $this->_conf_rss_mode_data );
	$this->_collect->set_cache_time(   $this->_conf_rss_cache_time );

	$feeds = $this->_collect->parse_xml_for_singlelink($lid);

	$this->_link_view_handler->set_feed_mode_title(   $this->_conf_rss_mode_title );
	$this->_link_view_handler->set_feed_mode_content( $this->_conf_rss_mode_content );
	$this->_link_view_handler->set_feed_max_content(  $this->_conf_rss_max_content );
	$this->_link_view_handler->set_feed_max_summary(  $this->_conf_rss_max_summary );

	if ( !$this->_conf_rss_mode_data )
	{
		$feeds =& $this->_link_view_handler->get_feed_list_latest_by_lid($lid, $this->_conf_rss_perpage);
	}

	$link_obj =& $this->_link_view_handler->get($lid);
	$rss_flag   = $link_obj->getVar('rss_flag', 's');
	$rss_url    = $link_obj->getVar('rss_url', 's');
	$rss_update = $link_obj->rss_update('m');

	$arr = array(
		'rss_num'    => $this->_conf_rss_num_content,
		'rss_flag'   => $rss_flag,
		'rss_url'    => $rss_url,
		'rss_update' => $rss_update,
		'feeds'      => $feeds,
	);

	return $arr;
}

//---------------------------------------------------------
// system parameter
//---------------------------------------------------------
function get_site_name()
{
	$ret = $this->_system->get_sitename();
	return $ret;
}

function get_module_name()
{
	$ret = $this->_system->get_module_name();
	return $ret;
}

// --- class end ---
}

// === class end ===
}

?>