<?php
// $Id: weblinks_object_handler.php,v 1.2 2006/07/23 15:51:56 ohwada Exp $

// 2006-07-23 K.OHWADA
// change checkJavascript()

// 2006-05-15 K.OHWADA
// this is new file
// use new handler

//=========================================================
// WebLinks Module
// this file contain 4 class
//   weblinks_simple_object
//   weblinks_object
//   weblinks_object_generic_handler
//   weblinks_object_handler
// 2006-05-15 K.OHWADA
//=========================================================

//---------------------------------------------------------
// change log
// base on XopsCube's XoopsSimpleObject & XoopsObjectGenericHandler
//
// change class name
//---------------------------------------------------------

// === class begin ===
if( !class_exists('weblinks_object_handler') ) 
{

if( !defined('XOBJ_DTYPE_STRING') ) 
{
	define('XOBJ_DTYPE_STRING', 1);
	define('XOBJ_DTYPE_TEXT',   2);
	define('XOBJ_DTYPE_FLOAT', 12);
	define('XOBJ_DTYPE_BOOL',  13);
}

//=========================================================
// class weblinks_simple_object
// base on XopsCube's XoopsSimpleObject
//=========================================================

/**
 *  This class implements the interface of XoopsObjectInterface. It gives a developer
 * 'TYPE SAFE' with the limit. The instance can have only five data type that are
 * BOOL, INT, FLOAT, STRING and TEXT.
 *  You can not get the sanitizing values by cleanVars() that is the function of
 * XoopsObject. But, all set functions give you 'TYPE SAFE'. You should use this 
 * class with using your favorite ActionForm.
 *
 * "Check values by actionform, set values to XoopsSimpleObject"
 *
 *  This class was defined for "The prolongation of human life plan". This is not 
 * the rule that you are forced.
 * 
 */

// class XoopsSimpleObject extends XoopsObjectInterface
class weblinks_simple_object
{
	var $mVars = array();
	var $mIsNew = true;

	var $_mAllowType = array(XOBJ_DTYPE_BOOL, XOBJ_DTYPE_INT, XOBJ_DTYPE_FLOAT, XOBJ_DTYPE_STRING, XOBJ_DTYPE_TEXT);

//	function XoopsSimpleObject()
	function weblinks_simple_object()
	{
	}

	function setNew()
	{
		$this->mIsNew = true;
	}

	function unsetNew()
	{
		$this->mIsNew = false;
	}

	function isNew()
	{
		return $this->mIsNew;
	}

	function initVar($key, $dataType, $value = null, $required = false, $size = null)
	{
		if (!in_array($dataType, $this->_mAllowType)) {
			die();	// TODO
		}
		
		$this->mVars[$key] = array(
			'data_type' => $dataType,
			'value' => null,
			'required' => $required ? true : false,
			'maxlength' => $size ? intval($size) : null
		);
		
		$this->assignVar($key, $value);
	}

	function assignVar($key, $value)
	{

// add for weblinks
		if ( !isset($this->mVars[$key]) )
		{	return;	}

		switch ($this->mVars[$key]['data_type']) {
			case XOBJ_DTYPE_BOOL:
				$this->mVars[$key]['value'] = $value ? 1 : 0;
				break;

			case XOBJ_DTYPE_INT:
				$this->mVars[$key]['value'] = $value !== null ? intval($value) : null;
				break;

			case XOBJ_DTYPE_FLOAT:
				$this->mVars[$key]['value'] = $value !== null ? floatval($value) : null;
				break;

			case XOBJ_DTYPE_STRING:
				if ($this->mVars[$key]['maxlength'] !== null && strlen($value) > $this->mVars[$key]['maxlength']) {
					$this->mVars[$key]['value'] = xoops_substr($value, 0, $this->mVars[$key]['maxlength'], null);
				}
				else {
					$this->mVars[$key]['value'] = $value;
				}
				break;

			case XOBJ_DTYPE_TEXT:
				$this->mVars[$key]['value'] = $value;
				break;
		}
	}

	function assignVars($values)
	{
		foreach ($values as $key => $value) {
			$this->assignVar($key, $value);
		}
	}

	function set($key, $value)
	{
		$this->assignVar($key, $value);
	}

	function get($key)
	{
		return $this->mVars[$key]['value'];
	}

	function gets()
	{
		$ret = array();
		
		foreach ($this->mVars as $key => $value) {
			$ret[$key] = $value['value'];
		}
		
		return $ret;
	}

	function setVar($key, $value)
	{
		$this->assignVar($key, $value);
	}

	function setVars($values)
	{
		$this->assignVars($values);
	}

	/**
	 * Return HTML string for displaying only by HTML.
	 * The second parametor doesn't exist.
	 */

	function getVar($key)
	{
		$value = null;

		switch ($this->mVars[$key]['data_type']) {
			case XOBJ_DTYPE_BOOL:
			case XOBJ_DTYPE_INT:
			case XOBJ_DTYPE_FLOAT:
				$value = $this->mVars[$key]['value'];
				break;

			case XOBJ_DTYPE_STRING:
				$value = htmlspecialchars($this->mVars[$key]['value'], ENT_QUOTES);
				break;

			case XOBJ_DTYPE_TEXT:
				// TODO
                $ts =& MyTextSanitizer::getInstance();
                $value = $ts->displayTarea($this->mVars[$key]['value'], $html, $smiley, $xcode, $image, $br);
				break;
		}

		return $value;
	}

// add for weblinks
	function addAllowType($type)
	{
		$this->_mAllowType[] = $type;
	}

}
// --- class end ---


//=========================================================
// class weblinks_object
//=========================================================
class weblinks_object extends weblinks_simple_object
{

	function weblinks_object()
	{
		$this->weblinks_simple_object();
		$this->addAllowType( XOBJ_DTYPE_URL );
	}

//---------------------------------------------------------
// override on weblinks_simple_object
//---------------------------------------------------------

// add XOBJ_DTYPE_URL
// string type is striped control code & GPC slashes 
	function assignVar($key, $value)
	{
		if ( !isset($this->mVars[$key]) )
		{	return;	}

		switch ($this->mVars[$key]['data_type']) 
		{
			case XOBJ_DTYPE_BOOL:
			case XOBJ_DTYPE_INT:
			case XOBJ_DTYPE_FLOAT:
				parent::assignVar($key, $value);
				break;

// change for weblinks
// strip GPC slashes
			case XOBJ_DTYPE_STRING:
				$value = $this->_strip_control($value);
				$value = $this->_strip_tab($value);
				$value = $this->_strip_return($value);
				$value = $this->_strip_slashes($value);
				$value = $this->_replace_javascript($value);

				if ($this->mVars[$key]['maxlength'] !== null && strlen($value) > $this->mVars[$key]['maxlength']) {
					$this->mVars[$key]['value'] = xoops_substr($value, 0, $this->mVars[$key]['maxlength'], null);
				}
				else {
					$this->mVars[$key]['value'] = $value;
				}
				break;

// change for weblinks
// strip GPC slashes
			case XOBJ_DTYPE_TEXT:
				$value = $this->_strip_control($value);
				$value = $this->_strip_slashes($value);
				$value = $this->_replace_javascript($value);

				$this->mVars[$key]['value'] = $value;
				break;

// add for weblinks
// strip GPC slashes
			case XOBJ_DTYPE_URL:
				$value = $this->_strip_control($value);
				$value = $this->_strip_tab($value);
				$value = $this->_strip_return($value);
				$value = $this->_strip_slashes($value);
				$value = $this->_deny_javascript($value);
				$value = $this->_deny_http_only($value);
				$value = $this->_allow_http($value);

				if ($this->mVars[$key]['maxlength'] !== null && strlen($value) > $this->mVars[$key]['maxlength']) {
					$this->mVars[$key]['value'] = xoops_substr($value, 0, $this->mVars[$key]['maxlength'], null);
				}
				else {
					$this->mVars[$key]['value'] = $value;
				}
				break;
		}
	}

// add XOBJ_DTYPE_URL
	function set($key, $value)
	{
		if ( !isset($this->mVars[$key]) )
		{	return;	}

		switch ($this->mVars[$key]['data_type']) 
		{
			case XOBJ_DTYPE_BOOL:
			case XOBJ_DTYPE_INT:
			case XOBJ_DTYPE_FLOAT:
			case XOBJ_DTYPE_TEXT:
				parent::assignVar($key, $value);
				break;

// change for weblinks
// NOT process at all
			case XOBJ_DTYPE_STRING:
				$this->mVars[$key]['value'] = $value;
				break;

// add for weblinks
// NOT process at all
			case XOBJ_DTYPE_URL:
				$this->mVars[$key]['value'] = $value;
				break;
		}
	}

// compatible for old version
	function &getVar($key, $format = 's')
	{
		$value = null;

		if ( !isset($this->mVars[$key]) )
		{	return $value;	}

		switch ($this->mVars[$key]['data_type']) 
		{
			case XOBJ_DTYPE_BOOL:
			case XOBJ_DTYPE_INT:
			case XOBJ_DTYPE_FLOAT:
				$value = parent::getVar($key);
				break;

// change for weblniks
			case XOBJ_DTYPE_STRING:
				$value =& $this->getVarString($key, $format);
				break;

// change for weblniks
			case XOBJ_DTYPE_TEXT:
				$value =& $this->getVarText($key, $format);
				break;

// add for weblinks
			case XOBJ_DTYPE_URL:
				$value =& $this->getVarUrl($key, $format);
				break;
		}

		return $value;
	}


//---------------------------------------------------------
// new function for weblinks
//---------------------------------------------------------

// getVar for String type
	function &getVarString($key, $format = 's')
	{
		$value = null;

		if ( !isset($this->mVars[$key]) )
		{	return $value;	}

		if( $this->mVars[$key]['data_type'] != XOBJ_DTYPE_STRING )
		{	return $value;	}

		$value = $this->mVars[$key]['value'];

		switch (strtolower($format)) 
		{

// strip GPC slashes when set by serVar();
			case 's':
			case 'show':
			case 'p':
			case 'preview':
				$value = $this->_strip_control($value);
				$value = $this->_strip_tab($value);
				$value = $this->_strip_return($value);
				$value = $this->_replace_javascript($value);
				$value = htmlspecialchars($value, ENT_QUOTES);
				break;

			case 'e':
			case 'edit':
			case 'f':
			case 'formpreview':
				$value = htmlspecialchars($value, ENT_QUOTES);
				break;

			case 'n':
			case 'none':
			default:
				break;
		}

		return $value;
	}

// getVar for Text type
	function &getVarText($key, $format = 's')
	{
		$value = null;

		if ( !isset($this->mVars[$key]) )
		{	return $value;	}

		if( $this->mVars[$key]['data_type'] != XOBJ_DTYPE_TEXT )
		{	return $value;	}

		$value = $this->mVars[$key]['value'];

		switch (strtolower($format)) 
		{
			case 's':
			case 'show':
			case 'p':
			case 'preview':
				$html   = 0;
				$smiley = 1;
				$xcode  = 1;
				$image  = 1;
				$br     = 1;
				$value =& $this->getVarTextShow($key, $html, $smiley, $xcode, $image, $br);
				break;

			case 'e':
			case 'edit':
			case 'f':
			case 'formpreview':
				$value = htmlspecialchars($value, ENT_QUOTES);
				break;

			case 'n':
			case 'none':
			default:
				break;
		}

		return $value;
	}

// getVar for Text type and Show mode
// allow xcode parameter
// strip GPC slashes when set by serVar();
	function &getVarTextShow($key, $html = 0, $smiley = 0, $xcode = 0, $image = 0, $br = 0)
	{
		$ts =& MyTextSanitizer::getInstance();

		$value = null;

		if ( !isset($this->mVars[$key]) )
		{	return $value;	}

		if( $this->mVars[$key]['data_type'] != XOBJ_DTYPE_TEXT )
		{	return $value;	}

		$value = $this->mVars[$key]['value'];
		$value = $this->_strip_control($value);
		$value = $this->_replace_javascript($value);
		$value = $ts->displayTarea($value, $html, $smiley, $xcode, $image, $br);
		return $value;
	}

// getVar for Url type
	function &getVarUrl($key, $format = 's')
	{
		$value = null;

		if ( !isset($this->mVars[$key]) )
		{	return $value;	}

		if( $this->mVars[$key]['data_type'] != XOBJ_DTYPE_URL )
		{	return $value;	}

		$value = $this->mVars[$key]['value'];

		switch (strtolower($format)) 
		{

// strip GPC slashes when set by serVar();
			case 's':
			case 'show':
			case 'p':
			case 'preview':
				$value = $this->_strip_control($value);
				$value = $this->_strip_tab($value);
				$value = $this->_strip_return($value);
				$value = $this->_deny_javascript($value);
				$value = htmlspecialchars($value, ENT_QUOTES);
				break;

			case 'e':
			case 'edit':
			case 'f':
			case 'formpreview':
				$value = htmlspecialchars($value, ENT_QUOTES);
				break;

			case 'n':
			case 'none':
			default:
				break;
		}

		return $value;
	}

	function &getVarAll($format='n')
	{
		$ret = array();

		foreach ($this->mVars as $k => $v) 
		{
			$ret[$k] = $this->getVar($k, $format);
		}

		return $ret;
	}

// Checks if Javascript are included in string
	function checkJavascript($str)
	{
		$str = $this->_strip_control($str);
		$str = $this->_strip_tab($str);
		$str = $this->_strip_return($str);

		if ( preg_match('/javascript:/si', $str) )
		{
			return true;	// include Javascript
		}
		if ( preg_match('/about:/si', $str) )
		{
			return true;	// include about
		}
		if ( preg_match('/vbscript:/si', $str) )
		{
			return true;	// include vbscript
		}
		return false;
	}

// Checks if string is started from HTTP
	function checkHttpStart($str)
	{
		if ( preg_match("|^https?://|", $str) )
		{
			return true;	// include HTTP
		}
		return false;
	}

// Checks if string is HTTP only
	function checkHttpOnly($str)
	{
		if ( ($str == 'http://') || ($str == 'https://') )
		{
			return true;	// http only
		}
		return false;
	}

//---------------------------------------------------------
// private
//---------------------------------------------------------

// strip control code except TAB, LF, CR
// TAB \x09 \t
// LF  \xOA \n
// CR  \xOD \r
	function _strip_control($str)
	{
		$str = preg_replace('/[\x00-\x08]/','',$str);
		$str = preg_replace('/[\x0B-\x0C]/','',$str);
		$str = preg_replace('/[\x0E-\x1F]/','',$str);
		$str = preg_replace('/[\x7F]/',     '',$str);
		return $str;
	}

// strip TAB code
	function _strip_tab($str)
	{
		$str = preg_replace("/\t/",'',$str);
		return $str;
	}

// strip LF, CR code
	function _strip_return($str)
	{
		$str = preg_replace("/\n/",'',$str);
		$str = preg_replace("/\r/",'',$str);
		return $str;
	}

// strip_slashes
	function _strip_slashes($str)
	{
		$ts  =& MyTextSanitizer::getInstance();
		$str = $ts->stripSlashesGPC($str);
		return $str;
	}

// replace_javascript
	function _replace_javascript($str)
	{
		$str = preg_replace('/javascript:/si', 'java script:', $str);
		$str = preg_replace('/about:/si',      'about :',      $str);
		$str = preg_replace('/vbscript:/si',   'vb script:',   $str);
		return $str;
	}

// deny_javascript
	function _deny_javascript($str)
	{
		if ( $this->checkJavascript($str) )
		{
			return '';
		}
		return $str;
	}

// deny_http_only
	function _deny_http_only($str)
	{
		if ( $this->checkHttpOnly($str) )
		{
			return '';
		}
		return $str;
	}

// allow_http
	function _allow_http($str)
	{
		if ( $this->checkHttpStart($str) )
		{
			return $str;
		}
		return '';
	}

}

// --- class end ---


//=========================================================
// class weblinks_object_generic_handler
// base on XopsCube's XoopsObjectGenericHandler
// require XC2.1 CriteriaElement class
//=========================================================

/**
 * NOTE: This class has only one primary key and one table.
 */

// class XoopsObjectGenericHandler extends XoopsObjectHandler
class weblinks_object_generic_handler extends weblinks_error
{

    /**
     * holds referenced to {@link XoopsDatabase} class object
     *
     * @var object
     * @see XoopsDatabase
     * @access protected
     */
	var $db;
    
	var $mTable = null;
	var $mPrimary = null;
	var $mClass = null;

// add for weblinks	
	var $ceClass = "criteriaElement";
	var $_mStringType = array(XOBJ_DTYPE_STRING, XOBJ_DTYPE_TEXT);


//	function XoopsObjectGenericHandler(&$db)
	function weblinks_object_generic_handler(&$db)
	{

// add for weblinks	
		$this->weblinks_error();

// change for weblinks
//		parent::XoopsObjectHandler($db);
		$this->db =& $db;

		$this->mTable = $this->db->prefix($this->mTable);
	}

	function &create($isNew = true)
	{
		$obj = null;
		if (class_exists($this->mClass)) {
			$obj =& new $this->mClass();
			if($isNew)
				$obj->setNew();
		}
		return $obj;
	}

	function &get($id)
	{
		$ret = null;
		
		$id = $this->db->quoteString($id);
		$sql = "SELECT * FROM " . $this->mTable . " WHERE " . $this->mPrimary . "=${id}";

// change for weblinks
//		$result =  $this->db->query($sql);
		$result =& $this->query($sql);

		if (!$result) {
			return $ret;
		}
		
		if ($this->db->getRowsNum($result) == 1) {
			$ret =& new $this->mClass();
			$ret->assignVars($this->db->fetchArray($result));
			$ret->unsetNew();
		}

		return $ret;
	}

	function &getObjects($criteria = null, $param1 = false, $param2 = false, $param3 = false)
	{

		$ret = array();

		$sql = "SELECT * FROM " . $this->mTable;

// change for weblinks
//		if($criteria !== null && is_a($criteria, 'CriteriaElement')) 
		if($criteria !== null && is_a($criteria, $this->ceClass)) 

		{
			$where = $this->_makeCriteria4sql($criteria);
			
			if (trim($where)) {
				$sql .= " WHERE ".$where;
			}
			
			$sorts = array();
			foreach ($criteria->getSorts() as $sort) {
				$sorts[] = $sort['sort'] . ' ' . $sort['order'];
			}
			if ($criteria->getSort() != '') {
				$sql .= " ORDER BY " . implode(',', $sorts);
			}
			
			$limit=$criteria->getLimit();
			$start=$criteria->getStart();
			
			$ret =& $this->_getObjects($sql, $limit, $start, $param1);
		}
		else 
		{

// add for weblinks
// add order by phrase
			$sql .= " ORDER BY ".$this->mPrimary." ASC";

			$ret =& $this->_getObjects($sql, $param1, $param2, $param3);
		}
		
		return $ret;
	}

	/**
	 * @access private
	 */
	function &_getObjects($sql = null, $limit = 0, $start = 0, $id_as_key = false)
	{
		$ret = array();

// change for weblinks
//		$result =  $this->db->query($sql, $limit, $start);
		$result =& $this->query($sql, $limit, $start);

		if (!$result) {
			return $ret;
		}

		while($row=$this->db->fetchArray($result)) {
			$obj =& new $this->mClass();
			$obj->assignVars($row);
			$obj->unsetNew();
			
			if ($id_as_key)
			{
				$ret[$obj->get($this->mPrimary)]=&$obj;
			}
			else
			{
				$ret[]=&$obj;
			}
			
			unset($obj);
		}
		
		return $ret;
	}

	function getCount($criteria = null)
	{
		$ret = array();

		$sql="SELECT COUNT(*) c FROM " . $this->mTable;

// change for weblinks
//		if($criteria !== null && is_a($criteria, 'CriteriaElement')) 
		if($criteria !== null && is_a($criteria, $this->ceClass)) 

		{
			$where = $this->_makeCriteria4sql($criteria);
			
			if ($where) {
				$sql .= " WHERE " . $where;
			}
		}
			
		return $this->_getCount($sql);
	}

	/**
	 * @access private
	 */
	function _getCount($sql = null)
	{

// change for weblinks
//		$result=$this->db->query($sql);
		$result=$this->query($sql);

		if (!$result) {
			return false;
		}

		$ret = $this->db->fetchArray($result);
		return $ret['c'];
	}

	function insert(&$obj, $force = false)
	{
		if(!is_a($obj, $this->mClass)) {
			return false;
		}

		$new_flag = false;
		
		if ($obj->isNew()) {
			$new_flag = true;
			$sql = $this->_insert($obj);
		}
		else {
			$sql = $this->_update($obj);
		}

// change for weblinks
//		$result = $force ? $this->db->queryF($sql) : $this->db->query($sql);
		$result = $force ? $this->queryF($sql) : $this->query($sql);

		if (!$result){
			return false;
		}
		
		if ($new_flag) {
			$obj->setVar($this->mPrimary, $this->db->getInsertId());
		}

		return true;
	}

	/**
	 * @access private
	 */
	function _insert(&$obj) {
		$fileds=array();
		$values=array();

		$arr = $this->_makeVars4sql($obj);

		foreach($arr as $_name => $_value) {
			$fields[]=$_name;
			$values[]=$_value;
		}

		$sql = @sprintf("INSERT INTO " . $this->mTable . " ( %s ) VALUES ( %s )", implode(",", $fields), implode(",", $values));

		return $sql;
	}

	/**
	 * @access private
	 */
	function _update(&$obj) {
		$set_lists=array();
		$where = "";

		$arr = $this->_makeVars4sql($obj);

		foreach ($arr as $_name => $_value) {
			if ($_name == $this->mPrimary) {
				$where = "${_name}=${_value}";
			}
			else {
				$set_lists[] = "${_name}=${_value}";
			}
		}

		$sql = @sprintf("UPDATE " . $this->mTable . " SET %s WHERE %s", implode(",",$set_lists), $where);

		return $sql;
	}

	/**
	 * SQL generation helper
	 * @param $obj xoopsObject
	 * @return Array
	*/
//	function _makeVars4sql(&$obj)
//	{
//		$ret = array();
//		foreach ($obj->gets() as $key => $value) {
//			switch ($obj->mVars[$key]['data_type']) {
//				case XOBJ_DTYPE_STRING:
//				case XOBJ_DTYPE_TEXT:
//					$ret[$key] = $this->db->quoteString($value);
//					break;
//				default:
//					$ret[$key] = $value;
//			}
//		}
//		return $ret;
//	}

// chang for weblinks
// able to add datatype
	function _makeVars4sql(&$obj)
	{
		$ret = array();

		foreach ($obj->gets() as $key => $value) 
		{
			$dataType = $obj->mVars[$key]['data_type'];
		
			if ( in_array($dataType, $this->_mStringType) )
			{
				$ret[$key] = $this->db->quoteString($value);
			}
			else
			{
				$ret[$key] = $value;
			}
		}

		return $ret;
	}

	function _makeCriteria4sql($criteria)
	{
		$dmmyObj =& $this->create();

		return $this->_makeCriteriaElement4sql($criteria, $dmmyObj);
	}

	/**
	 * @param $criteria CriteriaElement
	 * @param $obj XoopsSimpleObject
	 */	

	function _makeCriteriaElement4sql($criteria, &$obj)
	{

// change for weblinks
//		if (is_a($criteria, "CriteriaElement")) 
		if (is_a($criteria, $this->ceClass)) 

		{
			if ($criteria->hasChildElements()) {
				$queryString = "";
				$maxCount = $criteria->getCountChildElements();
				for ($i = 0; $i < $maxCount ; $i++) {
					$queryString .= " " . $this->_makeCriteria4sql($criteria->getChildElement($i));
					if (($i + 1) != $maxCount) {
						$queryString .= " " . $criteria->getCondition($i);
					}
				}
				
				return "(" . $queryString . ")";
			}
			else {
				//
				// Render
				//
				$name = $criteria->getName();
				$value = $criteria->getValue();
				if ($name != null && isset($obj->mVars[$name])) 
				{

// chang for weblinks
// able to add datatype

//					switch ($obj->mVars[$name]['data_type']) {
//						case XOBJ_DTYPE_BOOL:
//							$value = $value ? "1" : "0";
//							break;
//						case XOBJ_DTYPE_INT:
//							$value = intval($value);
//							break;
//						case XOBJ_DTYPE_FLOAT:
//							$value = floatval($value);
//							break;
//						case XOBJ_DTYPE_STRING:
//						case XOBJ_DTYPE_TEXT:
//							$value = $this->db->quoteString($value);
//							break;
//						default:
//							$value = $criteria->getValue();
//					}

					$value = $this->_makeCriteriaElement4sql_datatpe($criteria, $obj);

				}

				if ($name != null) {
					return $name . " " . $criteria->getOperator() . " " . $value;
				}
				else {
					return null;
				}
				
				return $string;
			}
		}
	}

// add for weblinks
// able to add datatype
	function _makeCriteriaElement4sql_datatpe($criteria, &$obj)
	{
		$name  = $criteria->getName();
		$value = $criteria->getValue();
		$dataType = $obj->mVars[$name]['data_type'];

		if ( in_array($dataType, $this->_mStringType) )
		{
			$value = $this->db->quoteString($value);
		}
		else
		{
			switch ($dataType) 
			{
				case XOBJ_DTYPE_BOOL:
					$value = $value ? "1" : "0";
					break;

				case XOBJ_DTYPE_INT:
					$value = intval($value);
					break;

				case XOBJ_DTYPE_FLOAT:
					$value = floatval($value);
					break;

				default:
					$value = $criteria->getValue();
			}
		}

		return $value;
	}

	/**
	 * @return bool
	 */
	function delete(&$obj, $force=false)
	{
		$id = $this->db->quoteString($obj->get($this->mPrimary));
		$sql = "DELETE FROM " . $this->mTable . " WHERE " . $this->mPrimary . "=${id}";

// change for weblinks
//		return $force ? $this->db->queryF($sql) : $this->db->query($sql);
		return $force ? $this->queryF($sql) : $this->query($sql);

	}

	/**
	 * @param $criteria mixed Criteria or string
	 */
	function deleteAll($criteria, $force=false)
	{
		$objs =& $this->getObjects($criteria);
		
		$flag = true;
		
		foreach ($objs as $obj) {
			$flag &= $this->delete($obj, $force);
		}
		
		return $flag;
	}

// add for weblinks
	function &query($sql = null, $limit = 0, $start = 0)
	{
		$result =& $this->db->query($sql, $limit, $start);
		return $result;
	}

// add for weblinks
	function &queryF($sql = null, $limit = 0, $start = 0)
	{
		$result =& $this->db->queryF($sql, $limit, $start);
		return $result;
	}

// add for weblinks
	function addStringType($type)
	{
		$this->_mStringType[] = $type;
	}
}


//=========================================================
// class weblinks_object_handler
//=========================================================
class weblinks_object_handler extends weblinks_object_generic_handler
{
	var $_dirname;

// debug
	var $_flag_debug_print_sql = 0;
	var $_debug_max_sql = 1000;

// define by weblinks_object_generic_handler
//	var $db;
//	var $mTable   = null;
//	var $mPrimary = null;
//	var $mClass   = null;

// define by weblinks_error
//	var $_flag_debug_print_log   = 0;
//	var $_flag_debug_print_error = 0;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
	function weblinks_object_handler( $dirname, $tablename, $mPrimary )
	{

// base class
		$db =& Database::getInstance();
		$this->weblinks_object_generic_handler($db);

// parameter
		$this->mClass   = 'weblinks_'.$tablename;
		$this->mPrimary = $mPrimary;
		$this->mTable   = $this->prefix($tablename, $dirname);
		$this->ceClass  = 'weblinks_criteria_element';
		$this->addStringType( XOBJ_DTYPE_URL );

		$this->_dirname = $dirname;
	}

//---------------------------------------------------------
// override on weblinks_object_generic_handler
//---------------------------------------------------------

// separate insert and update 
// return newid
	function insert(&$obj, $force = false)
	{
		if(!is_a($obj, $this->mClass)) 
		{
			return false;
		}

		if ( !$obj->isNew() ) 
		{
			return false;
		}

		$sql = $this->_insert($obj);
		$result = $force ? $this->queryF($sql) : $this->query($sql);

		if (!$result)
		{
			return false;
		}

		$newid = $this->db->getInsertId();
		$obj->setVar($this->mPrimary, $newid);

		return $newid;
	}

// separate insert and update 
	function update(&$obj, $force = false)
	{
		if(!is_a($obj, $this->mClass)) 
		{
			return false;
		}

		if ( $obj->isNew() ) 
		{
			return false;
		}

		$sql = $this->_update($obj);
		$result = $force ? $this->queryF($sql) : $this->query($sql);

		if (!$result)
		{
			return false;
		}

		return true;
	}

// add error handling 
	function &query($sql, $limit=0, $offset=0, $force=false)
	{
		if ( $force )
		{
			$res =& $this->db->queryF($sql, $limit, $offset);
		}
		else
		{
			$res =& $this->db->query($sql, $limit, $offset);
		}

		$this->_print_sql($sql, $limit, $offset);

		if ( !$res ) 
		{
			$this->_set_db_error($sql, $limit, $offset);
		}

		return $res;
	}

// add error handling 
	function &queryF($sql, $limit=0, $offset=0)
	{
		$res =& $this->db->queryF($sql, $limit, $offset);

		$this->_print_sql($sql, $limit, $offset);

		if ( !$res ) 
		{
			$this->_set_db_error($sql, $limit, $offset);
		}

		return $res;
	}

//---------------------------------------------------------
// new function for weblinks
//---------------------------------------------------------
	function &getVarAll($id, $format='n')
	{
		$arr = array();

		$obj = $this->get($id);
		if ( is_object($obj) )
		{
			$arr =& $obj->getVarAll($format);
		}

		return $arr;
	}

	function &getList($criteria = null)
	{
		$ret = array();
		$limit = $start = 0;

		$sql = "SELECT ".$this->mPrimary." FROM ".$this->mTable;

		if($criteria !== null && is_a($criteria, $this->ceClass)) 
		{
			$where = $this->_makeCriteria4sql($criteria);

			if (trim($where)) 
			{
				$sql .= " WHERE ".$where;
			}

			$sorts = array();

			foreach ($criteria->getSorts() as $sort) 
			{
				$sorts[] = $sort['sort'] . ' ' . $sort['order'];
			}

			if ($criteria->getSort() != '') 
			{
				$sql .= " ORDER BY " . implode(',', $sorts);
			}

			$limit = $criteria->getLimit();
			$start = $criteria->getStart();
		}
		else 
		{
			$sql .= ' ORDER BY '.$this->mPrimary;
		}

		$ret =& $this->getFirstRowsBySql($sql, $limit, $start);
		return $ret;
	}

	function &getObjectsBySql($sql, $limit = 0, $start = 0, $id_as_key = false)
	{
		$limit = intval($limit);
		$start = intval($start);

		$ret =& $this->_getObjects($sql, $limit, $start, $id_as_key);
		return $ret;
	}

	function getCountBySql($sql)
	{
		$count = $this->_getCount($sql);
		return $count;
	}

	function &getFirstRowsBySql($sql, $limit=0, $start=0)
	{
		$limit = intval($limit);
		$start = intval($start);

		$res =& $this->query($sql, $limit, $start);
		if ( !$res ) 
		{	return $res;	}

		$ret = array();

		while ($myrow = $this->db->fetchRow($res)) 
		{
			$ret[] = $myrow[0];
		}

		return $ret;
	}

	function fetchArray($result)
	{
		$ret = $this->db->fetchArray($result);
		return $ret;
	}

	function prefix($tablename='', $dirname='')
	{
		if ($dirname)
		{
			$tablename = $dirname."_".$tablename;
		}

		$ret = $this->db->prefix($tablename);
		return $ret;
	}

	function existsFieldName($name)
	{
		$sql = "SELECT * FROM ".$this->mTable;

		$res =& $this->query($sql); 
		if ( !$res ) 
		{	return false;	}

		$num = $this->db->getFieldsNum( $res );

		for ( $i=0; $i<$num; $i++ ) 
		{
			$meta = mysql_fetch_field($res);

			if ($meta) 
			{
				if ( $meta->name == $name )
				{
					return true;
				}
			}
		}

		return false;
	}

	function existsTable()
	{
		$sql = "SHOW TABLES";

		$res =& $this->queryF($sql); 
		if ( !$res ) 
		{	return false;	}

		$table_name = strtolower( $this->mTable );

		while ($myrow = $this->db->fetchRow($res)) 
		{
			$name = strtolower( $myrow[0] );

			if ( $name == $table_name )
			{
				return true;
			}
		}

		return false;
	}

//---------------------------------------------------------
// private
//---------------------------------------------------------
	function _set_db_error($sql='', $limit=0, $offset=0)
	{
		$err = $this->db->error();
		$this->_set_errors( $err );

		if ($sql)
		{
			$msg = "$sql: $limit, $offset";
			$msg = $this->_shorten_text($msg, $this->_debug_max_sql);
			$this->_set_errors( $msg );
		}
	}

	function _print_sql($sql, $limit=0, $offset=0)
	{
		if ( !$this->_flag_debug_print_sql )  return;
		if ( empty($sql) )  return;

		$msg = "$sql: $limit, $offset";
		$msg = $this->_shorten_text($msg, $this->_debug_max_sql);
		$msg = htmlSpecialChars($msg);
		echo "sql: $msg <br />\n";
	}

	function _shorten_text($text, $max=100)
	{
		if ( strlen($text) > $max)
		{
			if (function_exists('mb_strcut'))
			{
				$text = mb_strcut( $text, 0, $max )." ...";
			}
			else
			{
				$text = substr( $text, 0, $max )." ...";
			}
		} 

		return $text;
	}

//---------------------------------------------------------
// set parameter
//---------------------------------------------------------
	function set_debug_sql($val)
	{
		$this->_flag_debug_print_sql = intval($val);
	}

	function set_debug_error($val)
	{
		$this->_flag_debug_print_error = intval($val);
	}

	function set_debug_max_sql($val)
	{
		$this->_debug_max_sql = intval($val);
	}

	function get_table_name()
	{
		return $this->mTable;
	}
}
// --- class end ---


}
// === class end ===

?>