<?php
// $Id: weblinks_modify_handler.php,v 1.2 2006/05/24 01:23:56 ohwada Exp $

// 2006-05-15 K.OHWADA
// new handler
// not use weblinks_module_base

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication


//=========================================================
// WebLinks Module
// this file contain 2 class
//   weblinks_modify 
//   weblinks_modify_handler
// 2004/01/14 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_modify_handler') ) 
{

//=========================================================
// class weblinks_modify
//=========================================================
class weblinks_modify extends weblinks_link_base
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_modify()
{
	$this->weblinks_link_base();

	$this->initVar('mid',    XOBJ_DTYPE_INT, 0, false);
	$this->initVar('mode',   XOBJ_DTYPE_INT, 0, false);
	$this->initVar('muid',   XOBJ_DTYPE_INT, 0, false);

	$this->initVar('lid',    XOBJ_DTYPE_INT, 0, false);
	$this->initVar('uid',    XOBJ_DTYPE_INT, 0, false);
	$this->initVar('cids',   XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('title',  XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('url',    XOBJ_DTYPE_URL,    null, false, 255);
	$this->initVar('banner', XOBJ_DTYPE_URL,    null, false, 255);
	$this->initVar('description',  XOBJ_DTYPE_TEXT);
	$this->initVar('name',     XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('nameflag', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('mail',     XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('mailflag', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('company',  XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('addr',     XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('tel',      XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('search',     XOBJ_DTYPE_TEXT);
	$this->initVar('passwd',   XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('admincomment',   XOBJ_DTYPE_TEXT);
	$this->initVar('mark',         XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('time_create',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('time_update',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('hits',     XOBJ_DTYPE_INT, 0, false);
	$this->initVar('rating',   XOBJ_DTYPE_FLOAT, 0.0, false);
	$this->initVar('votes',    XOBJ_DTYPE_INT, 0, false);
	$this->initVar('comments', XOBJ_DTYPE_INT, 0, false);
//	$this->initVar('width',    XOBJ_DTYPE_INT, 0, false);
//	$this->initVar('height',   XOBJ_DTYPE_INT, 0, false);
	$this->initVar('recommend',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('mutual',     XOBJ_DTYPE_INT, 0, false);
	$this->initVar('broken',     XOBJ_DTYPE_INT, 0, false);
	$this->initVar('rss_url',    XOBJ_DTYPE_URL, null, false, 255);
	$this->initVar('rss_flag',   XOBJ_DTYPE_INT, 0, false);
	$this->initVar('rss_xml',    XOBJ_DTYPE_TEXT);
	$this->initVar('rss_update', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('usercomment',  XOBJ_DTYPE_TEXT);
	$this->initVar('zip',    XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('state',  XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('city',   XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('addr2',  XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('fax',    XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('dohtml',   XOBJ_DTYPE_INT, 0, false);
	$this->initVar('dosmiley', XOBJ_DTYPE_INT, 1, false);
	$this->initVar('doxcode',  XOBJ_DTYPE_INT, 1, false);
	$this->initVar('doimage',  XOBJ_DTYPE_INT, 1, false);
	$this->initVar('dobr',     XOBJ_DTYPE_INT, 1, false);
	$this->initVar('etc1',   XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('etc2',   XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('etc3',   XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('etc4',   XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('etc5',   XOBJ_DTYPE_STRING, null, false, 255);

	$this->initVar('notify',   XOBJ_DTYPE_INT, 0, false);

}

//---------------------------------------------------------
// set var
//---------------------------------------------------------
function assign_vars_post( &$post )
{
	$this->set_var_key($post, 'mid');
	$this->set_var_key($post, 'mode');
	$this->set_var_key($post, 'lid');
	$this->set_var_key($post, 'uid');
	$this->set_var_key($post, 'title');
	$this->set_var_key($post, 'name');
	$this->set_var_key($post, 'nameflag');
	$this->set_var_key($post, 'mail');
	$this->set_var_key($post, 'mailflag');
	$this->set_var_key($post, 'company');
	$this->set_var_key($post, 'addr');
	$this->set_var_key($post, 'tel');
	$this->set_var_key($post, 'search');
	$this->set_var_key($post, 'passwd');
	$this->set_var_key($post, 'admincomment');
	$this->set_var_key($post, 'mark');
	$this->set_var_key($post, 'time_create');
	$this->set_var_key($post, 'time_update');
	$this->set_var_key($post, 'hits');
	$this->set_var_key($post, 'rating');
	$this->set_var_key($post, 'votes');
	$this->set_var_key($post, 'comments');
//	$this->set_var_key($post, 'width');
//	$this->set_var_key($post, 'height');
	$this->set_var_key($post, 'recommend');
	$this->set_var_key($post, 'mutual');
	$this->set_var_key($post, 'broken');
	$this->set_var_key($post, 'rss_flag');
	$this->set_var_key($post, 'rss_xml');
	$this->set_var_key($post, 'rss_update');
	$this->set_var_key($post, 'usercomment');
	$this->set_var_key($post, 'zip');
	$this->set_var_key($post, 'state');
	$this->set_var_key($post, 'city');
	$this->set_var_key($post, 'addr2');
	$this->set_var_key($post, 'fax');

	$this->set_var_key($post, 'etc1');
	$this->set_var_key($post, 'etc2');
	$this->set_var_key($post, 'etc3');
	$this->set_var_key($post, 'etc4');
	$this->set_var_key($post, 'etc5');
	$this->set_var_key($post, 'notify');

	$this->set_var_key($post, 'url');
	$this->set_var_key($post, 'banner');
	$this->set_var_key($post, 'rss_url');

	$this->set_muid($post);
	$this->set_desc($post);

	$this->set_cids($post);

// after set_conf_desc_option()
	$this->set_desc_option($post, 'dohtml');
	$this->set_desc_option($post, 'dosmiley');
	$this->set_desc_option($post, 'doxcode');
	$this->set_desc_option($post, 'doimage');
	$this->set_desc_option($post, 'dobr');

}

function set_muid($post)
{
	list($uid, $name, $mail) = $this->get_system_param();

	if ( isset($post['muid']) )
	{
		$uid = $post['muid'];
	}

	$this->setVar('muid', $uid);
}

//---------------------------------------------------------
// show mode
//---------------------------------------------------------

// --- class end ---
}

//=========================================================
// class weblinks_modify_handler
//=========================================================
class weblinks_modify_handler extends weblinks_object_handler
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_modify_handler( $dirname )
{
	$this->weblinks_object_handler( $dirname, 'modify', 'mid' );

	$this->set_debug_sql(   WEBLINKS_DEBUG_MODIFY_SQL );
	$this->set_debug_error( WEBLINKS_DEBUG_ERROR );

}

//---------------------------------------------------------
// delete
//---------------------------------------------------------
function delete_by_lid($lid)
{
	$sql = 'DELETE FROM '.$this->mTable.' WHERE lid='.intval($lid);

	if ( !$this->query($sql) )
	{	return false;	}

	return true;
}

//---------------------------------------------------------
// get count
//---------------------------------------------------------
function get_count_by_mode($mode)
{
	$mode = intval($mode);
	$criteria = new weblinks_criteria_compo();
	$criteria->add( new weblinks_criteria('mode', $mode, '=') );
	$count = $this->getCount($criteria);
	return $count;
}

function get_count_new()
{
	$count = $this->get_count_by_mode(0);
	return $count;
}

function get_count_mod()
{
	$count = $this->get_count_by_mode(1);
	return $count;
}


//---------------------------------------------------------
// get object
//---------------------------------------------------------
function &get_objects_by_mode($mode, $limit=0, $start=0)
{
	$mode = intval($mode);
	$criteria = new weblinks_criteria_compo();
	$criteria->add( new weblinks_criteria('mode', $mode, '=') );
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$objs =& $this->getObjects($criteria);
	return $objs;
}

function &get_objects_new($limit=0, $start=0)
{
	$objs =& $this->get_objects_by_mode(0, $limit, $start);
	return $objs;
}

function &get_objects_mod($limit=0, $start=0)
{
	$objs =& $this->get_objects_by_mode(1, $limit, $start);
	return $objs;
}

//---------------------------------------------------------
// get mid list
//---------------------------------------------------------
function &get_mid_array_by_mode($mode, $limit=0, $start=0)
{
	$mode = intval($mode);
	$criteria = new weblinks_criteria_compo();
	$criteria->add( new weblinks_criteria('mode', $mode, '=') );
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$list =& $this->getList($criteria);
	return $list;
}

function &get_mid_array_new($limit=0, $start=0)
{
	$mid_arr =& $this->get_mid_array_by_mode(0, $limit, $start);
	return $mid_arr;
}

function &get_mid_array_mod($limit=0, $start=0)
{
	$mid_arr =& $this->get_mid_array_by_mode(1, $limit, $start);
	return $mid_arr;
}


//=========================================================
// alter table
//=========================================================
function check_version_110()
{
	$ret = $this->existsFieldName( 'dohtml' );
	return $ret;
}

function add_column_table_110()
{
$sql1 = "
  ALTER TABLE ".$this->mTable." ADD COLUMN (
  dohtml   tinyint(1) NOT NULL default 0,
  dosmiley tinyint(1) NOT NULL default 1,
  doxcode  tinyint(1) NOT NULL default 1,
  doimage  tinyint(1) NOT NULL default 1,
  dobr     tinyint(1) NOT NULL default 1,
  etc1 varchar(255) default NULL,
  etc2 varchar(255) default NULL,
  etc3 varchar(255) default NULL,
  etc4 varchar(255) default NULL,
  etc5 varchar(255) default NULL,
  notify   tinyint(1) NOT NULL default 0
)";

	$ret1 = $this->query($sql1);

	$sql2 = "ALTER TABLE ".$this->mTable." MODIFY cids varchar(255) default NULL ";
	$ret2 = $this->query($sql2);

	$sql3 = "ALTER TABLE ".$this->mTable." MODIFY title varchar(255) NOT NULL default '' ";
	$ret3 = $this->query($sql3);

	$sql4 = "ALTER TABLE ".$this->mTable." MODIFY zip varchar(255) default NULL ";
	$ret4 = $this->query($sql4);

	$sql5 = "ALTER TABLE ".$this->mTable." MODIFY state varchar(255) default NULL ";
	$ret5 = $this->query($sql5);

	$sql6 = "ALTER TABLE ".$this->mTable." MODIFY city varchar(255) default NULL ";
	$ret6 = $this->query($sql6);

	if ( $ret1 && $ret2 && $ret3 && $ret4 && $ret5 && $ret6 )
	{
		return true;
	}

	return false;
}

// --- class end ---
}

// === class end ===
}

?>