<?php
// $Id: weblinks_linkitem_store_handler.php,v 1.1 2006/05/24 01:23:56 ohwada Exp $

// 2006-05-15 K.OHWADA
// this is new file
// use new handler

//================================================================
// WebLinks Module
// this file contain 2 class
//   weblinks_linkitem_form
//   weblinks_linkitem_store_handler
// 2006-05-15 K.OHWADA
//================================================================

// === class begin ===
if( !class_exists('weblinks_linkitem_store_handler') ) 
{

//=========================================================
// class weblinks_linkitem_form
//=========================================================
class weblinks_linkitem_form extends weblinks_form
{
	var $_linkitem_define_handler;

// define by weblinks_form
//	var $_form_name   = 'weblinks';
//	var $_token_name  = 'weblinks';
//	var $_op_name     = 'op';
//	var $_submit_name = 'submit';
//	var $_method      = 'post';

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_linkitem_form( $dirname )
{
	$this->weblinks_form();

	$this->_linkitem_define_handler =& weblinks_get_handler( 'linkitem_define', $dirname );
	$this->set_form_name( 'weblinks_linkitem' );

}

function &getInstance( $dirname )
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_linkitem_form( $dirname );
	}

	return $instance;
}

//---------------------------------------------------------
// main function
//---------------------------------------------------------
function show($form_title)
{
	$linkitem_arr = $this->_linkitem_define_handler->load();

// form start
	echo $this->make_form_start();
	echo $this->make_form_token();
	echo $this->make_form_hidden('op', 'save');
	echo $this->make_form_hidden('save_linkitem', 1);
	echo $this->make_table_start();
	echo $this->make_table3_title( $form_title );

	$options = array(
		_WEBLINKS_NO_USE        => 0,
		_WEBLINKS_USE           => 1,
		_WEBLINKS_INDISPENSABLE => 2,
	);

// list from config array
	foreach ($linkitem_arr as $item_id => $linkitem) 
	{
		$name      = $linkitem['name'];
		$conf_form = $linkitem['conf_form'];
		$title     = $linkitem['title'];
		$user_mode = $linkitem['user_mode'];

		if ( $conf_form == 0 )  { continue; }

		$name_d  = $name;
		$name_d .= $this->make_form_hidden("item_ids[]", $item_id);

		$ele1  = $this->make_form_text("title[$item_id]", $title, 40);

		if ( $conf_form == 2 )
		{
			$ele2 = $this->get_option_name($user_mode, $options);
		}
		else
		{
			$ele2 = $this->make_form_radio_select("user_mode[$item_id]", $user_mode, $options);
		}

		echo $this->make_table3_line($name_d, $ele1, $ele2);
	}

	$button = $this->make_form_submit('submit', _WEBLINKS_UPDATE );

	echo $this->make_table3_submit($button);
	echo $this->make_table_end();
	echo $this->make_form_end();

// form end

}

//---------------------------------------------------------
// make table form
//---------------------------------------------------------
function make_table3_title($title)
{
	$text  = "<tr valign='top' align='left'>";
	$text .= $this->make_table_col_head($title, '', '', 3);
	$text .= "</tr>\n";
	return $text;
}

function make_table3_line($title, $ele1, $ele2)
{
	$text  = "<tr valign='top' align='left'>";
	$text .= $this->make_table_col($title, 'head');
	$text .= $this->make_table_col($ele1,  'odd');
	$text .= $this->make_table_col($ele2,  'odd');
	$text .= "</tr>\n";
	return $text;
}

function make_table3_submit($button)
{
	$text  = "<tr valign='top' align='left'>";
	$text .= $this->make_table_col('', 'foot');
	$text .= $this->make_table_col($button,  'foot', 'center', 2);
	$text .= "</tr>\n";
	return $text;
}

function get_option_name($value, $options)
{
	foreach ($options as $opt_name => $opt_val)
	{
		if ( isset($value) && ( $value == $opt_val ) )
		{
			return $opt_name;
		}
	}

	return '';
}

// --- class end ---
}

//================================================================
// class weblinks_linkitem_store_handler
//================================================================
class weblinks_linkitem_store_handler extends weblinks_error
{
	var $_handler;
	var $_define;
	var $_post;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_linkitem_store_handler( $dirname )
{
	$this->weblinks_error();

	$this->_handler =& weblinks_get_handler('linkitem', $dirname);
	$this->_define  =& weblinks_linkitem_define::getInstance();
	$this->_post    =& weblinks_post::getInstance();
}

//---------------------------------------------------------
// init config
//---------------------------------------------------------
function init()
{
	$flag_error = false;

	$define_arr = $this->_define->get_define();

// list from Define
	foreach ($define_arr as $item_id => $def) 
	{
		$name      = $def['name'];
		$title     = $def['title'];
		$user_mode = $def['user_mode'];

		$obj =& $this->_handler->create();
		$obj->setVar('item_id',   $item_id);
		$obj->setVar('name',      $name);
		$obj->setVar('title',     $title);
		$obj->setVar('user_mode', $user_mode);

		$ret = $this->_handler->insert($obj);
		if ( !$ret )
		{
			$flag_error = true;
			$this->_set_errors( $this->_handler->getErrors() );
		}

		unset($obj);
	}

	if ( $flag_error ) { return false; }
	return true;
}

//---------------------------------------------------------
// save config
//---------------------------------------------------------
function save()
{
	$flag_error = false;

	$itemid_arr = $this->_post->get_post_array_int('item_ids');
	$title_arr  = $this->_post->get_post_array_text('title');
	$mode_arr   = $this->_post->get_post_array_int('user_mode');

	$count = count($itemid_arr);
	if ($count <= 0)  return true;	// no actuion

// list from POST 
	for ( $i=0; $i<$count; $i++ ) 
	{
		$itemid = $itemid_arr[$i];

		$obj =& $this->_handler->get_by_itemid($itemid);
		if ( !is_object($obj) )  continue;

		$title_current = $obj->getVar('title');
		$mode_current  = $obj->getVar('user_mode');

		$title = '';
		$mode  = 0;

		if ( isset( $title_arr[$itemid] ) )
		{
			$title = $title_arr[$itemid];
			$obj->setVar('title', $title);
		}

		if ( isset( $mode_arr[$itemid] ) )
		{
			$mode = $mode_arr[$itemid];
			$obj->setVar('user_mode',  $mode);
		}

		if (( $title != $title_current )||( $mode != $mode_current ))
		{
			$ret = $this->_handler->update($obj);
			if ( !$ret )
			{
				$flag_error = true;
				$this->_set_errors( $this->_handler->getErrors() );
			}
		}

		unset($obj);
	}

	if ( $flag_error ) { return false; }
	return true;
}

//---------------------------------------------------------
// linkitem_handler
//---------------------------------------------------------
function existsTable()
{
	$ret = $this->_handler->existsTable();
	return $ret;
}

function getCount()
{
	$count = $this->_handler->getCount();
	return $count;
}

function create_table()
{
	$ret = $this->_handler->create_table();
	if ( !$ret )
	{
		$this->_set_errors( $this->_handler->getErrors() );
	}

	return $ret;
}

// --- class end ---
}

// === class end ===
}

?>