<?php
// $Id: weblinks_linkitem_handler.php,v 1.2 2006/06/11 11:35:20 ohwada Exp $

// 2006-06-11 K.OHWADA
// BUG 4032 : cannot create table in MySQL 3.23

// 2006-05-15 K.OHWADA
// this is new file
// use new handler

//================================================================
// WebLinks Module
// this file contain 2 class
//   weblinks_linkitem 
//   weblinks_linkitem_handler
// 2006-05-15 K.OHWADA
//================================================================


// === class begin ===
if( !class_exists('weblinks_linkitem_handler') ) 
{

//================================================================
// class weblinks_linkitem
//================================================================
class weblinks_linkitem extends weblinks_object
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_linkitem()
{
	$this->weblinks_object();

	$this->initVar('id',         XOBJ_DTYPE_INT, 0, false);
	$this->initVar('item_id',    XOBJ_DTYPE_INT, 0, true);
	$this->initVar('name',       XOBJ_DTYPE_STRING, null, true, 255);
	$this->initVar('title',      XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('user_mode',  XOBJ_DTYPE_INT,   0);
	$this->initVar('aux_int_1',  XOBJ_DTYPE_INT,   0);
	$this->initVar('aux_int_2',  XOBJ_DTYPE_INT,   0);
	$this->initVar('aux_text_1', XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('aux_text_2', XOBJ_DTYPE_STRING, null, false, 255);
}

// --- class end ---
}

//================================================================
// class weblinks_linkitem_handler
//================================================================
class weblinks_linkitem_handler extends weblinks_object_handler
{
	var $_cached_by_itemid = array();
	var $_cached_by_name   = array();

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_linkitem_handler( $dirname )
{
	$this->weblinks_object_handler( $dirname, 'linkitem', 'item_id' );

	$this->set_debug_sql(   WEBLINKS_DEBUG_LINKITEM_SQL );
	$this->set_debug_error( WEBLINKS_DEBUG_ERROR );

}


//---------------------------------------------------------
// load
//---------------------------------------------------------
function load()
{
	static $flag_init_load;

	if ( !isset($flag_init_load) ) 
	{
		$flag_init_load = 1;
		$this->_load_db();
	}

	return $this->_cached_by_itemid;
}

function _load_db()
{
	$this->_cached_by_itemid = array();
	$this->_cached_by_name   = array();

	$objs = $this->getObjects();

	foreach ($objs as $obj)
	{
		$arr = $obj->getVarAll('n');
		$this->_cached_by_itemid[ $arr['item_id'] ] = $arr;
		$this->_cached_by_name[   $arr['name'] ]    = $arr;
	}

}

function get_cache_by_itemid_key($id, $key)
{
	if ( isset( $this->_cached_by_itemid[$id][$key] ) )
	{
		$val = $this->_cached_by_itemid[$id][$key];
		return $val;
	}

	return false;
}

function get_cache_by_name_key($name, $key)
{
	if ( isset( $this->_cached_by_name[$name][$key] ) )
	{
		$val = $this->_cached_by_name[$name][$key];
		return $val;
	}

	return false;
}

//---------------------------------------------------------
// get object
//---------------------------------------------------------
function &get_by_itemid($item_id)
{
	$criteria = new weblinks_criteria_compo();
	$criteria->add( new weblinks_criteria('item_id', $item_id, '=') );
	$objs =& $this->getObjects($criteria);
	$count = count($objs);

	if ( $count <= 0 )  { return false; }

	if ( $count > 1  )  
	{
		$this->_set_errors( "table ".$this->mTable." : too many matched" );
	}

	if ( is_object( $objs[0] ) )
	{
		$obj =& $objs[0];
		return $obj;
	}

	return false;
}

//---------------------------------------------------------
// create_table
//---------------------------------------------------------
function create_table()
{
// BUG : cannot create table in MySQL 3.23
// remove last ';'
$sql = "
CREATE TABLE ".$this->mTable." (
  id      smallint(5) unsigned NOT NULL auto_increment,
  item_id smallint(5) unsigned NOT NULL default 0,
  name      varchar(255) NOT NULL default '',
  title     varchar(255) NOT NULL default '',
  user_mode int(5) default '0',
  aux_int_1 int(5) default '0',
  aux_int_2 int(5) default '0',
  aux_text_1 varchar(255) default '',
  aux_text_2 varchar(255) default '',
  PRIMARY KEY (id),
  KEY item_id (item_id)
) TYPE=MyISAM
";

	$ret = $this->query($sql);
	return $ret;
}

// --- class end ---
}

// === class end ===
}

?>