<?php
// $Id: weblinks_link_view_handler.php,v 1.2 2006/07/22 09:36:13 ohwada Exp $

// 2006-07-22 K.OHWADA
// BUG 4152: not show catpath in link list

// 2006-05-15 K.OHWADA
// this is new file
// use new handler

//=========================================================
// WebLinks Module
// 2006-05-15 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_link_view_handler') ) 
{

//=========================================================
// class weblinks_link_view
//=========================================================
class weblinks_link_view
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link_view()
{
	// dummy
}

//---------------------------------------------------------
// function
//---------------------------------------------------------

// --- class end ---
}

//=========================================================
// class weblinks_link_view_handler
//=========================================================
class weblinks_link_view_handler
{
	var $_dirname;

	var $_config_handler;
	var $_link_handler;
	var $_category_handler;
	var $_catlink_handler;
	var $_link_catlink_handler;
	var $_atomfeed_handler;

	var $_link_utility;
	var $_system;
	var $_strings;
	var $_remote_image;
	var $_image_size;
	var $_post;

// config
	var $_conf_array = array();
	var $_conf_cat_img_width     = 0;
	var $_conf_cat_img_height    = 0;
	var $_conf_list_image_width  = 0;
	var $_conf_list_image_height = 0;
	var $_conf_link_image_width  = 0;
	var $_conf_link_image_height = 0;
	var $_conf_link_image_auto;
	var $_conf_descshort;
	var $_conf_newdays;
	var $_conf_popular;
	var $_conf_view_url;
	var $_conf_broken;
	var $_conf_recommend_pri;
	var $_conf_mutual_pri;

// system
	var $_system_is_admin;
	var $_system_uid;

// atomfeed
	var $_feed_mode_title    = 0;	// not allow HTML tag
	var $_feed_mode_content  = 0;	// not allow HTML tag
	var $_feed_max_content   = 100;
	var $_feed_max_summary   = 100;
	var $_feed_title_default = '---';


//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link_view_handler( $dirname )
{
	$this->_dirname = $dirname;

	$this->_config_handler       =& weblinks_get_handler( 'config2_basic', $dirname );
	$this->_link_handler         =& weblinks_get_handler( 'link',          $dirname );
	$this->_category_handler     =& weblinks_get_handler( 'category',      $dirname );
	$this->_catlink_handler      =& weblinks_get_handler( 'catlink',       $dirname );
	$this->_link_catlink_handler =& weblinks_get_handler( 'link_catlink',  $dirname );
	$this->_atomfeed_handler     =& weblinks_get_handler( 'atomfeed',      $dirname );

	$this->_link_utility =& weblinks_link_utility::getInstance();
	$this->_system       =& weblinks_system::getInstance();
	$this->_strings      =& weblinks_strings::getInstance();
	$this->_remote_image =& weblinks_remote_image::getInstance();
	$this->_image_size   =& weblinks_image_size::getInstance();
	$this->_post         =& weblinks_post::getInstance();

	$conf = $this->_config_handler->get_cached();
	$this->_conf_array             = $conf;
	$this->_conf_cat_img_width     = $conf['cat_img_width'];
	$this->_conf_cat_img_height    = $conf['cat_img_height'];
	$this->_conf_list_image_width  = $conf['list_image_width'];
	$this->_conf_list_image_height = $conf['list_image_height'];
	$this->_conf_link_image_width  = $conf['link_image_width'];
	$this->_conf_link_image_height = $conf['link_image_height'];
	$this->_conf_link_image_auto   = $conf['link_image_auto'];
	$this->_conf_descshort         = $conf['descshort'];
	$this->_conf_newdays           = $conf['newdays'];
	$this->_conf_popular           = $conf['popular'];
	$this->_conf_view_url          = $conf['view_url'];
	$this->_conf_broken            = $conf['broken_threshold'];
	$this->_conf_recommend_pri     = $conf['recommend_pri'];
	$this->_conf_mutual_pri        = $conf['mutual_pri'];

	$this->_system_is_admin = $this->_system->is_module_admin();
	$this->_system_uid      = $this->_system->get_uid();

}


//---------------------------------------------------------
// init
//---------------------------------------------------------
function init()
{
	$this->_category_handler->load();
}

//---------------------------------------------------------
// update
//---------------------------------------------------------
function update_link_image_size($lid, $width, $height)
{
	$obj = $this->_link_handler->get($lid);
	if ( !is_object($obj) )  { return false; }

	$obj->setVar('width',  $width);
	$obj->setVar('height', $height);
	$ret = $this->_link_handler->update($obj);
	return $ret;
}

//---------------------------------------------------------
// category count
//---------------------------------------------------------


//---------------------------------------------------------
// link count
//---------------------------------------------------------
function get_link_count_public()
{
	$count = $this->_link_handler->get_count_public();
	return $count;
}

function get_link_count_by_cid($cid)
{
	$cid = intval($cid);
	$cid_arr   = $this->_category_handler->getAllChildId($cid);
	$cid_arr[] = $cid;
	$count = $this->_catlink_handler->get_count_by_cid_array($cid_arr);
	return $count;
}

//---------------------------------------------------------
// category_link count
//---------------------------------------------------------
function get_catlink_count_by_cid($cid)
{
	$count = $this->_catlink_handler->get_count_by_cid($cid);
	return $count;
}

//---------------------------------------------------------
// get category list
//---------------------------------------------------------
function get_cid_array_by_lid($lid, $limit=0, $start=0)
{
	$lid   = intval($lid);
	$limit = intval($limit);
	$start = intval($start);
	$arr   = $this->_catlink_handler->get_cid_array_by_lid($lid, $limit, $start);
	return $arr;
}

function show_cid_selbox_by_lid($lid=0, $limit=0, $start=0)
{
	$lid   = intval($lid);
	$limit = intval($limit);
	$start = intval($start);
	$cid_arr = array();

	if ($lid)
	{
		$cid_arr = $this->_catlink_handler->get_cid_array_by_lid($lid, $limit, $start);
	}

// show always, if cid array is empty
	$selbox = $this->_category_handler->showSelboxMulti($cid_arr);
	return $selbox;
}

//=========================================================
// category
//=========================================================
//---------------------------------------------------------
// get category
//---------------------------------------------------------
function get_category_by_cid($cid, $flag_image=0, $flag_catpath=0)
{
	$cid = intval($cid);

	$arr = $this->_category_handler->get_cache_var_all($cid, 'n');
	$title   = $arr['title'];
	$imgurl  = $arr['imgurl'];
	$title_s = $this->sanitize_text($title);

	$link_count = $this->get_link_count_by_cid($cid);
	$image_link = '';
	$catpath    = '';

// image
	if ($flag_image)
	{
		$image_link = $this->build_category_image_link($imgurl, $title);
	}

	if ($flag_catpath)
	{
		$catpath = $this->_category_handler->get_parent_path($cid);
	}

	$arr = array(
		'cid'        => $cid,
		'title'      => $title,
		'title_s'    => $title_s,
		'link_count' => $link_count,
		'image_link' => $image_link,
		'catpath'    => $catpath,
	);

	return $arr;
}

function build_category_image_link($url, $alt='')
{
	$image_link = '';

	if ( empty($url) || ($url == "http://") || ($url == "https://")  )
	{
		return '';
	}

	list($width, $height) = 
		$this->_remote_image->get_image_size($url);

	list($width, $height) = 
		$this->_image_size->adjust_size( $width, $height, $this->_conf_cat_img_width, $this->_conf_cat_img_height );

	$image_link = $this->_strings->build_html_image_link($url, $alt, $width, $height, 0);

	return $image_link;
}

//---------------------------------------------------------
// get category list
//---------------------------------------------------------
function get_category_list_by_pid($pid, $flag_image=0, $flag_catpath=0, $max_sub=-1)
{
	$pid = intval($pid);
	$cid_arr = $this->_category_handler->get_cid_array_by_pid($pid);

	$category_list = array();

	$flag_image   = 1;
	$flag_catpath = 0;

	foreach ($cid_arr as $cid)
	{
		$cat = $this->get_category_by_cid($cid, $flag_image, $flag_catpath);
		$title_s    = $cat['title_s'];
		$link_count = $cat['link_count'];
		$image_link = $cat['image_link'];

// by Tom
// admin can change the display number of subcategory 
		list ($space, $chcount, $subcategories) =
			$this->_category_handler->build_sub_categorys($cid, $max_sub);

		$category = array(
			'cid'            => $cid,
			'title_s'        => $title_s,
			'image_link'     => $image_link,
			'link_count'     => $link_count,
			'subcategories'  => $subcategories,
		);

		$category_list[] = $category;
	}

	return $category_list;
}

//---------------------------------------------------------
// category path
//---------------------------------------------------------
function &get_catpath_array_by_lid($lid)
{
	$cid_arr = $this->_catlink_handler->get_cid_array_by_lid($lid);
	$catpath_arr = array();

	foreach ($cid_arr as $cid)
	{
		if ( $this->_category_handler->cache_exists($cid) )
		{
			$catpath_arr[] =& $this->_category_handler->get_parent_path($cid);
		}
	}

	return $catpath_arr;
}

function get_all_catlist()
{
	$tree_array = $this->_category_handler->get_tree();

	$catlist = array();

	foreach ($tree_array as $cid) 
	{
		$catpath = $this->_category_handler->build_cat_path($cid);
		$count   = $this->get_link_count_by_cid($cid);

		$catlist[] = array(
			'cid'   => $cid,
			'count' => $count,
			'path'  => $this->sanitize_text($catpath),
		);
	}

	return $catlist;
}

//=========================================================
// link
//=========================================================
//---------------------------------------------------------
// get link object
//---------------------------------------------------------
function &get($lid)
{
	$ret =& $this->_link_handler->get($lid);
	return $ret;
}

function &getVarAll($lid, $format='n')
{
	$ret =& $this->_link_handler->getVarAll($lid, $format);
	return $ret;
}

//---------------------------------------------------------
// get link count
//---------------------------------------------------------
function get_count_by_mark( $mark )
{
	if ($mark == 'rss')
	{
		$count = $this->_link_handler->get_count_rss_flag();
	}
	else
	{
		$count = $this->_link_handler->get_count_by_mark($mark);
	}

	return $count;
}


//---------------------------------------------------------
// lid array
//---------------------------------------------------------
function &get_lid_array_by_cid($cid, $orderby, $limit=0, $start=0)
{
	$cid   = intval($cid);
	$limit = intval($limit);
	$start = intval($start);
	$arr    =& $this->_link_catlink_handler->get_lid_array_by_cid($cid, $orderby, $limit, $start);
	return $arr;
}

//---------------------------------------------------------
// build link show
//---------------------------------------------------------
function &build_link_show_by_lid($lid)
{
	$obj  = $this->_link_handler->get($lid);
	if ( !is_object($obj) )  { return false; }

	$show =& $this->build_link_show_by_obj($obj);

	$cid_arr  = $this->_catlink_handler->get_cid_array_by_lid($lid);
	$catpaths = $this->_category_handler->build_parent_path_multi($cid_arr);

	list($mail_subject, $mail_body) 
		= $this->_link_handler->build_link_mail($lid);

	$show['catpaths']     = $catpaths;
	$show['mail_subject'] = $mail_subject;
	$show['mail_body']    = $mail_body;

	return $show;
}

function &build_link_show_by_obj( &$obj )
{
	if ( !is_object($obj) )  { return array(); }

	$show = $obj->build_show();
	list($flag_new,  $flag_update, $flag_pop) = $this->build_flag_new_update_pop_by_obj( $obj );

	$show['flag_new']    = $flag_new;
	$show['flag_update'] = $flag_update;
	$show['flag_pop']    = $flag_pop;
	$show['flag_url']    = $this->build_flag_url_by_obj( $obj );

// dont show
	$show['name']        = '';
	$show['mail']        = '';
	$show['passwd']      = '';
	$show['search']      = '';
	$show['rss_xml']     = '';
	$show['usercomment'] = '';

	$description = $show['description'];
	$banner      = $show['banner'];
	$width       = $show['width'];
	$height      = $show['height'];
	$uid         = $show['uid'];

	list($image_url, $image_link_width, $image_link_height, $image_list_width, $image_list_height, $image_list_width_5)
		= $this->make_link_image($banner, $width, $height);

	$flag_admin = 0;
	if ( $this->_system_is_admin )
	{
		$flag_admin = 1;
	}

	$show['flag_admin'] = $flag_admin;
	$show['desc_short'] = $this->make_link_desc_short($description);

	$show['image_url']          = $image_url;
	$show['image_link_width']   = $image_link_width;
	$show['image_link_height']  = $image_link_height;
	$show['image_list_width']   = $image_list_width;
	$show['image_list_height']  = $image_list_height;
	$show['image_list_width_5'] = $image_list_width_5;

	$show['show_modify'] = $this->_config_handler->show_modify( $uid );

	return $show;
}

function build_flag_new_update_pop_by_obj( &$obj )
{
	$time_create = $obj->getVar('time_create', 'n');
	$time_update = $obj->getVar('time_update', 'n');
	$hits        = $obj->getVar('hits', 'n');

	$flag_new    = 0;
	$flag_update = 0;
	$flag_pop    = 0;

	if ( $this->_conf_newdays > 0 )
	{
		$startdate = time() - (86400 * $this->_conf_newdays);

		if ( $startdate < $time_create ) 
		{
			$flag_new = 1;
		}
		elseif ( $startdate < $time_update )
		{
			$flag_update = 1;
		}
	}

	if ( $this->_conf_popular > 0 )
	{
		if ( $hits >= $this->_conf_popular )
		{
			$flag_pop = 1;
		}
	}

	return array($flag_new, $flag_update, $flag_pop);
}

function build_flag_url_by_obj( &$obj )
{
// REQ 3196: direct link

	$url = $obj->getVar('url', 'n');
	$flag_url = 0;

	if ( $url && $this->_conf_view_url )
	{
		$flag_url = $this->_conf_view_url;
	}

	return $flag_url;
}

function make_link_desc_short($text)
{
// bug fix: display BB code in short description 
// rendering before shorten text

	$text = preg_replace("/[\n|\r]/",' ',$text);

	if (strlen($text) > $this->_conf_descshort )
	{
		$text = strip_tags($text);
		$text = $this->shorten_text($text, $this->_conf_descshort );
		$text = $this->sanitize_text($text);
	}

	return $text;
}

function make_link_image($banner, $width, $height)
{
	$image_url    = '';
	$link_width   = 0;
	$link_height  = 0;
	$list_width   = 0;
	$list_height  = 0;
	$list_width_5 = 0;

	$ret_false = array('',0,0,0,0,0);

	if ( empty($banner) )  return $ret_false;

	$image_url = $this->_link_utility->assume_banner_url($banner);

// read remote file, when not set
	if ($this->_conf_link_image_auto && empty($width) && empty($height))
	{
		list($width, $height) = $this->_link_utility->get_image_size($image_url);

		if ($width && $height)
		{
			$this->update_link_image_size($lid, $width, $height);
		}
	}

// size exist
	if ($width && $height)
	{
		list ($list_width, $list_height) = 
			$this->_image_size->adjust_size($width, $height, $this->_conf_list_image_width, $this->_conf_list_image_height);

		$list_width_5 = $list_width + 5;

		list ($link_width, $link_height) = 
			$this->_image_size->adjust_size($width, $height, $this->_conf_link_image_width, $this->_conf_link_image_height);
	}

	$image_url = $this->sanitize_url($image_url);

	return array($image_url, $link_width, $link_height, $list_width, $list_height, $list_width_5);
}

//---------------------------------------------------------
// build preview
//---------------------------------------------------------
function build_preview( &$post )
{

	$obj =& $this->_link_handler->create();

// desc option
	$obj->set_conf_desc_option( $this->_config_handler->has_auth_desc_option() );

// value
	$obj->assign_vars_post( $post );

// time
	$time = time();
	$obj->setVar('time_create', $time);
	$obj->setVar('time_update', $time);

// banner size
	$banner = $obj->getVar('banner', 'n');
	list($width, $height) = 
		$this->_link_utility->get_banner_size( $banner );
	$obj->setVar('width',  $width);
	$obj->setVar('height', $height);

// uid
	$obj->setVar('uid', $this->_system_uid);

// cid array
	$cid_arr = $obj->get_cid_array_by_post( $post );

	$show = $this->build_link_show_by_obj($obj);

	$catpaths = $this->_category_handler->build_parent_path_multi($cid_arr);
	$show['catpaths']     = $catpaths;

	$show['mail_subject'] = '';
	$show['mail_body']    = '';

	return $show;
}

//---------------------------------------------------------
// link list orderby xxx
// for index, topt ten
//---------------------------------------------------------
function &get_link_list_latest($limit=0, $start=0)
{

	$criteria = new weblinks_criteria_compo();
	$criteria->add( new weblinks_criteria('broken', $this->_conf_broken, '<') );
	$criteria->addSort('time_update', 'DESC');
	$criteria->addSort('lid',         'DESC');
	$criteria->setStart($start);
	$criteria->setLimit($limit);

	$list =& $this->get_link_list_criteria($criteria, $limit, $start);
	return $list;
}

function &get_link_list_sort_order($sort, $order, $limit=0, $start=0)
{
	$criteria = new weblinks_criteria_compo();
	$criteria->add( new weblinks_criteria('broken', $this->_conf_broken, '<') );
	$criteria->setSort($sort, $order);
	$criteria->setStart($start);
	$criteria->setLimit($limit);

	$list =& $this->get_link_list_criteria($criteria, $limit, $start);
	return $list;
}

function &get_link_list_criteria($criteria)
{
	$objs =& $this->_link_handler->getObjects($criteria);
	$list =& $this->get_link_list_by_objs($objs);
	return $list;
}

function &get_link_list_by_objs(&$objs)
{
	$link_list = array();

	if ( count($objs) > 0 )
	{
		foreach ($objs as $obj)
		{
			$show = $this->build_link_show_by_obj($obj);

// BUG: not show catpath in link list
			$lid = $obj->getVar('lid');
			$cid_arr  = $this->_catlink_handler->get_cid_array_by_lid($lid);
			$catpaths = $this->_category_handler->build_parent_path_multi($cid_arr);
			$show['catpaths'] = $catpaths;

			$link_list[] = $show;
		}
	}

	return $link_list;
}

//---------------------------------------------------------
// link list
// for serach
//---------------------------------------------------------
function &get_link_list_by_sql($sql, $limit=0, $start=0)
{
	$objs  =& $this->_link_handler->getObjectsBySql($sql, $limit, $start);
	$list  =& $this->get_link_list_by_objs($objs);
	return $list;
}

//---------------------------------------------------------
// view mark & rss : link list orderby xxx
//---------------------------------------------------------
function &get_link_by_mark_sort($mark, $sort, $limit=0, $start=0)
{
	if ($mark == 'rss')
	{
		$objs =& $this->_link_handler->get_objects_rss_by_sort($sort, $limit, $start);
	}
	else
	{
		$objs  =& $this->_link_handler->get_objects_by_mark_sort($mark, $sort, $limit, $start);
	}

	$list  =& $this->get_link_list_by_objs($objs);
	return $list;
}

//---------------------------------------------------------
// link list belongs category
//---------------------------------------------------------
function &get_link_list_by_cid_sort($cid, $sort, $limit=0, $start=0)
{
	$criteria =& new weblinks_criteria_compo();

	if ( $this->_conf_recommend_pri == 2 )
	{
		$criteria->addSort('recommend', 'DESC');
	}

	if ( $this->_conf_mutual_pri == 2 )
	{
		$criteria->addSort('mutual', 'DESC');
	}

	if ( isset($sort['sort']) && isset($sort['order']) )
	{
		$criteria->addSort($sort['sort'], $sort['order']);
	}
	else
	{
		$criteria->addSort('lid', 'ASC');
	}

	$criteria->setLimit($limit);
	$criteria->setStart($start);

	$lid_arr   =& $this->_link_catlink_handler->get_lid_array_by_cid_criteria($cid, $criteria);
	$link_list =& $this->get_link_list_by_lid_array($lid_arr);
	return $link_list;
}

function &get_link_all_child_list_latest_by_cid($cid, $limit=0, $start=0)
{
	$cid_arr   = $this->_category_handler->getAllChildId($cid);

	$criteria =& new weblinks_criteria_compo();
	$criteria->setSort('time_update', 'DESC');
	$criteria->setLimit($limit);
	$criteria->setStart($start);

	$lid_arr   = $this->_link_catlink_handler->get_lid_array_by_cid_array_criteria($cid_arr, $criteria);
	$link_list =& $this->get_link_list_by_lid_array($lid_arr);

	return $link_list;
}

function &get_link_list_by_lid_array($lid_arr)
{
	$link_list = array();

	foreach ($lid_arr as $lid) 
	{
		$show = $this->build_link_show_by_lid($lid);
		$link_list[] = $show;
	}

	return $link_list;
}

//---------------------------------------------------------
// Top Ten: link list belongs parent & child category
//---------------------------------------------------------
function &get_link_parent_child_list_by_cid_sort_order($cid, $sort, $order, $limit=0, $start=0)
{
	$ch_arr    =& $this->_category_handler->getAllChildId($cid);
	$chid_arr  =  array_merge( array($cid), $ch_arr );

	$criteria =& new weblinks_criteria_compo();
	$criteria->setSort($sort, $order);
	$criteria->setLimit($limit);
	$criteria->setStart($start);

	$lid_arr   =& $this->_link_catlink_handler->get_lid_array_by_cid_array_criteria($chid_arr, $criteria);
	$link_list =& $this->get_link_list_by_lid_array($lid_arr);

	return $link_list;
}

//---------------------------------------------------------
// search
//---------------------------------------------------------
function build_sql_search($queryarray, $andor='AND', $uid=0)
{
	$ret = $this->_link_handler->build_sql_search($queryarray, $andor, $uid);
	return $ret;
}

function getCountBySql($sql)
{
	$ret = $this->_link_handler->getCountBySql($sql);
	return $ret;
}

//=========================================================
// atomfeed
//=========================================================
function get_feed_count_all()
{
	$count = $this->_atomfeed_handler->getCount();
	return $count;
}

function &get_feed_list_latest($limit=0, $start=0)
{
	$objs =& $this->_atomfeed_handler->get_objects_latest($limit, $start);
	$list =& $this->build_feed_list_by_objs( $objs );
	return $list;
}

function &get_feed_list_latest_by_lid($lid, $limit=0, $start=0)
{
	$objs =& $this->_atomfeed_handler->get_objects_latest_by_lid($lid, $limit, $start);
	$list =& $this->build_feed_list_by_objs( $objs );
	return $list;
}

function &build_feed_list_by_objs( &$objs )
{
	$list = array();

	if ( count($objs) > 0 )
	{
		foreach ($objs as $obj) 
		{
			$list[] =& $this->build_feed_show_by_obj( $obj );
		}
	}

	return $list;
}

function &build_feed_show_by_obj( &$obj )
{
	if ( !is_object($obj) )  { return array(); }

	$arr =& $obj->getVarAll('s');
	$arr['title']   = $obj->title_disp(   $this->_feed_mode_title,   $this->_feed_title_default );
	$arr['content'] = $obj->content_disp( $this->_feed_mode_content, $this->_feed_max_content );
	$arr['summary'] = $obj->summary_disp( $this->_feed_max_summary );
	$arr['date']    = $obj->time_modified_disp();
	return $arr;
}


//=========================================================
// others
//=========================================================

//---------------------------------------------------------
// sanitize
//---------------------------------------------------------
function sanitize_text($text)
{
	$text = $this->_strings->sanitize_html_text($text);
	return $text;
}

function sanitize_url($text)
{
	$text = $this->_strings->sanitize_html_url($text);
	return $text;
}

function shorten_text($text, $max)
{
	$text = $this->_strings->shorten_text($text, $max);
	return $text;
}

//---------------------------------------------------------
// get GET & POST
//---------------------------------------------------------
function get_get_lid()
{
	$ret = $this->_post->get_get_int('lid');
	return $ret;
}

function get_get_cid()
{
	$ret = $this->_post->get_get_int('cid');
	return $ret;
}

function get_get_mark()
{
	$ret = $this->_post->get_get_text('mark');
	return $ret;
}

//---------------------------------------------------------
// get property
//---------------------------------------------------------
function is_admin()
{
	return $this->_system_is_admin;
}

function get_config()
{
	return $this->_conf_array;
}

//---------------------------------------------------------
// set property
//---------------------------------------------------------
function set_feed_mode_title($value)
{
	$this->_feed_mode_title = intval($value);
}

function set_feed_mode_content($value)
{
	$this->_feed_mode_content = intval($value);
}

function set_feed_max_content($value)
{
	$this->_feed_max_content = intval($value);
}

function set_feed_max_summary($value)
{
	$this->_feed_max_summary = intval($value);
}

function set_feed_title_default($value)
{
	$this->_feed_title_default = $value;
}

// --- class end ---
}

// === class end ===
}

?>