<?php
// $Id: weblinks_link_catlink_handler.php,v 1.1 2006/05/24 01:23:56 ohwada Exp $

// 2006-05-15 K.OHWADA
// this is new file
// use new handler

//=========================================================
// WebLinks Module
// 2006-05-15 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_link_catlink_handler') ) 
{

//=========================================================
// class weblinks_link_catlink_handler
// handling for table_link & table_catlink
//=========================================================
class weblinks_link_catlink_handler extends weblinks_object_handler
{
	var $_table_link;
	var $_table_catlink;

// config
	var $_conf_broken;
//	var $_conf_recommend_pri;
//	var $_conf_mutual_pri;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link_catlink_handler( $dirname )
{
	$this->weblinks_object_handler($dirname, 'link_catlink', 'lid' );

	$this->set_debug_sql(   WEBLINKS_DEBUG_LINK_CATLINK_SQL );
	$this->set_debug_error( WEBLINKS_DEBUG_ERROR );

	$this->_table_link     = $this->prefix( 'link',    $dirname );
	$this->_table_catlink  = $this->prefix( 'catlink', $dirname );

	$config_basic_handler =& weblinks_get_handler( 'config2_basic', $dirname );

	$conf = $config_basic_handler->get_cached();
	$this->_conf_broken        = $conf['broken_threshold'];
//	$this->_conf_recommend_pri = $conf['recommend_pri'];
//	$this->_conf_mutual_pri    = $conf['mutual_pri'];

}

//---------------------------------------------------------
// db handling
//---------------------------------------------------------
function &get_lid_array_by_cid_criteria($cid, $criteria=null)
{
//	$orderby = '';
//	if ( $this->_conf_recommend_pri == 2 )
//	{
//		$orderby .= 'l.recommend DESC, ';
//	}
//	if ( $this->_conf_mutual_pri == 2 )
//	{
//		$orderby .= 'l.mutual DESC, ';
//	}
//	if ( isset($sort['sort']) && isset($sort['order']) )
//	{
//		$orderby .= 'l.'.$sort['sort'].' '.$sort['order'];
//	}
//	else
//	{
//		$orderby .= 'l.lid ASC;
//	}

	$orderby = 'l.lid ASC';
	$limit   = 0;
	$start   = 0;

	if (($criteria !== null) && is_a($criteria, $this->ceClass)) 
	{
		$orderby = $this->_get_orderby_by_criteria($criteria);
		$limit   = $criteria->getLimit();
		$start   = $criteria->getStart();
	}

	$sql  = 'SELECT DISTINCT l.lid FROM ';
	$sql .= $this->_table_link.' l, ';
	$sql .= $this->_table_catlink.' c ';
	$sql .= ' WHERE ( ';
	$sql .= 'c.cid='.intval($cid);
	$sql .= ' AND .';
	$sql .= 'l.broken < '.intval($this->_conf_broken);
	$sql .= ' AND l.lid=c.lid ) ';
	$sql .= ' ORDER BY '.$orderby;

	$ret =& $this->getFirstRowsBySql($sql, $limit, $start);
	return $ret;
}

function &get_lid_array_by_cid_array_criteria($cid_arr, $criteria=null)
{
	$orderby = 'l.lid ASC';
	$limit   = 0;
	$start   = 0;

	if (($criteria !== null) && is_a($criteria, $this->ceClass)) 
	{
		$orderby = $this->_get_orderby_by_criteria($criteria);
		$limit   = $criteria->getLimit();
		$start   = $criteria->getStart();
	}

	$ret = array();

	$count = count($cid_arr);
	if ($count == 0 )  { return $ret; }

	$where = ' ( c.cid='.$cid_arr[0].' ';

	for ($i=1; $i<$count; $i++)
	{
		$where .= ' OR c.cid='.$cid_arr[$i].' ';
	}

	$where .= ' ) ';

	$sql  = 'SELECT DISTINCT l.lid FROM ';
	$sql .= $this->_table_link.' l, ';
	$sql .= $this->_table_catlink.' c ';
	$sql .= ' WHERE ( '.$where;
	$sql .= ' AND l.broken < '.intval($this->_conf_broken);
	$sql .= ' AND l.lid=c.lid ) ';
	$sql .= ' ORDER BY '.$orderby;

	$ret =& $this->getFirstRowsBySql($sql, $limit, $start);
	return $ret;
}

function _get_orderby_by_criteria( &$criteria )
{
	$orderby = '';

	foreach ($criteria->getsorts() as $sort)
	{
		if ($orderby)
		{
			$orderby .= ', ';
		}

		$orderby .= 'l.'.$sort['sort'].' '.$sort['order'];
	}

	return $orderby;
}

// --- class end ---
}

// === class end ===
}

?>