<?php
// $Id: weblinks_form.php,v 1.1 2006/05/24 01:23:56 ohwada Exp $

// 2006-05-15 K.OHWADA
// this is new file

//================================================================
// WebLinks Module
// portint from RSSC
// 2006-05-15 K.OHWADA
//================================================================

// === class begin ===
if( !class_exists('weblinks_form') ) 
{

//=========================================================
// class weblinks_form
//=========================================================
class weblinks_form
{
// class instance
	var $_strings;

// constant
	var $SUBMIT_VALUE = _GO;

// variable
	var $_form_title  = 'Config Setting';
	var $_form_name   = 'weblinks';
	var $_token_name  = 'weblinks';
	var $_op_name     = 'op';
	var $_submit_name = 'submit';
	var $_method      = 'post';

	var $_size      =  50;
	var $_maxlength = 255;
	var $_rows      =   5;
	var $_cols      =  50;

	var $_datas = array();

	var $_table_title_class = 'head';
	var $_table_ele_class   = 'odd';

	var $_font_caption_title = "<span style='font-weight:bold;'>";
	var $_font_caption_desc  = "<span style='font-weight:normal;'>";
	var $_font_caption_title_end = "</span>";
	var $_font_caption_desc_end  = "</span>";

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_form()
{
// class instance
	$this->_strings =& weblinks_strings::getInstance();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_form();
	}

	return $instance;
}

//---------------------------------------------------------
// make table form
//---------------------------------------------------------
function make_table_start()
{
	return "<table width='100%' class='outer' cellspacing='1'>\n";
}

function make_table_title($title='', $class='', $align='')
{
	if ( empty($title))
	{
		$title = $this->_form_title;
	}

	$text  = "<tr valign='top' align='left'>";
	$text .= $this->make_table_col_head($title, $class, '', 2);
	$text .= "</tr>\n";
	return $text;
}

function make_table_end()
{
	return "</table>\n";
}

function make_table_line($title='', $ele='', $title_class='head', $ele_class='odd')
{
	$text  = "<tr valign='top' align='left'>";
	$text .= $this->make_table_col($title, $title_class);
	$text .= $this->make_table_col($ele,   $ele_class);
	$text .= "</tr>\n";
	return $text;
}

function make_table_line_col($value, $class='head', $align='', $colspan=2)
{
	$text  = "<tr valign='top' align='left'>";
	$text .= "<td ";
	$text .= $this->make_table_col_begin_common($class, $align, $colspan);
	$text .= ">";
	$text .= $value;
	$text .= "</td>";
	$text .= "</tr>\n";
	return $text;
}

function make_table_col($value, $class='', $align='', $colspan=0)
{
	if ( $value == '' )
	{
		 $value = '&nbsp';
	}

	$td  = "<td ";
	$td .= $this->make_table_col_begin_common($class, $align, $colspan);
	$td .= ">";
	$td .= $value;
	$td .= "</td>";
	return $td;
}

function make_table_col_head($value, $class='', $align='',$colspan=0)
{
	if ( empty($value) )
	{
		 $value = '&nbsp';
	}

	$td  = "<th ";
	$td .= $this->make_table_col_begin_common($class, $align, $colspan);
	$td .= ">";
	$td .= $value;
	$td .= "</th>";
	return $td;
}

function make_table_col_begin_common($class='', $align='', $colspan=0)
{
	$td = "";

	if ($align)
	{
		$td .= "align='".$align."' ";
	}

	if ($class)
	{
		$td .= "class='".$class."' ";
	}

	if ($colspan)
	{
		$td .= "colspan='".$colspan."' ";
	}

	return $td;
}

//---------------------------------------------------------
// make table form
//---------------------------------------------------------
function make_table_form_text($cap, $name, $value, $size=50, $maxlength=255)
{
	$text = $this->make_form_text($name, $value, $size, $maxlength);
	$text = $this->make_table_line($cap, $text, $this->_table_title_class, $this->_table_ele_class);
	return $text;
}

function make_table_form_radio_select($cap, $name, $value, $options, $del='')
{
	$text = $this->make_form_radio_select($name, $value, $options, $del='');
	$text = $this->make_table_line($cap, $text, $this->_table_title_class, $this->_table_ele_class);
	return $text;
}

function make_table_form_submit($cap, $name, $value)
{
	$text = $this->make_form_submit($name, $value);
	$text = $this->make_table_line($cap, $text, $this->_table_title_class, $this->_table_title_class);
	return $text;	
}

//---------------------------------------------------------
// make form box
//---------------------------------------------------------
function make_form_box($action='', $hidden_value='save', $submit_value='save')
{
	$text  = '';
	$text .= $this->make_form_start($this->_form_name, $action, $this->_method);
	$text .= $this->make_form_token($this->_token_name);
	$text .= $this->make_form_hidden($this->_op_name, $hidden_value);
	$text .= $this->make_form_submit($this->_submit_name, $submit_value);
	$text .= $this->make_form_end();
	return $text;
}

function make_form_box_option( $action, $submit_value, $options=array() )
{
	$text  = '';
	$text .= $this->make_form_start($this->_form_name, $action, $this->_method);
	$text .= $this->make_form_token($this->_token_name);

	foreach ($options as $k => $v)
	{
		$text .= $this->make_form_hidden($k, $v);
	}

	$text .= $this->make_form_submit($this->_submit_name, $submit_value);
	$text .= $this->make_form_end();
	return $text;
}

//---------------------------------------------------------
// make form
//---------------------------------------------------------
function make_form_start($name='', $action='', $method='post', $target='')
{
	if ( empty($name) )
	{
		$name = $this->_form_name;
	}

// restore form name
	$this->_form_name = $name;

	if ( empty($action) )
	{
		$action = xoops_getenv('PHP_SELF');
	}

// sanitize
	$action = $this->sanitize_html_url($action);

	$text = "<form name='$name' id='$name' action='$action' method='$method'";

	if ( $target )
	{
		$text .= " target='$target'";
	}

	$text .= " >\n";

	return $text;
}

function make_form_end()
{
	return "</form>\n";
}

function make_form_radio_select($name, $value, $options, $del='')
{
	$text = '';

	foreach ($options as $opt_name => $opt_val)
	{
		$checked       = $this->make_checked($value, $opt_val);
		$opt_val_show  = $this->sanitize_html_text($opt_val);
		$opt_name_show = $this->sanitize_html_text($opt_name);
		$text .= $this->make_form_radio($name, $opt_val_show, $checked);
		$text .= " $opt_name_show ";
		$text .= $del;
	}

	return $text;
}

function make_form_checkbox_select($name, $value, $options, $del='')
{
	$text = '';

	foreach ($options as $opt_name => $opt_val)
	{
		$checked       = $this->make_checked($value, $opt_val);
		$opt_val_show  = $this->sanitize_html_text($opt_val);
		$opt_name_show = $this->sanitize_html_text($opt_name);
		$text .= $this->make_form_checkbox($name, $opt_val_show, $checked);
		$text .= " $opt_name_show ";
		$text .= $del;
	}

	return $text;
}

function make_form_select($name, $value, $opt_arr, $none=0, $none_name='---', $none_value='')
{
	$text = "<select name='$name'>\n";

	if ($none)
	{
		$text .=  $this->make_form_option($none_name, $none_value);
	}

	foreach ($opt_arr as $opt_name => $opt_val)
	{
		$text .= $this->make_form_option_selected( $opt_name, $opt_val, array($value) );
	}

	$text .= "</select>\n";
	return $text;
}

function make_form_select_multiple($name, $value_arr, $opt_arr, $size=4, $none=0, $none_name='---', $none_value='')
{
	$text = "<select name='".$name."[]' size='".$size."' multiple>\n";

	if ($none)
	{
		$text .= $this->make_form_option($none_name, $none_value);
	}

	foreach ($opt_arr as $opt_name => $opt_val)
	{
		$text .= $this->make_form_option_selected( $opt_name, $opt_val, $value_arr );
	}

	$text .= "</select>\n";
	return $text;
}

function make_form_option_selected($opt_name, $opt_val, $value_arr)
{
	$flag = 0;

	foreach ($value_arr as $value)
	{
		if ($value == $opt_val)
		{
			$flag = 1;
			break;
		}
	}

	$text = $this->make_form_option($opt_name, $opt_val, $flag);

	return $text;
}

function make_form_option($name, $value, $flag_selected=0)
{
	$selected = '';

	if ($flag_selected)
	{
		$selected = "selected='selected'";
	}

	return "<option value='$value' $selected >$name</option>\n";
}

function make_form_text($name, $value, $size=50, $maxlength=255, $extra='')
{
	return "<input type='text' name='$name' id='$name' value='$value' size='$size' maxlength='$maxlength' $extra />\n";
}

function make_form_password($name, $value, $size=50, $maxlength=255, $extra='')
{
	return "<input type='password' name='$name' id='name' value='$value' size='$size' maxlength='$maxlength' $extra />\n";
}

function make_form_textarea($name, $value, $rows=5, $cols=50)
{
	$text  = "<textarea name='$name' id='$name' rows='$rows' cols='$cols' >\n";
	$text .= $value;
	$text .= "</textarea>\n";
	return $text;
}

function make_form_radio($name, $value, $checked='', $extra='')
{
	return "<input type='radio' name='$name' id='$name' value='$value' $checked $extra />\n";
}

function make_form_checkbox($name, $value, $checked='', $extra='')
{
	return "<input type='checkbox' name='$name' id='$name' value='$value' $checked $extra />\n";
}

function make_form_hidden($name, $value)
{
	return "<input type='hidden' name='$name' value='$value' />\n";
}

function make_form_submit($name, $value)
{
	return "<input type='submit' name='$name' value='$value' />\n";
}

function make_form_button($name, $value, $extra='')
{
	return "<input type='button' name='$name' value='$value' $extra />\n";
}

function make_form_cancel_button($name, $value)
{
	$extra = " onclick=\"javascript:history.go(-1)\" ";
	$text  = $this->make_form_button($name, $value, $extra);
	return $text;
}

function make_checked($val1, $val2)
{
	if ( isset($val1) && ( $val1 == $val2 ) )
	{
		return 'checked';
	}

	return '';
}

//---------------------------------------------------------
// complex form
//---------------------------------------------------------
function make_form_radio_yesno($name, $value)
{
	$options = array( _YES => 1, _NO => 0 );
	$text    = $this->make_form_radio_select($name, $value, $options);
	return $text;
}

function make_form_checkbox_yesno($name, $value)
{
// check, if yes
	$checked = $this->make_checked($value, 1);
	$text    = $this->make_form_checkbox($name, 1, $checked);
	return $text;
}

//---------------------------------------------------------
// XOOPS JavaScript
//---------------------------------------------------------
function make_js_checkall()
{
	$form_name = $this->_form_name;
	$checkall  = $this->_form_name."_checkall";
	$extra = "onclick='xoopsCheckAll(\"" .$form_name. "\", \"" .$checkall. "\")' ";
	$text  = $this->make_form_checkbox($checkall, '', '', $extra);
	return $text;
}

function make_js_checkbox($value)
{
	$name = $this->_form_name."_id[]";
	$text = $this->make_form_checkbox($name, $value);
	return $text;
}

//---------------------------------------------------------
// make data form
//---------------------------------------------------------
function make_data_table_label_hidden($caption, $key)
{
	$value  = $this->get_data_value($key);
	$ele  = $value.' ';
	$ele .= $this->make_form_hidden($key, $value);
	$text =  $this->make_table_line($caption, $ele);
	return $text;
}

function make_data_table_label($caption, $key)
{
	$ele  = $this->get_data_value($key);
	$text = $this->make_table_line($caption, $ele);
	return $text;
}

function make_data_table_text($caption, $key)
{
	$ele  = $this->make_data_text($key);
	$text = $this->make_table_line($caption, $ele);
	return $text;
}

function make_data_table_textarea($caption, $key)
{
	$ele = $this->make_data_textarea($key);
	return $this->make_table_line($caption, $ele );
	return $text;
}

function make_data_table_radio_yesno($caption, $key)
{
	$ele  = $this->make_data_radio_yesno($key);
	$text = $this->make_table_line($caption, $ele );
	return $text;
}

function make_data_text($key)
{
	$value = $this->get_data_value($key);
	$text  = $this->make_form_text($key, $value, $this->_size, $this->_maxlength);
	return $text;
}

function make_data_textarea($key)
{
	$value = $this->get_data_value($key);
	$text  = $this->make_form_textarea($key, $value, $this->_rows, $this->_cols);
	return $text;
}

function make_data_radio_yesno($key)
{
	$value = $this->get_data_value($key);
	$text  = $this->make_form_radio_yesno($key, $value, $this->_rows, $this->_cols);
	return $text;
}

function get_data_value($key)
{
	if ( isset($this->_datas[$key]) )
	{
		$val = $this->_datas[$key];
		return $val;
	}

	return '';
}

//---------------------------------------------------------
// make XOOPS html
//---------------------------------------------------------
function make_xoops_img_email_logo($width=0, $height=0, $border=0, $alt='email')
{
	$url  = XOOPS_URL.'/images/icons/email.gif';
	$text = $this->make_html_img($url, $width, $height, $border, $alt);
	return $text;
}

function make_xoops_img_www_logo($width=0, $height=0, $border=0, $alt='www')
{
	$url  = XOOPS_URL.'/images/icons/www.gif';
	$text = $this->make_html_img($url, $width, $height, $border, $alt);
	return $text;
}

function make_xoops_img_pm_logo($width=0, $height=0, $border=0, $alt='pm')
{
	$url  = XOOPS_URL.'/images/icons/pm.gif';
	$text = $this->make_html_img($url, $width, $height, $border, $alt);
	return $text;
}

function make_xoops_mailto_with_logo($email, $target='')
{
	if ( empty($email) )  return '';

	$img  = $this->make_xoops_img_email_logo();
	$text = $this->make_html_mailto_link($email, $img, $target, false);
	return $text;
}

function make_xoops_url_with_logo($url, $target='_blank')
{
	if ( empty($url) )  return '';

	$img  = $this->make_xoops_img_www_logo();
	$text = $this->make_html_url_link($url, $img, $target, false);
	return $text;
}

function make_xoops_pm_with_logo($uid)
{
	$uid = intval($uid);
	if ($uid < 1)  return '';

	$url_pm = XOOPS.'/pmlite.php?send2=1&amp;to_userid='.$uid;
	$url    = $this->make_xoops_openWithSelfMain($url_pm, "pmlite", 450, 370);
	$link   = "<a href='$url'>";

	return $link;
}

function make_xoops_url_userinfo($uid, $uname)
{
	$uid = intval($uid);
	if ($uid < 1)  return '';

	$userinfo_url = XOOPS_URL."/userinfo.php?uid=".$uid;
	$submitter = $this->make_html_url_link($userinfo_url, $uname);
	return $submitter;
}

function make_xoops_openWithSelfMain($url, $name, $width=450, $height=400)
{
	$text = "javascript:openWithSelfMain('$url', '$name', $width, $height)";
	return $text;
}

//---------------------------------------------------------
// utility
//---------------------------------------------------------
function make_caption($title, $desc='')
{
	$text = '';

	if ( $title)
	{
		if ($this->_font_caption_title)
		{
			$text .= $this->_font_caption_title . $title . $this->_font_caption_title_end;
		}
		else
		{
			$text .= $title;
		}

	}
	
	if ( $desc )
	{
		if ( $title)
		{
			$text .= "<br /><br />\n";
		}

		if ($this->_font_caption_desc)
		{
			$text .= $this->_font_caption_desc . $desc. $this->_font_caption_desc_end;
		}
		else
		{
			$text .= $desc;
		}
	}

	return $text;
}

//---------------------------------------------------------
// use strings class
//---------------------------------------------------------
function make_html_mailto_link($email, $name='', $target='', $flag_name_sanitize=true )
{
	$str = $this->_strings->build_html_link_email($email, $name, $target, $flag_name_sanitize );
	return $str;
}

function make_html_url_link($url, $name='', $target='', $flag_name_sanitize=true )
{
	$str = $this->_strings->build_html_link_name($url, $name, $target, $flag_name_sanitize);
	return $str;
}

function make_html_img($url, $width=0, $height=0, $border=0, $alt='image')
{
	$str = $this->_strings->build_html_image_link($url, $alt, $width, $height, $border);
	return $str;
}

function highlight($text, $color='#ff0000', $weight='bold')
{
	$str = $this->_strings->highlight($text, $color, $weight);
	return $str;
}

function sanitize_html_text($text)
{
	$str = $this->_strings->sanitize_html_text($text);
	return $str;
}

function sanitize_html_url($text)
{
	$str = $this->_strings->sanitize_html_url($text);
	return $str;
}

//=========================================================
// XoopsMultiTokenHandler
//=========================================================
function make_form_token( $name='' )
{
	if ( class_exists('XoopsMultiTokenHandler') )
	{
		list($token_name, $token_value) = $this->make_token( $name );
		$text = $this->make_form_hidden($token_name, $token_value);
		return $text;
	}

	return '';
}

function make_token( $name='' )
{
	if ( class_exists('XoopsMultiTokenHandler') )
	{
		if ( empty($name) )
		{
			$name = $this->_token_name;
		}

		$token =& XoopsMultiTokenHandler::quickCreate( $name );
		$token_name  = $token->getTokenName();
		$token_value = $token->getTokenValue();
	}
	else
	{
		$token_name  = 'token';
		$token_value = 0;
	}

	return array($token_name, $token_value);
}

function check_token(  $name='' )
{
	if ( class_exists('XoopsMultiTokenHandler') )
	{
		if ( empty($name) )
		{
			$name = $this->_token_name;
		}

		$ret = XoopsMultiTokenHandler::quickValidate( $name );
		return $ret;
	}

// always true, if not exists class
	return true;
}

//---------------------------------------------------------
// set parameter
//---------------------------------------------------------
function set_submit_value($value)
{
	$this->SUBMIT_VALUE = $value;
}

function set_form_title($value)
{
	$this->_form_title = $value;
}

function set_form_name($value)
{
	$this->_form_name = $value;
}

function set_token_name($value)
{
	$this->_token_name = $value;
}

function set_op_name($value)
{
	$this->_op_name = $value;
}

function set_submit_name($value)
{
	$this->_submit_name = $value;
}

function set_method($value)
{
	$this->_method = $value;
}

function set_size($value)
{
	$this->_size = intval($value);
}

function set_maxlength($value)
{
	$this->_maxlength = intval($value);
}

function set_rows($value)
{
	$this->_rows = intval($value);
}

function set_cols($value)
{
	$this->_text_cols = intval($value);
}

function set_datas($value)
{
	$this->_datas = $value;
}

//---------------------------------------------------------
// get parameter
//---------------------------------------------------------
function get_form_name()
{
	return $this->_form_name;
}

// --- class end ---
}

// === class end ===
}

?>