<?php
// $Id: weblinks_error.php,v 1.1 2006/05/24 01:23:56 ohwada Exp $

// 2006-05-15 K.OHWADA
// this is new file

//=========================================================
// WebLinks Module
// porting from RSSC
// 2006-05-15 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_error') ) 
{

//=========================================================
// class weblinks_error
//=========================================================
class weblinks_error
{

// log & error
	var $_logs   = array();
	var $_errors = array();
	var $_error_code = 0;
	var $_error_flag = false;	// no error

// debug
	var $_flag_debug_print_log   = 0;
	var $_flag_debug_print_error = 0;


//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_error()
{
	// dummy
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_error();
	}

	return $instance;
}

//=========================================================
// Public
//=========================================================
function &getLogs($format='n')
{
	$ret = '';

	if ($format == 'n') 
	{
		return $this->_logs;
	}

	if (count($this->_logs) == 0)
	{
		return $ret;
	} 

	foreach ($this->_logs as $log) 
	{
		$ret .= $log.'<br />';
	}

	return $ret;
}

function &getErrors($format='n')
{
	$ret = '';

	if ($format == 'n') 
	{
		return $this->_errors;
	}

	if (count($this->_errors) == 0)
	{
		return $ret;
	} 

	foreach ($this->_errors as $error) 
	{
		$ret .= $error.'<br />';
	}

	return $ret;
}

function getErrorCode()
{
	return $this->_error_code;
}

function returnExistError()
{
	if ( $this->_error_flag )
	{
		return false;
	}

	return true;
}

function set_debug_print_log($value)
{
	$this->_flag_debug_print_log = intval($value);
}

function set_debug_print_error($value)
{
	$this->_flag_debug_print_error = intval($value);
}

//=========================================================
// Private
//=========================================================
function _clear_errors()
{
	$this->_errors     = array();
	$this->_error_flag = false;	// no error
}

function _set_log_func_name($text)
{
	$this->_set_log( 'function: '.$text );
}

function _set_log($text_arr)
{
	if ( is_array($text_arr) )
	{
		foreach ($text_arr as $text)
		{
			$this->_logs[] = $text;

			if ($this->_flag_debug_print_log)
			{
				$this->_print_line($text);
			}
		}
	}
	else
	{
		$this->_logs[] = $text_arr;

		if ($this->_flag_debug_print_log)
		{
			$this->_print_line($text_arr);
		}
	}
}

function _set_errors($text_arr)
{
	if ( is_array($text_arr) )
	{
		foreach ($text_arr as $text)
		{
			$this->_errors[] = $text;

			if ($this->_flag_debug_print_error)
			{
				$this->_print_error($text);
			}
		}
	}
	else
	{
		$this->_errors[] = $text_arr;

		if ($this->_flag_debug_print_error)
		{
			$this->_print_error($text_arr);
		}
	}

	$this->_error_flag = true;	// error
}

function _set_error_code($code)
{
	$this->_error_code = $code;
}

function _print_line($text)
{
	echo htmlSpecialChars($text, ENT_QUOTES);
	echo "<br />\n";
}

function _print_error($text)
{
	echo "<span style='color: #ff0000; '>";
	echo htmlSpecialChars($text, ENT_QUOTES);
	echo "</span>";
	echo "<br />\n";
}

// --- class end ---
}

// === class end ===
}

?>