<?php
// $Id: weblinks_db_basic_base.php,v 1.1 2006/05/24 01:23:56 ohwada Exp $

// 2006-05-15 K.OHWADA
// this is new file
// use new handler

//=========================================================
// WebLinks Module
// 2006-05-15 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_db_basic_base') ) 
{

//=========================================================
// class weblinks_db_basic_base
// this class is used by command line
// this class handle MySQL table directly
// this class does not use another class
//=========================================================
class weblinks_db_basic_base
{
// class instance
	var $_db;

// variable
	var $_dirname;
	var $_table;

// debug
	var $_flag_debug_print_sql   = 0;
	var $_flag_debug_print_error = 0;
	var $_debug_max_sql = 1000;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_db_basic_base( $dirname, $table )
{

// class instance
	$this->_db =& Database::getInstance();

	$this->_dirname = $dirname;
	$this->_table   = $this->build_table_name( $table );
}

function build_table_name( $table )
{
	$table = $this->_db->prefix( $this->_dirname.'_'.$table );
	return $table;
}

//---------------------------------------------------------
// execute sql
//---------------------------------------------------------
function &get_row_by_sql($sql)
{
	$res =& $this->_query($sql);
	$arr = $this->_db->fetchArray( $res );
	return $arr;
}

function &get_rows_by_sql($sql)
{
	$res =& $this->_db->query($sql);
	if ( !$res )
	{	return $res;	}

	$i = 0;
	$rec = array();

	while ( $row = $this->_db->fetchArray($res) ) 
	{
		$rec[$i++] = $row;
	}

	$this->_db->freeRecordSet($res);

	return $rec;
}

function &get_first_row_by_sql($sql, $limit=0, $offset=0)
{
	$res =& $this->_query($sql, $limit, $offset);
	if ( !$res )
	{	return $res;	}

	$i = 0;
	$rec = array();

	while ( $row = $this->_db->fetchRow($res) ) 
	{
		$rec[$i++] = $row[0];
	}

	$this->_db->freeRecordSet($res);

	return $rec;
}

function get_count_by_sql($sql)
{
	$res =& $this->_query($sql);
	if ( !$res )
	{
		return 0;
	}

	$array = $this->_db->fetchRow( $res );
	$count = intval( $array[0] );

	if ( empty($count) )
	{
		$count = 0;
	}

	$this->_db->freeRecordSet($res);

	return $count;
}

function &_query($sql, $limit=0, $offset=0)
{
	$res =& $this->_db->queryF($sql, $limit, $offset);

	$this->_print_sql($sql);

	if ( !$res ) 
	{
		$this->_set_db_error($sql);
		return false;
	}

	return $res;
}

function _quote($str)
{
	$text = $this->_db->quoteString($str);
	return $text;
}

//---------------------------------------------------------
// error
//---------------------------------------------------------
function _set_db_error($sql='')
{
	$err1 = $this->_db->error();
	$this->_set_errors( $err1 );

	if ($sql)
	{
		$err2 = $this->_shorten_text($sql, $this->_debug_max_sql);
		$this->_set_errors( $err2 );
	}
}

function _print_sql($sql)
{
	if ( !$this->_flag_debug_print_sql )  return;
	if ( empty($sql) )  return;

	$sql = $this->_shorten_text($sql, $this->_debug_max_sql);

	$this->_print_line("sql: $sql");
}

function _set_errors($text_arr)
{
	if ( is_array($text_arr) )
	{
		foreach ($text_arr as $text)
		{
			if ($this->_flag_debug_print_error)
			{
				$this->_print_error($text);
			}
		}
	}
	else
	{
		if ($this->_flag_debug_print_error)
		{
			$this->_print_error($text_arr);
		}
	}
}

function _print_line($text)
{
	echo htmlSpecialChars($text, ENT_QUOTES);
	echo "<br />\n";
}

function _print_error($text)
{
	echo "<span style='color: #ff0000; '>";
	echo htmlSpecialChars($text, ENT_QUOTES);
	echo "</span>";
	echo "<br />\n";
}

//---------------------------------------------------------
// multi byte
//---------------------------------------------------------
function _shorten_text($text, $max=100)
{
	if ( strlen($text) > $max)
	{
		if (function_exists('mb_strcut'))
		{
			$text = mb_strcut( $text, 0, $max )." ...";
		}
		else
		{
			$text = substr( $text, 0, $max )." ...";
		}
	} 

	return $text;
}

//---------------------------------------------------------
// set parameter
//---------------------------------------------------------
function set_debug_sql($val)
{
	$this->_flag_debug_print_sql = intval($val);
}

function set_debug_error($val)
{
	$this->_flag_debug_print_error = intval($val);
}

function set_debug_max_sql($val)
{
	$this->_debug_max_sql = intval($val);
}

// --- class end ---
}

// === class end ===
}

?>