<?php
// $Id: weblinks_config_check_handler.php,v 1.1 2006/05/24 01:23:56 ohwada Exp $

// 2006-05-15 K.OHWADA
// this is new file
// use new handler

//================================================================
// WebLinks Module
// this file contain 2 class
//   weblinks_config_check_handler
//   weblinks_config_check_form
// 2006-05-15 K.OHWADA
//================================================================

// === class begin ===
if( !class_exists('weblinks_config_check_handler') ) 
{

//================================================================
// class weblinks_config_check
//================================================================
class weblinks_config_check_handler extends weblinks_error
{

// handler
	var $_link_handler;
	var $_modify_handler;
	var $_config_store_handler;
	var $_linkitem_store_handler;

	var $_config_form;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_config_check_handler( $dirname )
{
	$this->weblinks_error();

// handler
	$this->_link_handler           =& weblinks_get_handler('link',           $dirname );
	$this->_modify_handler         =& weblinks_get_handler('modify',         $dirname );
	$this->_config_store_handler   =& weblinks_get_handler('config2_store',  $dirname );
	$this->_linkitem_store_handler =& weblinks_get_handler('linkitem_store', $dirname );

	$this->_config_form = weblinks_config_check_form::getInstance();

}

//---------------------------------------------------------
// init config
//---------------------------------------------------------
function exist_config()
{
	if ( !$this->_exists_config_table() )
	{	return false;	}

	if ( !$this->_check_init_config() )
	{	return false;	}

	if ( !$this->_exists_linkitem_table() )
	{	return false;	}

	if ( !$this->_check_init_linkitem() )
	{	return false;	}

	return true;
}

function init_config()
{
	$this->_clear_errors();

	if ( !$this->_exists_config_table() )
	{
		$ret = $this->_config_store_handler->create_table();
		if ( !$ret )
		{
			$this->_set_errors( $this->_config_store_handler->getErrors() );
		}
	}

	if ( !$this->_check_init_config() )
	{
		$ret21 = $this->_config_store_handler->init();
		if ( !$ret21 )
		{
			$this->_set_errors( $this->_config_store_handler->getErrors() );
		}
	}

	if ( !$this->_exists_linkitem_table() )
	{
		$ret = $this->_linkitem_store_handler->create_table();
		if ( !$ret )
		{
			$this->_set_errors( $this->_linkitem_store_handler->getErrors() );
		}
	}

	if ( !$this->_check_init_linkitem() )
	{
		$ret = $this->_linkitem_store_handler->init();
		if ( !$ret )
		{
			$this->_set_errors( $this->_linkitem_store_handler->getErrors() );
		}
	}

	return $this->returnExistError();
}

//---------------------------------------------------------
// upgrade config
//---------------------------------------------------------
function check_version()
{
	if ( !$this->_check_version_link_110() )
	{	return false;	}

	if ( !$this->_check_version_modify_110() )
	{	return false;	}

	return true;
}

function upgrade_config()
{
	$this->_clear_errors();

	if ( !$this->_check_version_link_110() )
	{
		$ret = $this->_link_handler->add_column_table_110();
		if ( !$ret )
		{
			$this->_set_errors( $this->_link_handler->getErrors() );
		}
	}

	if ( !$this->_check_version_modify_110() )
	{
		$ret = $this->_modify_handler->add_column_table_110();
		if ( !$ret )
		{
			$this->_set_errors( $this->_modify_handler->getErrors() );
		}
	}

	return $this->returnExistError();
}

//---------------------------------------------------------
// print form
//---------------------------------------------------------
function print_form_init( $action='' )
{
	$this->_config_form->print_form_init( $action );
}

function print_form_upgrade( $action='' )
{
	$this->_config_form->print_form_upgrade( $action );
}


//---------------------------------------------------------
// check config
//---------------------------------------------------------
function _exists_config_table()
{
	$ret = $this->_config_store_handler->existsTable();
	return $ret;
}

function _exists_linkitem_table()
{
	$ret = $this->_linkitem_store_handler->existsTable();
	return $ret;
}

function _check_init_config()
{
	$num = $this->_config_store_handler->getCount();
	if ( $num == 0 )
	{	return false;	}

	return true;
}

function _check_init_linkitem()
{
	$num = $this->_linkitem_store_handler->getCount();
	if ( $num == 0 )
	{	return false;	}

	return true;
}

function _check_version_link_110()
{
	$ret = $this->_link_handler->check_version_110();
	return $ret;
}

function _check_version_modify_110()
{
	$ret = $this->_modify_handler->check_version_110();
	return $ret;
}

// --- class end ---
}

//================================================================
// class weblinks_config_check_form
//================================================================
class weblinks_config_check_form extends weblinks_form
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_config_check_form()
{
	$this->weblinks_form();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_config_check_form();
	}

	return $instance;
}

//---------------------------------------------------------
// public
//---------------------------------------------------------
function print_form_init( $action='' )
{
	$this->_print_form_box($action, _WEBLINKS_INIT_NOT, _WEBLINKS_INIT_EXEC, 'init');
}

function print_form_upgrade( $action='' )
{
	$title1 = sprintf( _WEBLINKS_VERSION_NOT, _WEBLINKS_VERSION );
	$this->_print_form_box($action, $title1, _WEBLINKS_UPGRADE_EXEC, 'upgrade');
}

//---------------------------------------------------------
// private
//---------------------------------------------------------
function _print_form_box($action, $title1, $title2, $op)
{
	xoops_error( $title1 );

	echo "<br />\n";
	echo '<div style="background-color: #dde1de; color: #000000; padding: 10px;">';
	echo '<span style="font-size: 130%; font-weight: bold;">';
	echo $title2;
	echo "</span><br />\n";
	echo $this->make_form_box( $action, $op, _SAVE );
	echo "</div><br />\n";
}

// --- class end ---
}

// === class end ===
}

?>