<?php
// $Id: link_list.php,v 1.8 2006/05/24 01:15:18 ohwada Exp $

// 2006-05-15 K.OHWADA
// new handler
// add class admin_link_list

// 2006-03-15 K.OHWADA
// use weblinks_pagenavi_basic::getInstance()

// 2006-01-06 K.OHWADA
// weblinks ver 1.0
// module depulication

//================================================================
// WebLinks Module
// view link list 
// 2004-12-14 K.OHWADA
//================================================================
include 'admin_header.php';

include_once WEBLINKS_ROOT_PATH.'/class/weblinks_form.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_pagenavi.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_page_frame.php';


//=========================================================
// class admin_link_list
//=========================================================
class admin_link_list extends weblinks_page_frame
{
	var $_modify_handler;
	var $_broken_handler;
	var $_strings;
	var $_lang;

	var $_google_url;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_link_list()
{
	$this->weblinks_page_frame();

	$this->_modify_handler =& weblinks_get_handler( 'modify', WEBLINKS_DIRNAME );
	$this->_broken_handler =& weblinks_get_handler( 'broken', WEBLINKS_DIRNAME );

	$this->_strings =& weblinks_strings::getInstance();
	$this->_lang    =& weblinks_language_convert::getInstance();

	$this->set_handler('link', WEBLINKS_DIRNAME);
	$this->set_id_name('lid');
	$this->set_max_sortid(3);
	$this->set_lang_no_item( _WEBLINKS_NO_LINK );
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_link_list();
	}
	return $instance;
}

//---------------------------------------------------------
// init
//---------------------------------------------------------
function init()
{
	$this->_google_url = $this->_lang->get_google_url();
}

//---------------------------------------------------------
// handler
//---------------------------------------------------------
function get_table_header()
{
	$arr = array(
		_WLS_LINKID,
		_WLS_SITETITLE,
		_WLS_SITEURL,
	);

	if ($this->_sortid == 2)
	{
		array_push( $arr, _WEBLINKS_COUNT_BROKEN );
	}

	return $arr;
}

function get_total()
{
	$total_all = $this->get_total_all();

	switch ($this->_sortid)
	{
		case 1:
			$total = $total_all;
			break;

		case 2:
			$total = $this->_handler->get_count_broken();
			break;

		case 3:
			$total = $this->_handler->get_count_non_url();
			break;

		case 0:
		default:
			$total = $total_all;
			break;
	}

	return $total;
}

function &get_items($limit=0, $start=0)
{
	switch ($this->_sortid)
	{
		case 1:
			$objs =& $this->_handler->get_objects_desc($limit, $start);
			break;

		case 2:
			$objs =& $this->_handler->get_objects_broken($limit, $start);
			break;

		case 3:
			$objs =& $this->_handler->get_objects_non_url($limit, $start);
			break;

		case 0:
		default:
			$objs =& $this->_handler->get_objects_all($limit, $start);
			break;
	}

	return $objs;
}

function &get_cols(&$obj)
{
	$lid     = $obj->getVar('lid',    'n');
	$broken  = $obj->getVar('broken', 'n');
	$title   = $obj->getVar('title',  'n');
	$title_s = $obj->getVar('title',  's');
	$url     = $obj->getVar('url',    'n');
	$url_s   = $obj->getVar('url',    's');

	$jump_link  = 'link_manage.php?op=modLink&lid=';
	$link_link  = $this->build_html_id_link_by_obj( $obj, 'lid', $jump_link);
	$url_view_lid = WEBLINKS_URL."/singlelink.php?lid=".$lid;
	$url_text_gif = WEBLINKS_URL."/images/text.gif";

	if ($this->_google_url)
	{
		$query  = $this->_lang->convert_to_utf8($title);
		$query  = urlencode($query);
		$google = $this->_google_url.$query;

		$link_title = $this->build_html_url_link($google, $title_s, '_blank');
	}
	else
	{
		$link_title = $title_s;
	}

	$link_url  = $this->build_html_url_link($url, $url_s, '_blank');
	$img_link  = $this->build_html_img($url_text_gif, 0, 0, 0, 'link');
	$view_link = $this->build_html_url_link($url_view_lid, $img_link, '', false);

	$arr = array(
		$view_link.'&nbsp;&nbsp;'.$link_link,
		$link_title,
		$link_url,
	);

	if ($this->_sortid == 2)
	{
		array_push( $arr, $broken );
	}

	return $arr;
}

//---------------------------------------------------------
// print
//---------------------------------------------------------
function print_top()
{
	$total_all         = $this->get_total_all();
	$total_broken      = $this->_handler->get_count_broken();
	$total_nourl       = $this->_handler->get_count_non_url();
	$total_newlinks    = $this->_modify_handler->get_count_new();
	$total_modify      = $this->_modify_handler->get_count_mod();
	$total_brokenlinks = $this->_broken_handler->getCount();

	switch ($this->_sortid)
	{
		case 1:
			$title = _WEBLINKS_ADMIN_LINK_ALL_DESC;
			break;

		case 2:
			$title = _WEBLINKS_ADMIN_LINK_BROKEN;
			break;

		case 3:
			$title = _WEBLINKS_ADMIN_LINK_NOURL;
			break;

		case 0:
		default:
			$title = _WEBLINKS_ADMIN_LINK_ALL_ASC;
			break;
	}

	$totalnewlinks    = $this->_strings->highlight_number($total_newlinks);
	$totalmodify      = $this->_strings->highlight_number($total_modify);
	$totalbrokenlinks = $this->_strings->highlight_number($total_brokenlinks);
	$broken           = $this->_strings->highlight_number($total_broken);

	echo "<h4>"._WEBLINKS_ADMIN_LINK_LIST."</h4>\n";
	printf(_WLS_THEREARE, $total_all);
	echo "<br /><br />\n";

	echo "<table width='80%' border='0' cellspacing='1' class='outer'>";
	echo "<tr class='odd'><td>";
	echo "<li><a href='link_list.php?sortid=0'>"._WEBLINKS_ADMIN_LINK_ALL_ASC."</a> ($total_all) </li>\n";
	echo "<li><a href='link_list.php?sortid=1'>"._WEBLINKS_ADMIN_LINK_ALL_DESC."</a> ($total_all) </li>\n";
	echo "<li><a href='link_list.php?sortid=2'>"._WEBLINKS_ADMIN_LINK_BROKEN."</a> ($total_broken) </li>\n";
	echo "<li><a href='link_list.php?sortid=3'>"._WEBLINKS_ADMIN_LINK_NOURL."</a> ($total_nourl) </li>\n";
	echo"</td></tr></table>\n";

	echo "<h4>".$title."</h4>\n";

	echo _WEBLINKS_ADMIN_LINK_BROKEN_CHECK_NOTICE;

	if ($this->_google_url)
	{
		echo _WEBLINKS_ADMIN_LINK_BROKEN_CHECK_GOOGLE."<br />\n";
	}

	echo "<br />\n";
}

// --- class end ---
}


//=========================================================
// main
//=========================================================
xoops_cp_header();

weblinks_admin_print_header();
weblinks_admin_print_menu();

$list =& admin_link_list::getInstance();
$list->show();

xoops_cp_footer();
exit();
// --- end of main ---

?>