<?php
// $Id: link_broken_check.php,v 1.6 2006/05/24 01:15:18 ohwada Exp $

// 2006-05-15 K.OHWADA
// new handler
// add class admin_link_broken_check_form
// use token ticket

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//=========================================================
// WebLinks Module
// check link broken
// 2004-10-20 K.OHWADA
//=========================================================

include 'admin_header.php';
include_once WEBLINKS_ROOT_PATH."/class/weblinks_form.php";
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_rss_atom_parser_base.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_rss_parser.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_atom_parser.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_rss_atom_collect_handler.php';
include_once WEBLINKS_ROOT_PATH.'/class/weblinks_link_check_handler.php';
include_once WEBLINKS_ROOT_PATH."/admin/admin_functions.php";


//=========================================================
// class admin_link_broken_check_form
//=========================================================
class admin_link_broken_check_form extends weblinks_form
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_link_broken_check_form()
{
	$this->weblinks_form();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_link_broken_check_form();
	}
	return $instance;
}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function show_first($limit, $offset)
{
	echo $this->make_form_start( 'check' );
	echo $this->make_form_token();
	echo $this->make_form_hidden('op',  'check');
	echo $this->make_table_start();
	echo $this->make_table_title( _WEBLINKS_ADMIN_LINK_BROKEN_CHECK );

	echo $this->make_table_form_text(_WEBLINKS_ADMIN_LIMIT,  'limit',  $limit);
	echo $this->make_table_form_text(_WEBLINKS_ADMIN_OFFSET, 'offset', $offset);
	echo $this->make_table_form_submit( '', 'post', _WEBLINKS_CHECK );

	echo $this->make_table_end();
	echo $this->make_form_end();

}

function show_next($limit, $offset)
{
	$opt = array(
		'op'     => 'check',
		'limit'  => $limit,
		'offset' => $offset, 
	);

	$submit = sprintf(_WEBLINKS_ADMIN_CHECK_NEXT, $limit);

	echo $this->make_form_box_option( '', $submit, $opt );

}

// --- class end ---
}


//=========================================================
// main
//=========================================================
$link_check =& weblinks_get_handler( 'link_check', WEBLINKS_DIRNAME );
$check_form =& admin_link_broken_check_form::getInstance();

$op = '';
if ( isset($_POST['op']) )  $op = $_POST['op'];

$limit  = 0;
$offset = 0;
if ( isset($_POST['limit']) )   $limit  = intval( $_POST['limit'] );
if ( isset($_POST['offset']) )  $offset = intval( $_POST['offset'] );

if ($limit  < 0)  $limit  = 0;
if ($offset < 0)  $offset = 0;

$flag_error = false;
$total_link = $link_check->get_link_count_all();

xoops_cp_header();

if ( $op == 'check' )
{
	if( !( $check_form->check_token() ) ) 
	{
		xoops_error("Token Error");
		$flag_error = true;
	}
}

weblinks_admin_print_header();
weblinks_admin_print_menu();

echo "<h4>"._WEBLINKS_ADMIN_LINK_BROKEN_CHECK."</h4>\n";
printf(_WLS_THEREARE, $total_link);
echo "<br /><br />\n";

echo _WEBLINKS_ADMIN_RSS_REFRESH_NOTE."<br /><br />\n";
echo _WEBLINKS_ADMIN_LINK_BROKEN_CHECK_CAUTION."<br />\n";

$check_form->show_first($limit, $offset);

if ( $flag_error )
{
	xoops_cp_footer();
	exit();
}

// link check
if ( $op == 'check' )
{
	echo "<hr />\n";
	echo "<h4>"._WEBLINKS_ADMIN_BROKEN_RESULT."</h4>\n";

	$link_check->check($limit, $offset);

// next
	$next = $offset + $limit;
	if (($limit > 0) && ($next < $total_link))
	{
		$check_form->show_next($limit, $next);
	}
	else
	{
		echo "<h4>"._FINISHED."</h4>\n";
	}

	echo "<hr />\n";
}

xoops_cp_footer();
exit();

?>