<?php
// $Id: admin_config_class.php,v 1.1 2006/05/24 01:16:13 ohwada Exp $

// 2006-05-15 K.OHWADA
// change for weblinks

//=========================================================
// WebLinks Module
// this file contain 2 class
//   admin_config_form
//   admin_config_store
// porting form RSSC 
// 2006-05-15 K.OHWADA
//================================================================

//================================================================
// class admin_config_form
//================================================================
class admin_config_form extends weblinks_config2_form
{
// handler
	var $_linkitem_form;

// local
	var $_line_count = 0;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_config_form()
{
	$this->weblinks_config2_form( WEBLINKS_DIRNAME );

// handler
	$this->_linkitem_form  =& weblinks_linkitem_form::getInstance( WEBLINKS_DIRNAME );

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_config_form();
	}

	return $instance;
}

//---------------------------------------------------------
// init
//---------------------------------------------------------
function init_form()
{
	$this->load();
}

//---------------------------------------------------------
// print
//---------------------------------------------------------
function print_menu()
{
	echo "<h3>"._WEBLINKS_ADMIN_MODULE_CONFIG_2."</h3>\n";

	echo "<table width='100%' border='0' cellspacing='1' class='outer'>\n";
	echo "<tr class='odd'><td>";
	echo "<ul>\n";
	echo "<li><a href='#form_auth'>"._WEBLINKS_ADMIN_AUTH."</a></li>\n";
	echo "<li><a href='#form_post'>"._WEBLINKS_ADMIN_POST."</a></li>\n";
	echo "<li><a href='#form_cat'>"._WEBLINKS_ADMIN_CAT_SET."</a></li>\n";
	echo "<li><a href='#form_link'>"._AM_WEBLINKS_CONF_LINK."</a></li>\n";
	echo "<li><a href='#form_link_image'>"._AM_WEBLINKS_CONF_LINK_IMAGE."</a></li>\n";
	echo "<li><a href='#form_view'>"._AM_WEBLINKS_CONF_VIEW."</a></li>\n";
	echo "<li><a href='#form_topten'>"._AM_WEBLINKS_CONF_TOPTEN."</a></li>\n";
	echo "<li><a href='#form_search'>"._AM_WEBLINKS_CONF_SEARCH."</a></li>\n";
	echo "<li><a href='#form_rss'>"._WEBLINKS_ADMIN_RSS."</a></li>\n";
	echo "<li><a href='#form_rss_view'>"._WEBLINKS_ADMIN_RSS_VIEW."</a></li>\n";
	echo "</ul>\n";
	echo"</td></tr></table>\n";

}

//---------------------------------------------------------
// show_auth
//---------------------------------------------------------
function show_form_auth($form_title)
{
	list($list_1, $list_2) = $this->get_group_list();

	$this->print_top('weblinks_config_auth', $form_title);

	$this->print_auth('auth_submit',      $list_1);
	$this->print_auth('auth_submit_auto', $list_1);
	$this->print_auth('auth_modify',      $list_2);
	$this->print_auth('auth_modify_auto', $list_2);
	$this->print_auth('auth_ratelink',    $list_1);

	$this->print_yesno('use_ratelink');
	$this->print_yesno('use_passwd');
	$this->print_text('passwd_min');
	$this->print_yesno('use_brokenlink');
	$this->print_yesno('use_hits');

	$this->print_form_bottom();
}

function show_form_post($form_title)
{
	list($list_1, $list_2) = $this->get_group_list();

	$this->print_top('weblinks_config_post', $form_title);

	$this->print_auth('auth_dohtml',   $list_1);
	$this->print_auth('auth_dosmiley', $list_1);
	$this->print_auth('auth_doxcode',  $list_1);
	$this->print_auth('auth_doimage',  $list_1);
	$this->print_auth('auth_dobr',     $list_1);

	$this->print_yesno('type_desc');
	$this->print_yesno('check_double');

	$this->print_form_bottom();
}

function get_group_list()
{
	$member_handler =& xoops_gethandler('member');
	$group_list = $member_handler->getGroupList();

	$list_1 = array();
	foreach ( $group_list as $k => $v )
	{
		$list_1[$v] = $k;
	}

	$list_2 = $list_1;
	$list_2[ _WEBLINKS_AUTH_UID ]    = WEBLINKS_ID_AUTH_UID;
	$list_2[ _WEBLINKS_AUTH_PASSWD ] = WEBLINKS_ID_AUTH_PASSWD;

	return array($list_1, $list_2);
}

function print_top($form_name, $form_title)
{
	echo $this->make_form_start($form_name);
	echo $this->make_form_token();
	echo $this->make_form_hidden('op', 'save');

	echo "<table class='outer' width='100%' ><tr>";
	echo "<th align='left' colspan='2'>".$form_title."</th>";
	echo "</tr>\n";
}

function print_auth($name, $opt)
{
	$cap  = $this->build_conf_caption_by_name($name);

	$id    = $this->get_by_name($name, 'conf_id');
	$value = $this->get_by_name($name, 'value');
	$size  = count($opt);

	$show   = $this->make_form_select_multiple($name, $value, $opt, $size);
	$show  .= $this->build_conf_hidden($id);

	echo "<tr>";
	echo "<td class='head'>$cap</td>";
	echo "<td class='odd'>$show</td>";
	echo "</tr>\n";
}

function print_yesno($name)
{
	$cap  = $this->build_conf_caption_by_name($name);
	$show = $this->build_conf_yesno_checkbox_by_name($name);

	echo "<tr>";
	echo "<td class='head'>$cap</td>";
	echo "<td class='odd'>$show</td>";
	echo "</tr>\n";
}

function print_text($name)
{
	$cap  = $this->build_conf_caption_by_name($name);
	$show = $this->build_conf_textbox_by_name($name);

	echo "<tr>";
	echo "<td class='head'>$cap</td>";
	echo "<td class='odd'>$show</td>";
	echo "</tr>\n";
}

//---------------------------------------------------------
// show_form_linkitem
//---------------------------------------------------------
function show_form_linkitem( $title )
{
	$this->_linkitem_form->show( $title );
}

//---------------------------------------------------------
// print form init
//---------------------------------------------------------
function print_form_init()
{
	echo "<br />\n";
	echo "<table class='outer' width='80%'><tr class='even' ><td>";
	echo "<h4>". _AM_WEBLINKS_INIT_EXEC ."</h4>\n";
	echo $this->make_form_box( '', 'init', _SAVE );
	echo "</td></tr></table>\n";
	echo "<br />\n";

}

//---------------------------------------------------------
// print form upgrade
//---------------------------------------------------------
function print_form_upgrade()
{
	echo "<br />\n";
	echo "<table class='outer' width='80%'><tr class='even' ><td>";
	echo "<h4>". _AM_WEBLINKS_UPGRADE_EXEC ."</h4>\n";
	echo $this->make_form_box( '', 'upgrade', _SAVE );
	echo "</td></tr></table>\n";
	echo "<br />\n";
}

//---------------------------------------------------------
// print html
//---------------------------------------------------------
function print_form_bottom()
{
	echo "<tr class='foot' ><td></td><td colspan='3'>";
	echo $this->make_form_submit( 'submit', _WEBLINKS_UPDATE );
	echo "</tr></table>\n";
	echo $this->make_form_end();
	echo "<br />\n";
}

//---------------------------------------------------------
// print html
// not use in weblinks
//---------------------------------------------------------
function print_top2($form_name, $name1, $name2)
{
	echo $this->make_form_start($form_name);
	echo $this->make_form_token();
	echo $this->make_form_hidden('op', 'save');

	echo "<table class='outer' width='100%' ><tr>";
	echo "<th align='center'>"._AM_RSSC_CONF_NAME."</th>";
	echo "<th align='center'>".$name1."</th>";
	echo "<th align='center'>".$name2."</th>";
	echo "</tr>\n";
}

function print_top3($form_name, $name1, $name2, $name3)
{
	echo $this->make_form_start($form_name);
	echo $this->make_form_token();
	echo $this->make_form_hidden('op', 'save');

	echo "<table class='outer' width='100%' ><tr>";
	echo "<th align='center'>"._AM_RSSC_CONF_NAME."</th>";
	echo "<th align='center'>".$name1."</th>";
	echo "<th align='center'>".$name2."</th>";
	echo "<th align='center'>".$name3."</th>";
	echo "</tr>\n";
}

function print_form_even_odd()
{
	if ($this->_line_count % 2 == 0) 
	{
		$class = 'even';
	}
	else 
	{
		$class = 'odd';
	}

	$this->_line_count ++;

	echo "<tr class='$class'>";
}

function print_two($name1, $name2='')
{
	if ( $name1 )
	{
		$title_show = $this->build_conf_caption_by_name($name1);
	}
	else
	{
		$title_show = $this->build_conf_caption_by_name($name2);
	}

	$name1_show = $this->build_conf_textbox_by_name($name1);
	$name2_show = $this->build_conf_textbox_by_name($name2);

	$this->print_form_even_odd();
	echo "<td>$title_show</td>";
	echo "<td align='right'>$name1_show</td>";
	echo "<td align='right'>$name2_show</td></tr>\n";

}

function print_three($name1, $name2='', $name3='')
{
	if ( $name1 )
	{
		$title_show = $this->build_conf_caption_by_name($name1);
	}
	elseif ( $name2 )
	{
		$title_show = $this->build_conf_caption_by_name($name2);
	}
	else
	{
		$title_show = $this->build_conf_caption_by_name($name3);
	}

	$name1_show = $this->build_conf_textbox_by_name($name1);
	$name2_show = $this->build_conf_textbox_by_name($name2);
	$name3_show = $this->build_conf_textbox_by_name($name3);

	$this->print_form_even_odd();
	echo "<td>$title_show</td>";
	echo "<td align='right'>$name1_show</td>";
	echo "<td align='right'>$name2_show</td>";
	echo "<td align='right'>$name3_show</td></tr>\n";

}

function print_sel2($name1, $name2='')
{
	$title_show = $this->build_conf_caption_by_name($name1);
	$name1_show = $this->build_conf_radio_select_by_name($name1);
	$name2_show = $this->build_conf_radio_select_by_name($name2);

	$this->print_form_even_odd();
	echo "<td>$title_show</td>";
	echo "<td align='left'>$name1_show</td>";
	echo "<td align='left'>$name2_show</td></tr>\n";

}

function print_sel3($name1, $name2='', $name3='')
{
	$title_show = $this->build_conf_caption_by_name($name1);
	$name1_show = $this->build_conf_radio_select_by_name($name1);
	$name2_show = $this->build_conf_radio_select_by_name($name2);
	$name3_show = $this->build_conf_radio_select_by_name($name3);

	$this->print_form_even_odd();
	echo "<td>$title_show</td>";
	echo "<td align='left'>$name1_show</td>";
	echo "<td align='left'>$name2_show</td>";
	echo "<td align='left'>$name3_show</td></tr>\n";

}

function print_form_conf_checkbox($name)
{
	$this->print_form_even_odd();

	$name_show = $this->build_conf_yseno_checkbox_by_name($name);
	$this->print_conf_line($name, $name_show);
}

function print_form_conf_radio($name)
{
	$this->print_form_even_odd();

	$title_show = $this->build_conf_caption_by_name($name);
	$name_show  = $this->build_conf_radio_select_by_name($name);

	echo "<td></td><td>$title_show</td><td></td><td></td>";
	echo "<td align='left' colspan='2'>$name_show</td>";
	echo "<td></td></tr>\n";
}

function print_conf_line($name, $name1_show, $name2_show='')
{
	$title_show = $this->build_conf_caption_by_name($name);

	echo "<td></td><td>$title_show</td><td></td><td></td>";
	echo "<td align='right'>$name1_show</td><td></td>";
	echo "<td align='right'>$name2_show</td></tr>\n";
}

function print_msg($title)
{
	echo "<h4>$title</h4>\n";
}

function print_error($title, $msg)
{
	echo "<h3><font color='red'>$title</font></h3>\n";
	echo "$msg<br /><br />\n";
}


// --- class end ---
}


//================================================================
// class admin_config
//================================================================
class admin_config_store extends weblinks_error
{

// handler
	var $_config_store_handler;
	var $_linkitem_store_handler;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_config_store()
{
	$this->weblinks_error();

// handler
	$this->_config_store_handler   =& weblinks_get_handler('config2_store',  WEBLINKS_DIRNAME);
	$this->_linkitem_store_handler =& weblinks_get_handler('linkitem_store', WEBLINKS_DIRNAME);

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_config_store();
	}

	return $instance;
}

//---------------------------------------------------------
// save config
//---------------------------------------------------------
function save_config()
{
	if ( isset($_POST['save_linkitem']) )
	{
		$ret = $this->_linkitem_store_handler->save();
		if ( !$ret )
		{
			$this->_set_errors( $this->_linkitem_store_handler->getErrors() );
		}
	}
	else
	{
		$ret = $this->_config_store_handler->save();
		if ( !$ret )
		{
			$this->_set_errors( $this->_config_store_handler->getErrors() );
		}
	}

	return $ret;
}

// --- class end ---
}

?>