<?php
// $Revision: 1.1.4.3 $
// ------------------------------------------------------------------------- //
//  XooNIps - Neuroinformatics Base Platform System                          //
//  Copyright (C) 2005-2009 RIKEN, Japan All rights reserved.                //
//  http://xoonips.sourceforge.jp/                                           //
// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
// ------------------------------------------------------------------------- //
if ( ! defined( 'XOOPS_ROOT_PATH' ) ) {
  exit();
}

/**
 * XooNIps File Handler Class
 */
class XooNIpsFileHandler {

  /**
   * orm handler of xoonips_file table
   * @access private
   * @var object
   */
  var $xf_handler;

  /**
   * orm handler of xoonips_search_text table
   * @access private
   * @var object
   */
  var $xst_handler;

  /**
   * file uploaded path
   * @access private
   * @var string
   */
  var $upload_dir;

  /**
   * constractor
   *
   * @access public
   */
  function XooNIpsFileHandler() {
    $this->xf_handler =& xoonips_getormhandler( 'xoonips', 'file' );
    $this->xst_handler =& xoonips_getormhandler( 'xoonips', 'search_text' );
    $xc_handler =& xoonips_getormhandler( 'xoonips', 'config' );
    $this->upload_dir = $xc_handler->getValue( 'upload_dir' );
  }

  /**
   * get file path
   *
   * @access public
   * @param int $file_id file id
   * @return string uploaded file path
   */
  function getFilePath( $file_id ) {
    $file_path = $this->upload_dir.'/'.$file_id;
    return $file_path;
  }

  /**
   * get file id by doi - NTTDK and Keio University 20080825
   *
   * @access public
   * @param string $doi doi parameter
   * @return int file id
   */
  function getFileIdByDOI( $doi ) {
    if ( empty( $doi ) ) {
      return false;
    }
    $xf_handler =& xoonips_getormhandler( 'xoonips', 'file' );
    $join = new XooNIpsJoinCriteria( 'xoonips_item_basic', 'item_id', 'item_id', 'INNER', 'ib' );
    $criteria = new CriteriaCompo( new Criteria( 'is_deleted' , 0 ) );
    $criteria->setSort( 'file_id' );
    $separate_param = XNP_CONFIG_DOWNLOAD_DOI_FIELD_SEPARATE_PARAM;
    if ( preg_match( '/'.preg_quote( $separate_param, '/' ).'/', $doi ) ) {
      $tmp = explode( $separate_param, $doi, 2 );
      $doi = $tmp[0];
      if ( preg_match( '/[1-9]/', intval( $tmp[1] ) ) ) {
        $start = intval( $tmp[1] ) - 1;
        $criteria->setStart( $start );
        $criteria->setLimit( $start + 1 );
      }
    }
    $mimetypes = explode( ',', XNP_CONFIG_DOWNLOAD_FILE_TYPE_LIMIT );
    $mimetypes = array_map( array( &$GLOBALS['xoopsDB'], 'quoteString' ), $mimetypes );
    $criteria->add( new Criteria( 'mime_type', '('.implode( ',', $mimetypes ).')', 'IN' ) );
    $criteria->add( new Criteria( 'doi', $doi, '=', 'ib' ) );
    $xf_objs =& $xf_handler->getObjects( $criteria, false, 'file_id', false, $join );
    if ( count( $xf_objs ) == 0 ) {
      return false;
    }
    $file_id = $xf_objs[0]->get( 'file_id' );
    return $file_id;
  }
}
?>
