<?php
class defaultAction extends adminAction
{

//------------------------------------------------------------------------------

function dispatch(&$context)
{
	$perm_err = $this->checkPermission();
	if(!is_array($perm_err) || count($perm_err) > 0){
		$context->setAttributes('perm_error', $perm_err);
	}
	
	$gd_err = $this->checkGD();
	if(is_array($gd_err) && count($gd_err) > 0){
		$context->setAttributes('gd_error', $gd_err);
	}
	
	if(!$this->replaceMypage()){
		$context->setAttributes('mypage_error', 1);
	}
}

//------------------------------------------------------------------------------

// ޥڡ  ȾڡΥե֤
function replaceMypage()
{
	if(defined('XOOPS_CUBE_LEGACY')){
		return true;
	}
	
	global $xoopsModuleConfig, $mydirname;
	
	$userinfo_file = XOOPS_ROOT_PATH.'/userinfo.php';
	$edituser_file = XOOPS_ROOT_PATH.'/edituser.php';
	$userinfo_file_r = APP_TRUST_PATH.'/x20/userinfo.php';
	$edituser_file_r = APP_TRUST_PATH.'/x20/edituser.php';
	$userinfo_file_b = APP_TRUST_PATH.'/x20/bak_userinfo.php';
	$edituser_file_b = APP_TRUST_PATH.'/x20/bak_edituser.php';
	
	if(file_exists($userinfo_file) && file_exists($edituser_file)){
		if($xoopsModuleConfig['mypage_use']
		   && file_exists($userinfo_file_r)
		   && file_exists($edituser_file_r)
		   && md5_file($userinfo_file) != md5_file($userinfo_file_r)
		   && md5_file($edituser_file) != md5_file($edituser_file_r)){
			
			// ȾڡХåå  ޥڡ֤
			@copy($userinfo_file, $userinfo_file_b);
			@copy($edituser_file, $edituser_file_b);
			@copy($userinfo_file_r, $userinfo_file);
			@copy($edituser_file_r, $edituser_file);
			
			if($handle = @fopen(APP_TRUST_PATH.'/x20/dirname.dat', 'w')){
				fwrite($handle, $mydirname);
				fclose($handle);
			}
			else{
				return false;
			}
		}
		elseif(!$xoopsModuleConfig['mypage_use']
			   && file_exists($userinfo_file_b)
			   && file_exists($edituser_file_b)
			   && md5_file($userinfo_file) == md5_file($userinfo_file_r)
			   && md5_file($edituser_file) == md5_file($edituser_file_r)){
			
			// ξ֡ʥȾڡˤ᤹
			@copy($userinfo_file_b, $userinfo_file);
			@copy($edituser_file_b, $edituser_file);
		}
		return true;
	}
	return false;
}

//------------------------------------------------------------------------------

function checkGD()
{
	$errors = array();
	
	if(!function_exists('gd_info')){
		$errors[] = _MD_A_GD_ERR_NONE;
		return $errors;
	}
	
	$gdinfo = gd_info();
	
	if(isset($gdinfo['GD Version']) && preg_match('/\d+\.\d+\.\d+/', $gdinfo['GD Version'], $matches)){
		$gd_ver = " (GD Version ".$matches[0].")";
	}
	else{
		$gd_ver = "";
	}
	
	if(!isset($gdinfo['GIF Read Support']) || !$gdinfo['GIF Read Support'] || !function_exists('imagegif')
	   || !isset($gdinfo['GIF Create Support']) || !$gdinfo['GIF Create Support'] || !function_exists('imagecreatefromgif')){
		$errors[] = _MD_A_GD_ERR_GIF. $gd_ver;
	}
	if(!isset($gdinfo['JPG Support']) || !$gdinfo['JPG Support'] || !function_exists('imagejpeg') || !function_exists('imagecreatefromjpeg')){
		$errors[] = _MD_A_GD_ERR_JPG. $gd_ver;
	}
	if(!isset($gdinfo['PNG Support']) || !$gdinfo['PNG Support'] || !function_exists('imagepng') || !function_exists('imagecreatefrompng')){
		$errors[] = _MD_A_GD_ERR_PNG. $gd_ver;
	}
	
	return $errors;
}

//------------------------------------------------------------------------------

}

?>
