<?php

require_once 'root.class.php';

//******************************************************************************

class CM_Topic extends CM_Root
{
	var $handler = NULL;
	
	//--------------------------------------------------------------------------
	
	function CM_Topic()
	{
		// $key, $data_type, $default, $required, $size
		$this->initVar('c_commu_topic_id', XOBJ_DTYPE_INT);
		$this->initVar('c_commu_id', XOBJ_DTYPE_INT);
		$this->initVar('name', XOBJ_DTYPE_TXTBOX);
		$this->initVar('r_datetime', XOBJ_DTYPE_TXTBOX);
		$this->initVar('r_date', XOBJ_DTYPE_TXTBOX);
		$this->initVar('uid', XOBJ_DTYPE_INT);
		
		$this->handler = array(
			'comment' => CM_TopicCommentHandler::getInstance(),
			'image' => CM_ImageHandler::getInstance(),
			'file' => CM_FileHandler::getInstance(),
		);
	}
	
	//--------------------------------------------------------------------------
	
	function &getCommentList($limit=0, $start=0)
	{
		return $this->handler['comment']->getListByTopicId($this->getVar('c_commu_topic_id'), $limit, $start);
	}
	//--------------------------------------------------------------------------
	
	function &getCommentListForPreview($limit=0, $start=0)
	{
		$num_criteria = new CriteriaCompo(new Criteria('number', 1+$start, '>='));
		$num_criteria->add(new Criteria('number', 1+$start+$limit, '<'));
		
		$num_criteria2 = new CriteriaCompo(new Criteria('number', 0));
		$num_criteria2->add($num_criteria, 'OR');
		
		$criteria = new CriteriaCompo(new Criteria('c_commu_topic_id', $this->getVar('c_commu_topic_id')));
		$criteria->add($num_criteria2);
		
		$obj_list =& $this->handler['comment']->getObjects($criteria, true);
		$ret = array();
		foreach($obj_list as $key => $obj){
			$ret[$obj->getVar('number')] = $obj->getVarsArray();
		}
		return $ret;
	}
	//--------------------------------------------------------------------------
	
	function getCommentCount()
	{
		return $this->handler['comment']->getCountByTopicId($this->getVar('c_commu_topic_id'));
	}
	//--------------------------------------------------------------------------
	
	function deleteCommentsAll()
	{
		// ȥԥåΥȤźդ줿/եƺ
		$comment_list =& $this->getCommentList();
		$comment_ids = array();
		foreach($comment_list as $comment){
			$comment_ids[] = $comment['c_commu_topic_comment_id'];
		}
		if(count($comment_ids) > 0){
			$criteria = new CriteriaCompo(new Criteria('target', 2));
			$criteria->add(new Criteria('target_id', '('.implode(',', $comment_ids).')', 'IN'));
			$this->handler['image']->deleteObjects($criteria);
			$this->handler['file']->deleteObjects($criteria);
		}
		
		// ȥԥåΥȤƺ
		$criteria = new Criteria('c_commu_topic_id', $this->getVar('c_commu_topic_id'));
		return $this->handler['comment']->deleteObjects($criteria);
	}
	//--------------------------------------------------------------------------
}

//******************************************************************************

class CM_TopicHandler extends CM_RootHandler
{
	//--------------------------------------------------------------------------
	
	function CM_TopicHandler()
	{
		$this->CM_RootHandler();
		$this->obj_class = "CM_Topic";
		$this->table_name = "c_commu_topic";
		$this->primary_key = "c_commu_topic_id";
	}
	
	//--------------------------------------------------------------------------
	
	function &getInstance()
	{
		static $instance = NULL;
		if(is_null($instance)){
			$instance = new CM_TopicHandler();
		}
		return $instance;
	}
	
	//--------------------------------------------------------------------------
	
	function &getListForCommunity($cid, $limit=0, $start=0, $get_body=false)
	{
		$ts =& CM_TextSanitizer::getInstance();
		
		$ret = array();
		
		$sql = "SELECT ".
				"ct.c_commu_topic_id AS tid,".
				"ct.name AS tname,".
				"MAX(ctc.r_datetime) AS max_r_datetime,".
				"COUNT(*) AS comment_count".
				" FROM ". $this->prefix('c_commu_topic_comment'). " ctc".
				" INNER JOIN ". $this->prefix('c_commu_topic'). " ct".
				" USING(c_commu_topic_id)".
				" WHERE ct.c_commu_id='".intval($cid)."'".
				" GROUP BY ctc.c_commu_topic_id".
				" ORDER BY max_r_datetime DESC";
		$rs = $this->db->query($sql, $limit, $start);
		if(!$rs){
			return $ret;
		}
		if($get_body){
			$comment_handler =& CM_TopicCommentHandler::getInstance();
			
			while($row = $this->db->fetchArray($rs)){
				$comment =& $comment_handler->getByNumber($row['tid'], 0);
				$r_date = explode(' ', $row['max_r_datetime'], 2);
				
				$ret[] = array(
					'name' => $ts->htmlSpecialChars($row['tname']),
					'r_date' => $r_date[0],
					'r_datetime' => str_replace(' ', '<br>', $row['max_r_datetime']),
					'body' => $comment->getVar('body'),
					'page_url' => _CM_URL_TOPIC.'&tid='.$row['tid'],
					'res_count' => $row['comment_count']-1,	// except comment No.0
				);
				unset($comment);
			}
		}
		else{
			while($row = $this->db->fetchArray($rs)){
				$r_date = explode(' ', $row['max_r_datetime'], 2);
				
				$ret[] = array(
					'name' => $ts->htmlSpecialChars($row['tname']),
					'r_date' => $r_date[0],
					'r_datetime' => str_replace(' ', '<br>', $row['max_r_datetime']),
					'body' => '',
					'page_url' => _CM_URL_TOPIC.'&tid='.$row['tid'],
					'res_count' => $row['comment_count']-1,	// except comment No.0
				);
				unset($comment);
			}
		}
		return $ret;
	}
	
	//--------------------------------------------------------------------------
	
	function getCountForCommunity($cid)
	{
		$criteria = new Criteria('c_commu_id', intval($cid));
		return $this->getCount($criteria);
	}
	
	//--------------------------------------------------------------------------
	
}

//******************************************************************************

?>
