<?php
class footprintAction extends mypageAction
{

function dispatch(&$context)
{
	global $xoopsUser, $xoopsModuleConfig;
	if($this->isGuest() || !$xoopsModuleConfig['footprint_use']){
		redirect_header(XOOPS_URL, 2, _NOPERM);
	}
	
	$limit = 30;
	
	$own_uid = $xoopsUser->getVar('uid');
	$user_handler =& CM_UserHandler::getInstance();
	$own_user =& $user_handler->get($own_uid);
	if(!is_object($own_user)){
		redirect_header(XOOPS_URL, 2, _NOPERM);
	}
	
	$footprint_handler =& CM_FootprintHandler::getInstance();
	$footprint_list_temp =& $footprint_handler->getListForUser($own_uid, $limit);
	$footprint_count = $footprint_handler->getCountForUser($own_uid);
	
	$user_ids = array();
	foreach($footprint_list_temp as $footprint){
		$user_ids[] = $footprint['uid_from'];
	}
	$user_ids = array_unique($user_ids);
	
	$criteria = new Criteria('uid', '('.implode(',',$user_ids).')', 'IN');
	$user_obj_list =& $user_handler->getObjects($criteria, true);
	
	$footprint_list = array();
	
	foreach($footprint_list_temp as $footprint){
		$uid = $footprint['uid_from'];
		$footprint_list[] = array(
			'uname' => isset($user_obj_list[$uid]) ? $user_obj_list[$uid]->getVar('uname') : "",
			'url' => _CM_URL_MYPAGE.'&uid='.$uid,
			'r_datetime' => $footprint['r_datetime'],
		);
	}
	
	$context->setAttributes('myname', $own_user->getVar('uname'));
	$context->setAttributes('footprint_list', $footprint_list);
	$context->setAttributes('footprint_count', number_format($footprint_count));
	$context->setAttributes('user_menu', $own_user->getMyMenu());
}

}
?>
