<?php
// $Id: userinfo.php,v 1.3 2006/05/01 02:37:26 onokazu Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //


class defaultAction extends mypageAction
{

function dispatch(&$context)
{
	global $xoopsUser, $xoopsModuleConfig;
	$own_uid = $this->isGuest() ? 0 : $xoopsUser->getVar('uid');
	
	$uid = $this->getIntRequest('uid', APP_REQUEST_GET);
	if(!$uid){
		$uid = $own_uid;
	}
	
	$user_handler =& CM_UserHandler::getInstance();
	$user =& $user_handler->get($uid);
	if(!is_object($user)){
		redirect_header(APP_BASE_URL, 2, _NOPERM);
	}
	
	if($uid == $own_uid){
		$is_own_page = true;
		$is_friend_page = false;
		
		// Information List
		$info_list =& $user->getInformationList();
	}
	else{
		$is_own_page = false;
		$own =& $user_handler->get($own_uid);
		if(is_object($own)){
			$is_friend_page = $own->isFriend($uid);
			
			// Add Footprint
			if($xoopsModuleConfig['footprint_use']){
				$footprint_handler =& CM_FootprintHandler::getInstance();
				$footprint_handler->add($uid, $own_uid);
			}
		}
		else{
			$is_friend_page = false;
		}
		$info_list = NULL;
	}
	
	if($is_own_page || $is_friend_page){
		if($is_own_page){
			// Topic List
			$topic_list =& $user->getTopicList(5, 0);
			$topic_count_all = $user->getTopicCount();
			
			// Friend's Blog List
			$blog_list =& $user->getFriendBlogList(10, 0, &$blog_count_all);
		}
		else{
			$topic_list = array();
			$topic_count_all = 0;
			
			// My Blog List
			$blog_list =& $user->getMyBlogList(10, 0, &$blog_count_all);
		}
	}
	else{
		$friend_list = $topic_list = $blog_list = array();
		$topic_count_all = $blog_count_all = 0;
	}
	
	// Friend List
	$friend_list =& $user->getFriendList(9, 0, true);
	$friend_count = count($friend_list);
	if($friend_count%3 > 0){
		for($i=0; $i<(3-$friend_count%3); $i++){
			$friend_list[] = array();
		}
	}
	$friend_count_all = $user->getFriendCount();
	
	// Community List
	$commu_list =& $user->getCommunityList(9, 0, true);
	$commu_count = count($commu_list);
	if($commu_count%3 > 0){
		for($i=0; $i<(3-$commu_count%3); $i++){
			$commu_list[] = array();
		}
	}
	$commu_count_all = $user->getCommunityCount();
	
	// Introduction List
	$intro_list =& $user->getIntroList(5, 0, true);
	$intro_count_all = $user->getIntroCount();
	
	// Output
	$context->setAttributes('user_menu', $user->getMyMenu());
	$context->setAttributes('user_info', $this->getUserInfo($uid));
	
	$context->setAttributes('info_list', $info_list);
	$context->setAttributes('friend_list', $friend_list);
	$context->setAttributes('commu_list', $commu_list);
	$context->setAttributes('topic_list', $topic_list);
	$context->setAttributes('blog_list', $blog_list);
	$context->setAttributes('intro_list', $intro_list);
	
	$context->setAttributes('friend_count', $friend_count_all);
	$context->setAttributes('commu_count', $commu_count_all);
	$context->setAttributes('topic_count', $topic_count_all);
	$context->setAttributes('blog_count', $blog_count_all);
	$context->setAttributes('intro_count', $intro_count_all);
	
	$context->setAttributes('is_own_page', $is_own_page);
	$context->setAttributes('is_friend_page', $is_friend_page);

}
//------------------------------------------------------------------------------

function getUserInfo($uid)
{
	global $xoopsUser, $xoopsConfig, $xoopsUserIsAdmin;
	require_once XOOPS_ROOT_PATH.'/language/'.$xoopsConfig['language'].'/user.php';
	
	$user_handler =& xoops_gethandler('user');
	$user =& $user_handler->get($uid);
	
	if($xoopsUserIsAdmin || (is_object($xoopsUser) && $uid==$xoopsUser->getVar('uid')) || $user->getVar('user_viewemail')){
		$email = $user->getVar('email', 'E');
	}
	else{
		$email = "";
	}
	
	if (is_object($xoopsUser)) {
		$pmlink = "<a href=\"javascript:openWithSelfMain('".XOOPS_URL."/pmlite.php?send2=1&amp;to_userid=".$uid."', 'pmlite', 450, 380);\"><img src=\"".XOOPS_URL."/images/icons/pm.gif\" alt=\"".sprintf(_SENDPMTO,$user->getVar('uname'))."\" /></a>";
	}
	else {
		$pmlink = '';
	}
	
	$userrank =& $user->rank();
	if ($userrank['image']) {
		$ranktitle = $userrank['title'];
		$rankimage = '<img src="'.XOOPS_UPLOAD_URL.'/'.$userrank['image'].'" alt="" />';
	}
	else{
		$ranktitle = "";
		$rankimage = "";
	}
	$websiteurl = $user->getVar('url');
	
	$user_info = array(
		'id' => array(
				'desc' => NULL,
				'value' => $uid,
			),
		'avatarurl' => array(
				'desc' => _US_AVATAR, 
				'value' => "<img src='".XOOPS_URL."/uploads/".$user->getVar('user_avatar')."' alt='".$user->getVar('uname')."'>",
			),
		'name' => array(
				'desc' => _US_USERNAME, 
				'value' => $user->getVar('uname'),
			),
		'realname' => array(
				'desc' => _US_REALNAME, 
				'value' => $user->getVar('name'),
			),
		'rank' => array(
				'desc' => _US_RANK,
				'value' => $rankimage."&nbsp;".$userrank['title']."&nbsp;("._US_POSTS.":".$user->getVar('posts').")",
			),
		'websiteurl' => array(
				'desc' => _US_WEBSITE, 
				'value' => !empty($websiteurl)? '<a href="'.$user->getVar('url', 'E').'" target="_blank">'.$websiteurl.'</a>' : NULL,
			),
		'email' => array(
				'desc' => _US_EMAIL, 
				'value' => $email,
			),
		'pmlink' => array(
				'desc' => _US_PM, 
				'value' => $pmlink,
			),
		'icq' => array(
				'desc' => _US_ICQ, 
				'value' => $user->getVar('user_icq'),
			),
		'aim' => array(
				'desc' => _US_AIM, 
				'value' => $user->getVar('user_aim'),
			),
		'yim' => array(
				'desc' => _US_YIM, 
				'value' => $user->getVar('user_yim'),
			),
		'msnm' => array(
				'desc' => _US_MSNM, 
				'value' => $user->getVar('user_msnm'),
			),
		'location' => array(
				'desc' => _US_LOCATION, 
				'value' => $user->getVar('user_from'),
			),
		'occupation' => array(
				'desc' => _US_OCCUPATION, 
				'value' => $user->getVar('user_occ'),
			),
		'interest' => array(
				'desc' => _US_INTEREST, 
				'value' => $user->getVar('user_intrest'),
			),
		'signature' => array(
				'desc' => _US_SIGNATURE, 
				'value' => $user->getVar('user_sig'),
			),
		'extrainfo' => array(
				'desc' => _US_EXTRAINFO, 
				'value' => $user->getVar('bio'),
			),
	);
	return $user_info;
}
//------------------------------------------------------------------------------
}
?>
