
BEGIN { unshift(@INC, "/cgi-bin/libs"); }

use Jcode;
use Time::Local;

%analyzeLog = ();

&logAnalyzer;

$useAnalyze;

sub logAnalyzer {
	### åɤ߹(useAnalyze'noAnalyze'λϥȤʤ) ###
	foreach(split(/;/, $ENV{'HTTP_COOKIE'})) {
		($key, $val) = split(/=/);
		$key =~ s/\s//g;
		$cook{$key} = $val;
	}

	if (exists $cook{useAnalyze} && $cook{useAnalyze} == 'noAnalyze') {
		$useAnalyze = 0;
	}
	else {
		$useAnalyze = 1;
	}
	#####################################################################

	my $pageValue = "FrontPage";
	my $searchWordValue = "";
	if (exists $::form{p}) {
		$pageValue = $::form{p};
	}
	if (exists $ENV{HTTP_REFERER}) {
		$refererValue = $ENV{HTTP_REFERER};
		my ($refURL, $refParamStr) = split(/\?/, $refererValue);
		my @refParamSet = split(/\&/, $refParamStr);

		my %refParam = ();
		for $paramSet (@refParamSet) {
			my ($key, $value) = split(/=/, $paramSet);
			$refParam{$key} = $value;
		}
		if($refURL =~ /\.google\./) {
			my $query = $refParam{'q'};
			$query =~ s/\+/ /g;
			$query =~ s/%([0-9a-fA-F][0-9a-fA-F])/pack("H2", $1)/eg;
			&Jcode::convert(\$query, "euc");
			$searchWordValue = $query;
		}
		elsif($refURL =~ /\.yahoo\./) {
			my $query = $refParam{'p'};
			$query =~ s/\+/ /g;
			$query =~ s/%([0-9a-fA-F][0-9a-fA-F])/pack("H2", $1)/eg;
			&Jcode::convert(\$query, "euc");
			$searchWordValue = $query;
		}
	}
	else {
		$refererValue = 'DIRECT_ACCESS';
	}

	my $clientValue = $ENV{'REMOTE_ADDR'};
	
	if (exists $ENV{REMOTE_HOST}) {
		$clientValue = $ENV{REMOTE_HOST};
	}
	elsif (exists $ENV{REMOTE_ADDR}) {
		$clientValue = $ENV{REMOTE_ADDR};
	}
	
	my $userAgentValue = "Undefined";
	if (exists $ENV{HTTP_USER_AGENT}) {
		$userAgentValue = $ENV{HTTP_USER_AGENT};
	}

	# wifkyΥǥեȤƤ륢analyzerϼưŪ˽
	my $ignoreActionList = 'index;rindex;older;recent;\?;edt;pwd;ren;del;comment;Delete;Commit;Preview;Upload;tools;preferences;new;analyzer;' . $main::config{'REFERER_IGNORE_ACTION'};
	if (exists $::form{a}) {
		foreach(split(/;/, $ignoreActionList)) {
			my $ignoreAction = $_;
			if ($::form{a} =~ /$ignoreAction/) {
				$useAnalyze = 0;
			}
		}
	}
	# źեեؤΥϽ
	if (exists $::form{f}) {
		$useAnalyze = 0;
	}

	if ($useAnalyze) {
		open(LOGFP, "+<access_log.cgi") or open(LOGFP, "+>access_log.cgi") or die("Can't access log File Open.\n"); #'
		$| = 1; # FP Ф񤭹ߥХåե󥰤򤷤ʤ롣
		flock(LOGFP, 2); # ¾å(2)
		seek(LOGFP, 0, 0); # եݥ󥿤եƬ
		my @logLines = <LOGFP>;
		($no,$pageName,$referer,$datetime,$clientHost,$userAgent,$searchWord) = (split(/<>/, $logLines[0]))[0,1,2,3,4,5,6];
		$no++;
		$ENV{'TZ'} = "JST-9";
		$time = time;
		unshift(@logLines, "$no<>$pageValue<>$refererValue<>$time<>$clientValue<>$userAgentValue<>$searchWordValue\n");
		seek(LOGFP, 0, 0); # եݥ󥿤եƬ
		print(LOGFP @logLines);
		flock(LOGFP, 8); # å(8)
		close(LOGFP);
	}
};

$main::action_plugin{analyzer} = \&analyzerAction;

sub analyzerAction {
	my $category = "Counter";
	if (exists $::form{category}) {
		$category = $::form{category};
	}
	&print_header(divclass=>'max',title=>'');
	my $bbsEmpty = 0;
	open(LOGFP, "access_log.cgi") or $bbsEmpty = 1;
	my @logLines = <LOGFP>;
	close(LOGFP);
	&puts('<h1></h1>');

	my $URL = sprintf('http://%s%s?a=analyzer', $ENV{'HTTP_HOST'}, $ENV{'SCRIPT_NAME'});
	&puts(sprintf(qq(<a href="%s&category=Counter">󥿡</a>), $URL));
	&puts(sprintf(qq(<a href="%s&category=Referer">󥯸</a>), $URL));
	&puts(sprintf(qq(<a href="%s&category=Client">饤</a>), $URL));
	&puts(sprintf(qq(<a href="%s&category=UserAgent">ϣӡ֥饦</a>), $URL));
	&puts(sprintf(qq(<a href="%s&category=Search"></a>), $URL));
	&puts(sprintf(qq(<a href="%s&category=SearchWord">(ñ)</a>), $URL));
	
	&puts("<br><br>");

	## ڡΥ󥿡 ##
	if ($category eq "Counter") {
		&viewCounter(@logLines);
	}
	## 󥯸󥿡 ##
	elsif ($category eq "Referer") {
		&viewReferer(@logLines);
	}
	## 饤ȥۥȥ󥿡 ##
	elsif ($category eq "Client") {
		&viewClient(@logLines);
	}
	## 桼ȥ󥿡 ##
	elsif ($category eq "UserAgent") {
		&viewUserAgent(@logLines);
	}
	## ɥ󥿡() ##
	elsif ($category eq "Search") {
		&viewSearch(@logLines);
	}
	## ɥ󥿡(ññ) ##
	elsif ($category eq "SearchWord") {
		&viewSearchWord(@logLines);
	}
};

sub viewCounter {
	my (@logLines) = @_;
	my ($lastNo,$lastPageName,$lastReferer,$lastDatetime,$lastClientHost,$lastUserAgent,$lastSearchWord) = (split(/<>/, $logLines[0]))[0,1,2,3,4,5,6];
	my ($mday,$mon,$year) = (localtime(time))[3..5];
	my $today = timelocal(0, 0, 0, $mday, $mon, $year);
	my $todayCount = $lastNo;
	my %counter = ();
	foreach $logItem (@logLines) {
		my ($no,$pageName,$referer,$datetime,$clientHost,$userAgent,$searchWord) = (split(/<>/, $logItem))[0..6];
		if ($datetime < $today and $todayCount == $lastNo) {
			$todayCount = $lastNo - $no;
		}
		if (exists $counter{$pageName}) {
			$counter{$pageName}++;
		}
		else {
			$counter{$pageName} = 1;
		}
	}
	&puts(qq(<table><tr><td align="right"></td><td>${lastNo}</td></tr>
<tr><td align="right">Υ</td><td>${todayCount}</td></tr></table><br><br>));
	&puts("<table>");
	foreach $key (sort {$counter{$b} <=> $counter{$a} || $a cmp $b} keys %counter) {
		$percent = int($counter{$key} * 100 / $lastNo);
		if (&main::object_exists($key)) {
			&puts(sprintf(qq(<tr><td><a href="%s">%s</a></td><td>%s(%d)</td>),
					&title2url($key), &textOverLength($key, 40), $counter{$key}, ${percent}));
		}
		else {
			&puts(sprintf("<tr><td><blink>%s</blink></td><td>%s(%d%)</td>",
					&textOverLength($key, 40), $counter{$key}, ${percent}));
		}
		&puts(sprintf(qq(<td><table class="counterLine" border="0" height="15"><tr><td width="%s" bgcolor="red"></td></tr></table></td>),
				$percent * 6))
		&puts("</tr>");
	}
	&puts("</table>");
};

sub viewReferer {
	my (@logLines) = @_;
	my $URL = sprintf('http://%s%s', $ENV{'HTTP_HOST'}, $ENV{'SCRIPT_NAME'});

	my ($lastNo,$lastPageName,$lastReferer,$lastDatetime,$lastClientHost,$lastUserAgent,$lastSearchWord) = (split(/<>/, $logLines[0]))[0,1,2,3,4,5,6];
	my %refCounter = ();
	foreach $logItem (@logLines) {
		my ($no,$pageName,$referer,$datetime,$clientHost,$userAgent,$searchWord) = (split(/<>/, $logItem))[0..6];

		if (index($referer, $URL) == 0) {
			$referer = 'ڡ';
		}
		if (exists $refCounter{$referer}) {
			$refCounter{$referer}++;
		}
		else {
			$refCounter{$referer} = 1;
		}
	}
	&puts("<table>");
	foreach $key (sort {$refCounter{$b} <=> $refCounter{$a} || $a cmp $b} keys %refCounter) {
		$percent = int($refCounter{$key} * 100 / $lastNo);
		if ($key eq 'DIRECT_ACCESS' or $key eq 'ڡ') {
			&puts(sprintf(qq(<tr><td>%s</td><td>%s(%d%)</td>),
					$key, $refCounter{$key}, $percent));
		}
		else {
			&puts(sprintf(qq(<tr><td><a href="%s">%s</a></td><td>%s(%d%)</td>),
					$key, &textOverLength($key, 40), $refCounter{$key}, $percent));
		}
		&puts(sprintf(qq(<td><table class="counterLine" border="0" height="15"><tr><td width="%s" bgcolor="red"></td></tr></table></td>),
				$percent * 6))
		&puts("</tr>");
	}
	&puts("</table>");
};

sub viewClient {
	my (@logLines) = @_;
	my ($lastNo,$lastPageName,$lastReferer,$lastDatetime,$lastClientHost,$lastUserAgent,$lastSearchWord) = (split(/<>/, $logLines[0]))[0,1,2,3,4,5,6];
	my %clientCounter = ();
	foreach $logItem (@logLines) {
		my ($no,$pageName,$referer,$datetime,$clientHost,$userAgent,$searchWord) = (split(/<>/, $logItem))[0..6];
		if (exists $clientCounter{$clientHost}) {
			$clientCounter{$clientHost}++;
		}
		else {
			$clientCounter{$clientHost} = 1;
		}
	}
	&puts("<table>");
	foreach $key (sort {$clientCounter{$b} <=> $clientCounter{$a} || $a cmp $b} keys %clientCounter) {
		$percent = int($clientCounter{$key} * 100 / $lastNo);
		&puts("<tr><td>${key}</td><td>$clientCounter{$key}(${percent}%)</td>");
		&puts(sprintf(qq(<td><table class="counterLine" border="0" height="15"><tr><td width="%s" bgcolor="red"></td></tr></table></td>),
				$percent * 6))
		&puts("</tr>");
	}
	&puts("</table>");
};

sub viewUserAgent {
	my (@logLines) = @_;
	my ($lastNo,$lastPageName,$lastReferer,$lastDatetime,$lastClientHost,$lastUserAgent,$lastSearchWord) = (split(/<>/, $logLines[0]))[0,1,2,3,4,5,6];
	my %userAgentCounter = ();
	foreach $logItem (@logLines) {
		my ($no,$pageName,$referer,$datetime,$clientHost,$userAgent,$searchWord) = (split(/<>/, $logItem))[0..6];
		if (exists $userAgentCounter{$userAgent}) {
			$userAgentCounter{$userAgent}++;
		}
		else {
			$userAgentCounter{$userAgent} = 1;
		}
	}
	&puts("<table>");
	foreach $key (sort {$userAgentCounter{$b} <=> $userAgentCounter{$a} || $a cmp $b} keys %userAgentCounter) {
		$percent = int($userAgentCounter{$key} * 100 / $lastNo);
		&puts("<tr><td>${key}</td><td>$userAgentCounter{$key}(${percent}%)</td>");
		&puts(sprintf(qq(<td><table class="counterLine" border="0" height="15"><tr><td width="%s" bgcolor="red"></td></tr></table></td>),
				$percent * 6))
		&puts("</tr>");
	}
	&puts("</table>");
};

sub viewSearch {
	my (@logLines) = @_;
	my ($lastNo,$lastPageName,$lastReferer,$lastDatetime,$lastClientHost,$lastUserAgent,$lastSearchWord) = (split(/<>/, $logLines[0]))[0,1,2,3,4,5,6];
	my $searchCount = 0;
	my %searchCounter = ();
	foreach $logItem (@logLines) {
		my ($no,$pageName,$referer,$datetime,$clientHost,$userAgent,$searchWord) = (split(/<>|\n/, $logItem))[0..6];
		if ($searchWord ne '') {
			$searchCount++;
			$searchWord = &textSort($searchWord);
			if (exists $searchCounter{$searchWord}) {
				$searchCounter{$searchWord}++;
			}
			else {
				$searchCounter{$searchWord} = 1;
			}
		}
	}
	&puts("<table>");
	foreach $key (sort {$searchCounter{$b} <=> $searchCounter{$a} || $a cmp $b} keys %searchCounter) {
		if ($searchCount == 0) {
			$percent = 0;
		}
		else {
			$percent = int($searchCounter{$key} * 100 / $searchCount);
		}
		&puts("<tr><td>${key}</td><td>$searchCounter{$key}(${percent}%)</td>");
		&puts(sprintf(qq(<td><table class="counterLine" border="0" height="15"><tr><td width="%s" bgcolor="red"></td></tr></table></td>),
				$percent * 6))
		&puts("</tr>");
	}
	&puts("</table>");
};

sub viewSearchWord {
	my (@logLines) = @_;
	my ($lastNo,$lastPageName,$lastReferer,$lastDatetime,$lastClientHost,$lastUserAgent,$lastSearchWord) = (split(/<>/, $logLines[0]))[0,1,2,3,4,5,6];
	my $searchCount = 0;
	my %searchCounter = ();
	foreach $logItem (@logLines) {
		my ($no,$pageName,$referer,$datetime,$clientHost,$userAgent,$searchWord) = (split(/<>|\n/, $logItem))[0..6];
		if ($searchWord ne '') {
			my @searchWords = split(/\s|\xA1\xA1/, $searchWord);
			foreach $word (@searchWords) {
				$searchCount++;
				if (exists $searchCounter{$word}) {
					$searchCounter{$word}++;
				}
				else {
					$searchCounter{$word} = 1;
				}
			}
		}
	}
	&puts("<table>");
	foreach $key (sort {$searchCounter{$b} <=> $searchCounter{$a} || $a cmp $b} keys %searchCounter) {
		if ($searchCount == 0) {
			$percent = 0;
		}
		else {
			$percent = int($searchCounter{$key} * 100 / $searchCount);
		}
		&puts("<tr><td>${key}</td><td>$searchCounter{$key}(${percent}%)</td>");
		&puts(sprintf(qq(<td><table class="counterLine" border="0" height="15"><tr><td width="%s" bgcolor="red"></td></tr></table></td>),
				$percent * 6))
		&puts("</tr>");
	}
	&puts("</table>");
};

## ʸ򥹥ڡ(Ⱦ/)ڤʬȤȾѥڡǷҤ ##
sub textSort {
	my ($targetText) = @_;
	my @targetTexts = split(/\s|\xA1\xA1/, $targetText);
	@targetTexts = sort(@targetTexts);
	return join(' ', @targetTexts);
};

## ʸʸǥåȤ(ޥХ̤б) ##
sub textOverLength {
	my ($targetText, $targetLength) = @_;
	if (length($targetText) > $targetLength) {
		$targetText = substr($targetText, 0, $targetLength) . '...';
	}
	return $targetText;
};

1;