/*
 * Decompiled with CFR 0.152.
 */
package lll.l4p5;

import lll.Loc.Loc;
import lll.Loc.Rod;
import processing.core.PApplet;
import processing.core.PImage;

public class l4p5 {
    static PApplet p5;

    public static void lsetup(PApplet parent) {
        p5 = parent;
    }

    public static void lline(Loc f, Loc t) {
        p5.line(f.x, f.y, f.z, t.x, t.y, t.z);
    }

    public static void lline2D(Loc f, Loc t) {
        p5.line(f.x, f.y, t.x, t.y);
    }

    public static void lline(Rod r) {
        l4p5.lline(r.stern(), r.bow());
    }

    public static void lline2D(Rod r) {
        l4p5.lline(r.stern(), r.bow());
    }

    public static void lvertex(Loc l) {
        p5.vertex(l.x, l.y, l.z);
    }

    public static void lvertex(Loc l, float u, float v) {
        p5.vertex(l.x, l.y, l.z, u, v);
    }

    public static void lvertex2D(Loc l) {
        p5.vertex(l.x, l.y);
    }

    public static void lvertex2D(Loc l, float u, float v) {
        p5.vertex(l.x, l.y, u, v);
    }

    public static void lbezierVertex(Loc l, Loc m, float x, float y, float z) {
        p5.bezierVertex(l.x, l.y, l.z, m.x, m.y, m.z, x, y, z);
    }

    public static void lbezierVertex2D(Loc l, Loc m, float x, float y) {
        p5.bezierVertex(l.x, l.y, m.x, m.y, x, y);
    }

    public static void lellipse(Loc l, float width, float height) {
        p5.ellipse(l.x, l.y, width, height);
    }

    public static void lellipse(Rod r) {
        Loc b = r.fore().scale(r.length());
        l4p5.lellipse(r.stern(), b.x, b.y);
    }

    public static void lrect(Loc l, float width, float height) {
        p5.rect(l.x, l.y, width, height);
    }

    public static void lrect(Rod r) {
        Loc b = r.fore().scale(r.length());
        l4p5.lrect(r.stern(), b.x, b.y);
    }

    public static void lpoint(Loc l) {
        p5.point(l.x, l.y, l.z);
    }

    public static void lpoint2D(Loc l) {
        p5.point(l.x, l.y);
    }

    public static void lbox(Loc l, float width, float height, float depth) {
        p5.pushMatrix();
        p5.translate(l.x, l.y, l.z);
        p5.box(width, height, depth);
        p5.popMatrix();
    }

    public static void lbox(Rod r) {
        Loc b = r.fore().scale(r.length());
        l4p5.lbox(r.stern(), b.x, b.y, b.z);
    }

    public static void lsphere(Loc l, float radius) {
        p5.pushMatrix();
        p5.translate(l.x, l.y, l.z);
        p5.sphere(radius);
        p5.popMatrix();
    }

    public static void lsphere(Rod r) {
        l4p5.lsphere(r.stern(), r.length());
    }

    public static void lpolygon(Loc[] at) {
        p5.beginShape();
        int i = 0;
        while (i < at.length) {
            l4p5.lvertex(at[i]);
            ++i;
        }
        p5.endShape(2);
    }

    public static void lpolygon(Loc[] at, PImage img) {
        p5.beginShape();
        p5.textureMode(1);
        p5.texture(img);
        Loc lt = new Loc(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, 0.0f);
        Loc rb = new Loc(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, 0.0f);
        int i = 0;
        while (i < at.length) {
            lt.move(Math.min(lt.x, at[i].x), Math.min(lt.y, at[i].y), 0.0f);
            rb.move(Math.max(rb.x, at[i].x), Math.max(rb.y, at[i].y), 0.0f);
            ++i;
        }
        i = 0;
        while (i < at.length) {
            float u = (at[i].x - rb.x) / (lt.x - rb.x);
            float v = (at[i].y - rb.y) / (lt.y - rb.y);
            l4p5.lvertex(at[i], u, v);
            ++i;
        }
        p5.endShape(2);
    }

    public static void ltmdSphere(float rad, PImage img) {
        l4p5.ltmdCapsule(32, rad, img);
    }

    public static void ltmdOctahedron(float rad, PImage img) {
        l4p5.ltmdCapsule(4, rad, img);
    }

    public static void ltmdBarrel(float rad, PImage img) {
        l4p5.ltmdCapsule(6, rad, img);
    }

    public static void ltmdCapsule(int dim, float rad, PImage img) {
        Loc l = new Loc();
        p5.textureMode(1);
        p5.noStroke();
        p5.beginShape(129);
        p5.texture(img);
        float dlt = (float)Math.PI * 2 / (float)dim;
        int it = 0;
        while (it < dim) {
            float lt = (float)it * dlt;
            int ig = 0;
            while (ig <= dim / 2) {
                float lg = (float)ig * dlt - 1.5707964f;
                l.movePolar(rad, lg, lt);
                l4p5.lvertex(l, lt / ((float)Math.PI * 2), (lg + 1.5707964f) / (float)Math.PI);
                l.movePolar(rad, lg, lt + dlt);
                l4p5.lvertex(l, (lt + dlt) / ((float)Math.PI * 2), (lg + 1.5707964f) / (float)Math.PI);
                ++ig;
            }
            ++it;
        }
        p5.endShape();
        p5.stroke(0);
    }

    public static void ltmdBox(float len, PImage img) {
        l4p5.ltmdTube(4, (float)((double)len / Math.sqrt(2.0) * 8.0 / 7.0), len * 8.0f / 7.0f, img);
    }

    public static void ltmdHexapole(float rad, float len, PImage img) {
        l4p5.ltmdTube(6, rad, len, img);
    }

    public static void ltmdTube(int dim, float rad, float len, PImage img) {
        float lt;
        Loc l = new Loc();
        p5.textureMode(1);
        p5.noStroke();
        p5.beginShape(129);
        p5.texture(img);
        float dlt = (float)Math.PI * 2 / (float)dim;
        float h = len / 2.0f;
        float h1 = rad / (len + 6.0f * rad);
        float h2 = 1.0f - h1;
        int it = 0;
        while (it <= dim) {
            lt = (float)it * dlt;
            l.move(0.0f, 0.0f, h);
            l4p5.lvertex(l, lt / ((float)Math.PI * 2), 0.0f);
            l.movePolar(rad, 0.0f, lt).shift(0.0f, 0.0f, h);
            l4p5.lvertex(l, lt / ((float)Math.PI * 2), h1);
            ++it;
        }
        it = 0;
        while (it <= dim) {
            lt = (float)it * dlt;
            l.movePolar(rad, 0.0f, lt).shift(0.0f, 0.0f, h);
            l4p5.lvertex(l, lt / ((float)Math.PI * 2), h1);
            l.movePolar(rad, 0.0f, lt).shift(0.0f, 0.0f, -h);
            l4p5.lvertex(l, lt / ((float)Math.PI * 2), h2);
            ++it;
        }
        it = 0;
        while (it <= dim) {
            lt = (float)it * dlt;
            l.movePolar(rad, 0.0f, lt).shift(0.0f, 0.0f, -h);
            l4p5.lvertex(l, lt / ((float)Math.PI * 2), h2);
            l.move(0.0f, 0.0f, -h);
            l4p5.lvertex(l, lt / ((float)Math.PI * 2), 1.0f);
            ++it;
        }
        p5.endShape();
        p5.stroke(0);
    }

    public static void ltmdTetra(float len, PImage img) {
        l4p5.ltmdCone(3, len, (float)((double)len * Math.sqrt(2.0)), img);
    }

    public static void ltmdCone(float rad, float len, PImage img) {
        l4p5.ltmdCone(24, rad, len, img);
    }

    public static void ltmdCone(int dim, float rad, float len, PImage img) {
        float lt;
        Loc l = new Loc();
        p5.textureMode(1);
        p5.noStroke();
        p5.beginShape(129);
        p5.texture(img);
        float dlt = (float)Math.PI * 2 / (float)dim;
        float h = len / 2.0f;
        float h1 = len / (len + rad / 3.0f);
        int it = 0;
        while (it <= dim) {
            lt = (float)it * dlt;
            l.move(0.0f, 0.0f, h);
            l4p5.lvertex(l, lt / ((float)Math.PI * 2), 0.0f);
            l.movePolar(rad, 0.0f, lt).shift(0.0f, 0.0f, -h);
            l4p5.lvertex(l, lt / ((float)Math.PI * 2), h1);
            ++it;
        }
        it = 0;
        while (it <= dim) {
            lt = (float)it * dlt;
            l.movePolar(rad, 0.0f, lt).shift(0.0f, 0.0f, -h);
            l4p5.lvertex(l, lt / ((float)Math.PI * 2), h1);
            l.move(0.0f, 0.0f, -h);
            l4p5.lvertex(l, lt / ((float)Math.PI * 2), 1.0f);
            ++it;
        }
        p5.endShape();
        p5.stroke(0);
    }
}

