/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.tanukisoftware.wrapper.test.Main;

public class Memory
implements Runnable {
    private Writer m_writer;
    private Thread m_runner;
    private static final String PADDING = "                ";

    public void run() {
        long startTime;
        if (this.m_runner != null) {
            System.out.println(Main.getRes().getString("Stopping..."));
            this.m_runner = null;
            return;
        }
        this.m_runner = Thread.currentThread();
        long lastTest = startTime = System.currentTimeMillis();
        try {
            this.m_writer.write(Main.getRes().getString("--> Starting Memory Log\n"));
            this.m_writer.flush();
            while (this.m_runner != null) {
                long now = System.currentTimeMillis();
                System.out.println(Main.getRes().getString("Running for {0}ms...", (Object)new Long(now - startTime)));
                if (now - lastTest > 15000L) {
                    Runtime rt = Runtime.getRuntime();
                    System.gc();
                    long totalMemory = rt.totalMemory();
                    long freeMemory = rt.freeMemory();
                    long usedMemory = totalMemory - freeMemory;
                    this.m_writer.write(Main.getRes().getString("total memory=") + this.pad(totalMemory, 10) + Main.getRes().getString(", used=") + this.pad(usedMemory, 10) + Main.getRes().getString(", free=") + this.pad(freeMemory, 10) + "\n");
                    this.m_writer.flush();
                    lastTest = now;
                }
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {}
            }
            this.m_writer.write(Main.getRes().getString("<-- Stopping Memory Log\n"));
            this.m_writer.flush();
            this.m_writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String pad(long n, int len) {
        String s = Long.toString(n);
        int sLen = s.length();
        if (sLen < len) {
            s = s + PADDING.substring(0, len - sLen);
        }
        return s;
    }

    public static void main(String[] args) {
        Method addShutdownHookMethod;
        System.out.println(Main.getRes().getString("Memory Tester Running..."));
        try {
            addShutdownHookMethod = Runtime.class.getMethod("addShutdownHook", Thread.class);
        }
        catch (NoSuchMethodException e) {
            System.out.println(Main.getRes().getString("Shutdown hooks not supported by current JVM."));
            addShutdownHookMethod = null;
        }
        Memory app = new Memory();
        try {
            app.m_writer = new FileWriter("memory.log");
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (addShutdownHookMethod != null) {
            Runtime runtime = Runtime.getRuntime();
            Thread hook = new Thread((Runnable)app, "shutdown-hook");
            try {
                addShutdownHookMethod.invoke((Object)runtime, hook);
            }
            catch (IllegalAccessException e) {
                System.out.println(Main.getRes().getString("Unable to register shutdown hook: {0}", (Object)e.getMessage()));
            }
            catch (InvocationTargetException e) {
                System.out.println(Main.getRes().getString("Unable to register shutdown hook: {0}", (Object)e.getMessage()));
            }
        }
        new Thread((Runnable)app, "runner").start();
    }
}

