/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import org.tanukisoftware.wrapper.WrapperManager;

public class LongRunningBackgroundThreads
implements Runnable {
    private volatile int _threadCount;

    public void run() {
        ++this._threadCount;
        int loops = 0;
        while (loops < 10) {
            System.out.println(Thread.currentThread().getName() + " loop #" + ++loops);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        System.out.println(Thread.currentThread().getName() + " stopping.");
        if (--this._threadCount <= 0) {
            System.out.println("The JVM and then the wrapper should exit now.");
        }
    }

    public static void main(String[] args) {
        System.out.println("Long-running Background Threads Running...");
        LongRunningBackgroundThreads app = new LongRunningBackgroundThreads();
        for (int i = 0; i < 2; ++i) {
            Thread thread = new Thread((Runnable)app, "App-Thread-" + i);
            thread.start();
        }
        System.out.println("Running as a service: " + WrapperManager.isLaunchedAsService());
        System.out.println("Controlled by wrapper: " + WrapperManager.isControlledByNativeWrapper());
        System.out.println("Long-running Background Threads Main Done...");
    }
}

