<?php
/* ==================================================
 *   Ktai_Style_Admin_Templates class
   ================================================== */

define ('KS_MAX_TEXTAREA_LENGTH_KDDI', 1024);

if (! defined('ABSPATH')) {
	exit;
}

class Ktai_Style_Admin_Templates extends Ktai_Style_Admin {

function __construct() {
	parent::__construct();
	if ($this->base->check_wp_version(2.6)) {
		add_filter('get_edit_post_link', array($this, 'fix_edit_post_link'), 10, 3);
	} else {
		add_filter('get_edit_post_link', array($this, 'fix_edit_post_link'), 10, 2);
	}
	add_filter('get_edit_comment_link', array($this, 'fix_edit_comment_link'));
	add_filter('get_comment_excerpt', array($this, 'shrink_comment_excerpt'), 99);
}

/* ==================================================
 * @param	string  $action
 * @return	none
 */
public function nonce_ays($action) {
	global $pagenow;

	if ( $this->get_referer() ) {
		$adminurl = clean_url($this->get_referer());
		if (! preg_match('/' . KS_SESSION_NAME . '=/', $adminurl)) {
			$adminurl = $this->add_sid($adminurl);
		}
	} else {
		$adminurl = $this->add_sid(ks_admin_url(false));
	}
	
	$title = $this->base->encode_for_ktai(__('WordPress Confirmation', 'ktai_style'));
	list ($desc, $allow_proceed) = $this->explain_nonce($action);
	if ($allow_proceed) {
		$no  = __('No');
		$yes = __('Yes');
	} else {
		$no  = __('Back', 'ktai_style');
	}
	// Remove extra layer of slashes.
	$_POST = stripslashes_deep($_POST);
	if ($_POST) {
		$q = http_build_query($_POST);
		$q = explode( ini_get('arg_separator.output'), $q);
		$html .= '<form method="post" action="' . clean_url($pagenow) . '"><input type="hidden" name="' . KS_SESSION_NAME . '" value="' . attribute_escape($this->sid) . '" />';
		foreach ( (array) $q as $a ) {
			$v = substr(strstr($a, '='), 1);
			$k = substr($a, 0, -(strlen($v)+1));
			$html .= '<input type="hidden" name="' . attribute_escape(urldecode($k)) . '" value="' . attribute_escape(urldecode($v)) . '" />';
		}
		$add_html = '<input type="hidden" name="_wpnonce" value="' . wp_create_nonce($action) . '" /><p>' . wp_specialchars($desc) . '<br /><a href="' . $adminurl . '">' . $no . '</a>' . ($allow_proceed ? ' <input type="submit" value="' . $yes . '" />' : '') . '</div></form>';
	} else {
		$add_html = '<p>' . wp_specialchars($desc) . '<br /><a href="' . $adminurl . '">' . $no. '</a>' . ($allow_proceed ? ' <a href="' . clean_url(add_query_arg('_wpnonce', wp_create_nonce($action), $_SERVER['REQUEST_URI'])) . '">' . $yes . '</a>' : '') . ' </p>';
	}
	$html .= $this->base->encode_for_ktai($add_html);
	$this->base->ks_die($html, $title, false, true);
}

/* ==================================================
 * @param	string  $action
 * @return	string  $desc
 * @return	boolean $allow_proceed
 */
private function explain_nonce($action) {
	global $KS_Shrinkage;
	remove_filter('the_title', array($KS_Shrinkage, 'shrink_title'), 90);
	if ( $action === -1 || ! preg_match('/([a-z]+)-([a-z]+)(_(.+))?/', $action, $matches) ) {
		return;
	}
	$verb = $matches[1];
	$noun = $matches[2];
	$trans = array();
	$trans['change']['cats'] = array(__('Are you sure you want to change categories of this post: &quot;%s&quot;?', 'ktai_style'), 'get_the_title');
	$trans['unapprove']['comment'] = array(__('Are you sure you want to unapprove the comment: &quot;%s&quot;?', 'ktai_style'), 'use_id');
	$trans['approve']['comment'] = array(__('Are you sure you want to approve the comment: &quot;%s&quot;?', 'ktai_style'), 'use_id');
	$trans['delete']['comment'] = array(__('Are you sure you want to delete the comment: &quot;%s&quot;?', 'ktai_style'), 'use_id');
	$trans['delete']['post'] = array(__('Are you sure you want to delete this post: &quot;%s&quot;?', 'ktai_style'), 'get_the_title');
	$trans['delete']['page'] = array(__('Are you sure you want to delete this page: &quot;%s&quot;?', 'ktai_style'), 'get_the_title');
	$trans['bulk']['spamdelete'] = array(__('Are you sure you want to delete all spam?', 'ktai_style'));

	if ( isset($trans[$verb][$noun]) ) {
		if (! empty($trans[$verb][$noun][1]) ) {
			$lookup = $trans[$verb][$noun][1];
			$object = $matches[4];
			if ('use_id' != $lookup) {
				$object = call_user_func($lookup, $object);
			}
			$desc = sprintf($trans[$verb][$noun][0], $object);
		} else {
			$desc = $trans[$verb][$noun][0];
		}
		$allow_proceed = true;
	} else {
		$desc = wp_explain_nonce($action);
		$allow_proceed = false;
	}
	return array($desc, $allow_proceed);
}

/* ==================================================
 * @param	string  $uri
 * @param	int     $id
 * @param	string  $context
 * @return	string  $uri
 */
public function fix_edit_post_link($uri, $id, $context = NULL) {
	if (is_null($context)) {
		$uri = str_replace('&amp;', '&', $uri);
	}
	if (function_exists('admin_url')) {
		$pc_admin = admin_url();
	} else {
		$pc_admin = get_bloginfo('wpurl') . '/wp-admin/';
	}
	return preg_replace('|^' . preg_quote($pc_admin) . '|', $this->base->get('plugin_url') . KS_ADMIN_DIR . '/', $uri);
}

/* ==================================================
 * @param	string  $uri
 * @return	string  $uri
 */
public function fix_edit_comment_link($uri) {
	if (function_exists('admin_url')) {
		$pc_admin = admin_url();
	} else {
		$pc_admin = get_bloginfo('wpurl') . '/wp-admin/';
	}
	return preg_replace('|^' . preg_quote($pc_admin) . '|', $this->base->get('plugin_url') . KS_ADMIN_DIR . '/', $uri);
}

/* ==================================================
 * @param	string  $excerpt
 * @return	string  $excerpt
 */
public function shrink_comment_excerpt($excerpt) {
	global $comment;
	$comment_text = $comment->comment_content;
	$comment_text = preg_replace('#<blockquote>.*?<blockquote>.*?</blockquote>.*?</blockquote>#s', __('--omitting quote--', 'ktai_style'), $comment_text); 
	$comment_text = preg_replace('#<blockquote>.*?</blockquote>#s', __('--omitting quote--', 'ktai_style'), $comment_text); 
	$blah = explode(' ', strip_tags($comment_text));
	if (count($blah) > 20) {
		$k = 20;
		$use_dotdotdot = 1;
	} else {
		$k = count($blah);
		$use_dotdotdot = 0;
	}
	$excerpt = '';
	for ($i=0; $i<$k; $i++) {
		$excerpt .= $blah[$i] . ' ';
	}
	$excerpt .= ($use_dotdotdot) ? '...' : '';
	return $excerpt;
}

/* ==================================================
 * @param	string  $name
 * @param	int     $selected
 * @return	string  $html
 */
public function dropdown_categories($name = 'default_category', $selected = 0) {
	global $wpdb;
	$html = '';
	$categories = get_categories('get=all');
	if (count($categories) < 1) {
		return $html;
	}
	$html .= '<select name="' . htmlspecialchars($name, ENT_QUOTES) . '">';
	foreach ($categories as $c) {
		$cat_id = isset($c->term_id) ? $c->term_id : $c->cat_ID;
		$html .= '<option value="' . intval($cat_id) . '"' . ($selected == $cat_id ? ' selected="selected"' : '') . '>' . wp_specialchars($c->cat_name) . '</option>';
	}
	$html .= '</select>';
	return $html;
}


/* ==================================================
 * @param	string  $urk
 * @param	int     $id
 * @return	string  $context
 */
public function draft_or_post_title($post_id = 0) {
	$title = get_the_title($post_id);
	if ( empty($title) )
		$title = __('(no title)');
	return $title;
}

/* ==================================================
 * @param	object  $post
 * @return	string  $states
 * based on _post_states() at wp-admin/includes/template.php of WP 2.7
 */
public function get_post_states($post) {
	$post_states = array();
	if ( isset($_GET['post_status']) )
		$post_status = $_GET['post_status'];
	else
		$post_status = '';

	if ( !empty($post->post_password) )
		$post_states[] = __('Password protected', 'ktai_style');
	if ( 'private' == $post->post_status && 'private' != $post_status )
		$post_states[] = __('Private');
	if ( 'draft' == $post->post_status && 'draft' != $post_status )
		$post_states[] = __('Draft');
	if ( 'pending' == $post->post_status && 'pending' != $post_status )
		$post_states[] = __('Pending', 'ktai_style');

	if ( ! empty($post_states) ) {
		return ' - <small>' . implode(',', $post_states) . '</small>';
	}
	return '';
}

/* ==================================================
 * @param	none
 * @return	int     $post_ID
 * based on write_post() at wp-admin/includes/post.php of WP 2.3
 */
public function write_post($post_type = 'post') {
	global $current_user;
	if ('page' == $post_type) {
		if (! current_user_can('edit_pages')) {
			$this->base->ks_die(__('You are not allowed to create pages on this blog.'));
			exit;
		}
	} elseif (! current_user_can('edit_posts')) {
		$this->base->ks_die(__('You are not allowed to create posts or drafts on this blog.'));
		exit;
	}
	$charset = ks_detect_encoding();
	$post_data = &$_POST;
	$post_data['post_date']     = current_time('mysql');
	$post_data['post_date_gmt'] = get_gmt_from_date($post_data['post_date']);
	if (! isset($post_data['post_type'])) {
		$post_data['post_type'] = $post_type;
	}
	$post_data['post_title']    = trim(strip_tags(ks_mb_get_form('post_title', $charset)));
	$post_data['post_name']     = trim(strip_tags(ks_mb_get_form('post_name', $charset)));
	$post_data['post_content']  = trim(ks_mb_get_form('content', $charset));
	if (isset($post_data['tags_input'])) {
		$post_data['tags_input'] = trim(strip_tags(ks_mb_get_form('tags_input', $charset)));
	}
	$post_data['post_excerpt']  = '';
	$post_data['post_author']   = intval($post_data['user_ID']);

	if (isset($post_data['post_cats'])) {
		$post_data['post_category'] = array_map('intval', explode(',', $post_data['post_cats']));
	}

	if (! isset( $post_data['comment_status'])) {
		$post_data['comment_status'] = 'closed';
	}
	if (! isset( $post_data['ping_status'])) {
		$post_data['ping_status'] = 'closed';
	}

	// What to do based on which button they pressed
	if (isset($post_data['publish']) && '' != $post_data['publish'] && $post_data['post_status'] != 'private') {
		$post_data['post_status'] = 'publish';
		if (empty($post_data['post_name'])) {
			$post_data['post_name'] = mysql2date('His', current_time('mysql'));
		}
	}
/*
	if (isset($post_data['advanced']) && '' != $post_data['advanced']) {
		$post_data['post_status'] = 'draft';
	}
 */
 	if ('publish' == $post_data['post_status'] && ! current_user_can('publish_posts')) {
		$post_data['post_status'] = 'pending';
	}

	if ( isset($post_data['visibility']) && 'private' == $post_data['visibility']) {
		$post_data['post_status'] = 'private';
		$post_data['post_password'] = '';
		unset( $post_data['sticky'] );
	}

	$post_ID = wp_insert_post($post_data);
	if (is_wp_error($post_ID)) {
		$this->base->ks_die($post_ID->get_error_message());
	} else {
		return $post_ID;
	}
}

/* ==================================================
 * @param	none
 * @return	int     $post_ID
 * based on edit_post() at wp-admin/includes/post.php of WP 2.3
 */
public function edit_post($post_ID, $post_type = 'post') {
	global $current_user;
	if (! $post_ID) {
		$this->base->ks_die(__("You attempted to edit a post that doesn't exist. Perhaps it was deleted?"));
		exit;
	} elseif ('page' == $post_type) {
		if (! current_user_can('edit_page', $post_ID)) {
			$this->base->ks_die(__('You are not allowed to edit this page.'));
			exit;
		}
	} elseif (! current_user_can('edit_post', $post_ID)) {
		$this->base->ks_die(__('You are not allowed to edit this post.'));
		exit;
	}
	$post = wp_get_single_post($post_ID, ARRAY_A);
	$charset = ks_detect_encoding();
	$post_data = &$_POST;
	$post_data['ID']            = intval($post_ID);
	if (! isset($post_data['post_type'])) {
		$post_data['post_type'] = $post_type;
	}
	$post_data['post_title']    = trim(strip_tags(ks_mb_get_form('post_title', $charset)));
	$post_data['post_name']     = trim(strip_tags(ks_mb_get_form('post_name', $charset)));
	$post_data['post_content']  = trim(ks_mb_get_form('content', $charset));
	$post_data['post_parent']   = isset($post_data['parent_id']) ? intval($post_data['parent_id']) : '';
	if (isset($post_data['tags_input'])) {
		$post_data['tags_input'] = trim(ks_mb_get_form('tags_input', $charset));
	}	
	if ($post['post_author'] != $current_user->ID) {
		if ('page' == $post_type) {
			if (! current_user_can('edit_others_pages')) {
				$this->base->ks_die(__('You are not allowed to edit pages as this user.'));
			}
		} elseif (! current_user_can('edit_others_posts')) {
			$this->base->ks_die(__('You are not allowed to edit posts as this user.'));
		}
	}
	if (isset($post_data['post_cats'])) {
		$post_data['post_category'] = array_map('intval', explode(',', $post_data['post_cats']));
	}

	if (! isset( $post_data['comment_status'])) {
		$post_data['comment_status'] = 'closed';
	}
	if (! isset( $post_data['ping_status'])) {
		$post_data['ping_status'] = 'closed';
	}

	// What to do based on which button they pressed
	if (isset($post_data['publish']) && '' != $post_data['publish']) {
		$post_data['post_status'] = 'publish';
		if (empty($post_data['post_name'])) {
			$post_data['post_name'] = $post->post_name ? $post->post_name : mysql2date('His', current_time('mysql'));
		}
	}
	$previous_status = get_post_field('post_status',  isset($post_data['ID']) ? $post_data['ID'] : $post_data['temp_ID']);
	if ( 'page' == $post_type ) {
		$publish_cap = 'publish_pages';
		$edit_cap = 'edit_published_pages';
	} else {
		$publish_cap = 'publish_posts';
		$edit_cap = 'edit_published_posts';
	}
	if ( isset($post_data['post_status']) && ('publish' == $post_data['post_status'] && !current_user_can( $publish_cap )) ) {
		if ( $previous_status != 'publish' || !current_user_can( $edit_cap ) )
			$post_data['post_status'] = 'pending';
	}
	if ( ! isset($post_data['post_status']) ) {
		$post_data['post_status'] = $previous_status;
	}

	if ( isset($post_data['visibility']) && 'private' == $post_data['visibility']) {
		$post_data['post_status'] = 'private';
		$post_data['post_password'] = '';
		unset( $post_data['sticky'] );
	}

	wp_update_post( $post_data );
	return intval($post_ID);
}

/* ==================================================
 * @param	string   $content
 * @param	int      $tab_index
 * @param	int      $rows
 * @return	none
 */
public function the_editor($content, $rows = 8, $tab_index = 4) {
	global $Ktai_Style;
	if ($rows < 1 || $rows > 100) {
		$rows = 8;
	}
	if ($tab_index < 1 || $tab_index > 100) {
		$tab_index = 4;
	}
	if (user_can_richedit()) { // Make sure the browsers which can use rich edit
		add_filter('the_editor_content', 'wp_htmledit_pre');
	}
	$the_editor = '<textarea cols="40" rows="' . intval($rows) . '" name="content" tabindex="' . intval($tab_index) . '">%s</textarea><br />';
	// $the_editor = apply_filters('the_editor', $the_editor);
	$the_editor_content = apply_filters('the_editor_content', $content);
	printf($the_editor, $the_editor_content);
	if ($Ktai_Style->is_ktai() == 'KDDI' && strlen($Ktai_Style->encode_for_ktai($the_editor_content)) >= KS_MAX_TEXTAREA_LENGTH_KDDI) {
		?><font color="red"><img localsrc="1" alt="!" /><?php 
		_e('The content is too big is chopped to fit in the form. If you save changes, part of the content may be lost. Please back to previous page.', 'ktai_style');
		?></font><br /><?php
	}
}

/* ==================================================
 * @param	int      $current
 * @param	int      $total
 * @return	none
 */
public function nav_link($current, $total, $query = 'paged') {
	$link = remove_query_arg(array($query, 'filter', 'action', 'wpnonce'));
	$nav = '';
	if ($current > 1) {
		$nav .= '<a href="' . add_query_arg($query, $current - 1, $link) . '" accesskey="*">' . 
		__('<img localsrc="7" alt="&laquo;" />Previous Page', 'ktai_style') . 
		'</a>';
	}
	if ($current < $total) {
		if ($nav) {
			$nav .= ' | ';
		}
		$nav .= '<a href="' . add_query_arg($query, $current + 1, $link) . '" accesskey="#">' . 
		__('Next Page<img localsrc="8" alt="&raquo;" />', 'ktai_style') . 
		'</a>';
	}
	if ($nav) {
		echo '<p align="center">' . $nav . '</p>';
	}
}

/* ==================================================
 * @param	int      $current
 * @param	int      $total
 * @return	none
 */
public function nav_dropdown($current, $total, $query = 'paged') {
	if ($total == 2) {
		$this->nav_link($current, $total, $query);
	} else {
		ks_posts_nav_dropdown(array(
			'before' => '<div align="center">',
			'after' => '<br /></div>',
			'min_pages' => 3,
			'show_all_limit' => 9,
			'paged' => $current,
			'max_pages' => $total,
			'id' => $query,
			'baseurl' => remove_query_arg(array($query, 'filter', 'action', 'wpnonce')),
		));
	}
}

// ===== End of class ====================
}

/* ==================================================
 *   KS_Category_Checklist class
 *   based on class Walker_Category_Checklist at wp-admin/includes/template.php of WP 2.5.1
   ================================================== */

class KS_Category_Checklist extends Walker {
	public $tree_type = 'category';
//	public $db_fields = array ('parent' => 'parent', 'id' => 'term_id');
	public $db_fields = array ('parent' => 'category_parent', 'id' => 'cat_ID');

	function start_lvl(&$output, $depth, $args) {
		return '';
	}

	function end_lvl(&$output, $depth, $args) {
		return '';
	}

	function start_el(&$output, $category, $depth, $args) {
		extract($args);

		$output .= '<dt>' . '<label><input value="' . $category->cat_ID . '" type="checkbox" name="cat[]" ' 
		. (in_array( $category->cat_ID, $selected_cats ) ? ' checked="checked"' : "" ) . '/> ' 
		. wp_specialchars( apply_filters('the_category', $category->cat_name )) . '</label>';
		return $output;
	}

	function end_el(&$output, $category, $depth, $args) {
		$output .= '</dt>';
		return $output;
	}
}
?>