<?php 
/* 
Plugin Name: Tigers 2008 Countdown
Plugin URI: http://wppluginsj.sourceforge.jp/tigers2008/
Description: Counting down magic numbers of the championship of central league baseball for Hanshin Tigers
Author: IKEDA yuriko
Version: 0.8.5
Author URI: http://www.yuriko.net/cat/wordpress/
*/

/*  Copyright (c) 2008 yuriko

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

$Tigers2008 = new Tigers2008;
define('WIDGET_TIGERS_MAX_NUMBER', 45);
define('WIDGET_TIGERS_LOGO_DIR', 'logos/');
define('WIDGET_TIGERS_DEFAULT_DESIGN', 'mix');

/* ==================================================
 *   Tigers2008 class
   ================================================== */

class Tigers2008 {
	var $plugin_dir;
	var $plugin_url;
	var $designs;

function Tigers2008() {
	$this->__construct();
}

function __construct() {
	$this->set_plugin_dir();
	$this->load_textdomain('tigers2008', 'lang');
	$this->designs = array(
		'mix' => __('Mix', 'tigers2008'), 
		'elec' => __('Electric', 'tigers2008'), 
		'bubble' => __('Bubble', 'tigers2008'), 
		'speedy' => __('Speedy', 'tigers2008'), 
		'dazzle' => __('Dazzle', 'tigers2008'), 
		'brick' => __('Brick', 'tigers2008'), 
		'calc' => __('Calculator', 'tigers2008'), 
		'stitch' => __('Stitch', 'tigers2008'), 
	);
	add_action('widgets_init', array($this, 'register'));
}

/* ==================================================
 * @param	none
 * @return	none
 */
//private 
function set_plugin_dir() {
	$this->plugin_dir = basename(dirname(__FILE__));
	if (defined('WP_PLUGIN_URL')) {
		$url = WP_PLUGIN_URL . '/';
	} else {
		$url = get_bloginfo('wpurl') . '/' . (defined('PLUGINDIR') ? PLUGINDIR . '/': 'wp-content/plugins/');
	}
	$this->plugin_url = $url . $this->plugin_dir . '/';
}

/* ==================================================
 * @param	string   $domain
 * @param	string   $subdir
 * @return	none
 */
// private
function load_textdomain($domain, $subdir = '') {
	if ($this->check_wp_version('2.6', '>=') && defined('WP_PLUGIN_DIR')) {
		load_plugin_textdomain($domain, false, $this->get('plugin_dir') . ($subdir ? '/' . $subdir : ''));
	} else {
		$plugin_path = defined('PLUGINDIR') ? PLUGINDIR . '/': 'wp-content/plugins/';
		load_plugin_textdomain($domain, $plugin_path . $this->get('plugin_dir') . ($subdir ? '/' . $subdir : ''));
	}
}

/* ==================================================
 * @param	string   $version
 * @param	string   $operator
 * @return	boolean  $result
 */
//public 
function check_wp_version($version, $operator = '>=') {
	$wp_vers = get_bloginfo('version');
	if (! is_numeric($wp_vers)) {
		$wp_vers = preg_replace('/[^.0-9]/', '', $wp_vers);
	}
	return version_compare($wp_vers, $version, $operator);
}

/* ==================================================
 * @param	string   $key
 * @return	boolean  $charset
 */
//public 
function get($key) {
	return isset($this->$key) ? $this->$key : NULL;
}

/* ==================================================
 * @param	none
 * @return	none
 */
//public 
function register() {
	$widget_ops = array('classname' => 'tigers2008', 'description' => __('Hanshin Tigers Magic Number Countdown', 'tigers2008') );
	wp_register_sidebar_widget('tigers2008', __('Tigers', 'tigers2008'), array($this, 'show_magic'), $widget_ops);
	wp_register_widget_control('tigers2008', __('Tigers', 'tigers2008'), array($this, 'control'));
}

/* ==================================================
 * @param	mix      $args
 * @return	none
 */
//public 
function show_magic($args) {
	extract($args);
	$options = $this->get_option();
	$title  = $options['title'];
	$design = $options['design'];
	$magic  = $options['magic'];
	if (! is_numeric($magic)) {
		return;
	}
	if ($magic === 0) {
		$design = WIDGET_TIGERS_DEFAULT_DESIGN;
	}
	$logo_file = WIDGET_TIGERS_LOGO_DIR . sprintf('%s/%02d.gif', $design, $magic);
	if (file_exists(dirname(__FILE__) . '/' . $logo_file)) {
?>
	<?php echo $before_widget; ?>
		<?php echo $before_title . wp_specialchars($title) . $after_title; ?>
		<div style="margin-top:0.75em;text-align:center;"><img src="<?php echo $this->plugin_url . $logo_file; ?>" alt="<?php printf(__('Magic Number: %d', 'tigers2008'), $magic); ?>" /></div>
	<?php echo $after_widget; ?>
<?php
	}
}

/* ==================================================
 * @param	none
 * @return	none
 */
//public 
function control() {
	$options = $this->get_option();
	$title  = $options['title'];
	$design = $options['design'];
	$magic  = $options['magic'];
	if ($_POST['magic-submit']) {
		$new_title = trim(strip_tags(stripslashes($_POST['magic-title'])));
		if ($new_title) {
			$new_option['title'] = $new_title;
			$title = $new_title;
		}
		$new_design = trim($_POST['logo-design']);
		if ($new_design && array_key_exists($new_design, $this->designs)) {
			$new_option['design'] = $new_design;
			$design = $new_design;
		}
		$new_magic = trim($_POST['magic-number']);
		if (is_numeric($new_magic) && $new_magic >= 0 && $new_magic <= WIDGET_TIGERS_MAX_NUMBER) {
			$new_magic = intval($new_magic);
			if ($new_magic != $magic || empty($magic)) {
				$new_option['magic'] = $new_magic;
				$magic = $new_magic;
			}
		} elseif (empty($new_magic)) {
			$new_option['magic'] = '';
			$magic = '';
		}
		if (isset($new_option)) {
			$this->set_option($new_option);
		}
	}
?>
	<p><label for="magic-title"><?php _e('Title:'); ?> <input class="widefat" id="magic-title" name="magic-title" type="text" value="<?php echo attribute_escape($title); ?>" /></label></p>
	<p><label for="magic-number"><?php _e('Magic Number:', 'tigers2008'); ?> <input class="widefat" id="magic-number" name="magic-number" type="text" value="<?php echo attribute_escape($magic); ?>" /></label></p>
	<p><label for="logo-design"><?php _e('Design:', 'tigers2008'); ?> <select class="widefat" id="logo-design" name="logo-design"s><?php foreach($this->designs as $k => $v) { ?>
		<option value="<?php echo attribute_escape($k); ?>"<?php selected($design, $k); ?> ><?php echo attribute_escape($v); ?></option>
	<?php } ?>
	</select></p>
	<input type="hidden" id="magic-submit" name="magic-submit" value="1" />
<?php
}

/* ==================================================
 * @param	none
 * @return	array    $options
 */
//public 
function get_option() {
	$opt_db = get_option('widget_tigers2008');
	if (isset($opt_db['magic']) && is_numeric($opt_db['magic']) && $opt_db['magic'] >= 0 && $opt_db['magic'] <= WIDGET_TIGERS_MAX_NUMBER) {
		$options['magic'] = intval($opt_db['magic']);
	} else {
		$options['magic'] = '';
	}
	$options['title'] = (isset($opt_db['title']) && ! empty($opt_db['title'])) ? $opt_db['title'] : __('Hanshin Tigers', 'tigers2008');
	$options['design'] = (isset($opt_db['design']) && array_key_exists($opt_db['design'], $this->designs)) ? $opt_db['design'] : WIDGET_TIGERS_DEFAULT_DESIGN;
	return $options;
}

/* ==================================================
 * @param	arary    $options
 * @return	none
 */
//public 
function set_option($options) {
	$opt_db = $new_opt = get_option('widget_tigers2008');
	if (isset($options['magic'])) {
		if (is_numeric($options['magic']) && $options['magic'] >= 0 && $options['magic'] <= WIDGET_TIGERS_MAX_NUMBER) {
			$new_opt['magic'] = intval($options['magic']);
		} else {
			$new_opt['magic'] = '';
		}
	}
	if (isset($options['title'])) {
		$new_opt['title'] = $options['title'];
	}
	if (isset($options['design']) && array_key_exists($options['design'], $this->designs)) {
		$new_opt['design'] = $options['design'];
	}
	if ($new_opt != $opt_db) {
		update_option('widget_tigers2008', $new_opt);
	}
	return;
}

// ===== End of class ==============================
}
?>